/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.client.glue2;

import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.DateUtil;
import eu.emi.emir.client.util.Log;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.ogf.schemas.glue._2009._03.spec_2.AccessPolicyT;
import org.ogf.schemas.glue._2009._03.spec_2.EndpointT;
import org.ogf.schemas.glue._2009._03.spec_2.ServiceT;

public class JaxbToJson {
    private static Logger logger = Log.getLogger((String)"emir.client", JaxbToJson.class);

    public static synchronized JSONArray convert(String glueXml) throws JSONException, DatatypeConfigurationException {
        if (glueXml == null || glueXml.isEmpty()) {
            logger.warn((Object)"Invalid or NULL GLUE 2.0 XML document");
            throw new IllegalArgumentException("Invalid or NULL GLUE 2.0 XML document");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(glueXml.getBytes());
        ServiceT s = (ServiceT)JAXB.unmarshal((InputStream)is, ServiceT.class);
        return JaxbToJson.convert(s);
    }

    public static synchronized JSONArray convert(ServiceT service) throws JSONException, DatatypeConfigurationException {
        if (service == null || service.getEndpoint().isEmpty()) {
            logger.warn((Object)"Invalid or NULL GLUE 2.0 XML document");
            throw new IllegalArgumentException("Invalid or NULL GLUE 2.0 XML document");
        }
        JSONArray emirJsonArr = null;
        emirJsonArr = new JSONArray();
        List lstEt = service.getEndpoint();
        ArrayList<String> lstErr = new ArrayList<String>();
        for (EndpointT ep : lstEt) {
            AccessPolicyT at;
            JSONObject emirJson = new JSONObject();
            if (service.getID() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName(), (Object)service.getID());
            } else {
                lstErr.add("Mandatory 'Service ID' attribute missing");
            }
            if (service.getName() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName(), (Object)service.getName());
            } else {
                lstErr.add("Mandatory 'Service Name' attribute missing");
            }
            if (service.getType() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_TYPE.getAttributeName(), (Object)service.getType());
            } else {
                lstErr.add("Mandatory 'Service Type' attribute missing");
            }
            if (ep.getID() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)ep.getID());
            } else {
                lstErr.add("Mandatory 'Endpoint ID' attribute missing");
            }
            if (ep.getURL() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName(), (Object)ep.getURL());
            } else {
                lstErr.add("Mandatory 'Endpoint URL' attribute missing");
            }
            if (ep.getInterfaceName() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName(), (Object)ep.getInterfaceName());
            } else {
                lstErr.add("Mandatory 'Endpoint Interface Name' attribute missing");
            }
            if (ep.getInterfaceVersion().size() > 0) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACE_VER.getAttributeName(), ep.getInterfaceVersion().get(0));
            } else {
                lstErr.add("Mandatory 'Endpoint Interface Version' attribute missing");
            }
            if (ep.getCapability().size() > 0) {
                JSONArray capArr = new JSONArray();
                for (String capability : ep.getCapability()) {
                    capArr.put((Object)capability);
                }
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_CAPABILITY.getAttributeName(), (Object)capArr);
            } else {
                lstErr.add("Mandatory 'Endpoint Capability' attribute missing");
            }
            if (ep.getTechnology() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_TECHNOLOGY.getAttributeName(), (Object)ep.getTechnology());
            } else {
                lstErr.add("Mandatory 'Endpoint Technology' attribute missing");
            }
            if (ep.getValidity() != null && ep.getValidity().intValue() > 0) {
                BigInteger sec = ep.getValidity();
                Calendar c = Calendar.getInstance();
                c.add(13, sec.intValue());
                DateUtil.addDate(emirJson, ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName(), c.getTime());
            }
            if (ep.getAccessPolicy().size() > 0 && (at = (AccessPolicyT)ep.getAccessPolicy().get(0)).getRule().size() > 0) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ACCESSPOLICY_RULE.getAttributeDesc(), at.getRule().get(0));
            }
            if (ep.getDowntimeAnnounce() != null) {
                DateUtil.addDate(emirJson, ServiceBasicAttributeNames.SERVICE_ENDPOINT_DOWNTIME_ANNOUNCE.getAttributeName(), DateUtil.fromXmlGregorian(ep.getDowntimeAnnounce()));
            }
            if (ep.getDowntimeEnd() != null) {
                DateUtil.addDate(emirJson, ServiceBasicAttributeNames.SERVICE_ENDPOINT_DOWNTIME_END.getAttributeName(), DateUtil.fromXmlGregorian(ep.getDowntimeEnd()));
            }
            if (ep.getDowntimeInfo() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_DOWNTIME_INFO.getAttributeName(), (Object)ep.getDowntimeInfo());
            }
            if (ep.getDowntimeStart() != null) {
                DateUtil.addDate(emirJson, ServiceBasicAttributeNames.SERVICE_ENDPOINT_DOWNTIME_END.getAttributeName(), DateUtil.fromXmlGregorian(ep.getDowntimeStart()));
            }
            if (ep.getHealthState() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_HEALTH_STATE.getAttributeName(), (Object)ep.getHealthState().toString());
            }
            if (ep.getHealthStateInfo() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_HEALTH_STATEINFO.getAttributeName(), (Object)ep.getHealthStateInfo().toString());
            }
            if (ep.getImplementationName() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IMPL_NAME.getAttributeName(), (Object)ep.getImplementationName());
            }
            if (ep.getImplementationVersion() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IMPL_VERSION.getAttributeName(), (Object)ep.getImplementationVersion());
            }
            if (ep.getImplementor() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IMPLEMENTOR.getAttributeName(), (Object)ep.getImplementor());
            }
            if (ep.getOtherInfo() != null && ep.getOtherInfo().size() > 0) {
                JSONArray otherInfo = new JSONArray();
                for (String info : ep.getOtherInfo()) {
                    otherInfo.put((Object)info);
                }
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_OTHER_INFO.getAttributeName(), (Object)otherInfo);
            }
            if (ep.getQualityLevel() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_QUALITYLEVEL.getAttributeName(), (Object)ep.getQualityLevel().toString());
            }
            if (ep.getSemantics() != null && ep.getSemantics().size() > 0) {
                JSONArray semantics = new JSONArray();
                for (String info : ep.getSemantics()) {
                    semantics.put((Object)info);
                }
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_SEMANTICS.getAttributeName(), (Object)semantics);
            }
            if (ep.getServingState() != null) {
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_SERVING_STATE.getAttributeName(), (Object)ep.getServingState().toString());
            }
            if (ep.getStartTime() != null) {
                DateUtil.addDate(emirJson, ServiceBasicAttributeNames.SERVICE_ENDPOINT_STARTTIME.getAttributeName(), DateUtil.fromXmlGregorian(ep.getStartTime()));
            }
            if (ep.getSupportedProfile() != null && ep.getSupportedProfile().size() > 0) {
                JSONArray profile = new JSONArray();
                for (String info : ep.getSupportedProfile()) {
                    profile.put((Object)info);
                }
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_SUPPORTED_PROFILE.getAttributeName(), (Object)profile);
            }
            if (ep.getWSDL() != null && ep.getWSDL().size() > 0) {
                JSONArray wsdl = new JSONArray();
                for (String info : ep.getWSDL()) {
                    wsdl.put((Object)info);
                }
                emirJson.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_WSDL.getAttributeName(), (Object)wsdl);
            }
            if (lstErr.size() > 0) {
                StringBuilder b = new StringBuilder();
                b.append("Incomplete Endpoint description:");
                for (String err : lstErr) {
                    b.append("\n-" + err);
                }
                b.append("\nfrom: " + service);
                logger.error((Object)b.toString());
                continue;
            }
            emirJsonArr.put((Object)emirJson);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Valid JSON created from GLUE 2.0 XML: " + emirJsonArr.toString(2)));
        }
        return emirJsonArr;
    }
}

