/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.client.util;

import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.glue2.JSONToGlue2MappingException;
import eu.emi.emir.client.util.Duration;
import eu.emi.emir.client.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DateUtil {
    public static final SimpleDateFormat ServiceDateFormat = new SimpleDateFormat("dd-mm-yyyy,HH:mm");
    public static final SimpleDateFormat ISODateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    public static final SimpleDateFormat UTCISODateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final int[] MONTH = new int[]{31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static JSONObject setCreationTime(JSONObject jo, Integer days) {
        JSONObject date = new JSONObject();
        try {
            date.put("$date", (Object)DateUtil.toUTCFormat(DateUtil.addDays(days)));
            jo.put(ServiceBasicAttributeNames.SERVICE_CREATED_ON.getAttributeName(), (Object)date);
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
        }
        return jo;
    }

    public static JSONObject setExpiryTime(JSONObject jo, Integer days) {
        JSONObject date = new JSONObject();
        try {
            date.put("$date", (Object)DateUtil.toUTCFormat(DateUtil.addDays(days)));
            jo.put(ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName(), (Object)date);
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
        }
        return jo;
    }

    public static JSONObject setExpiryTimeWithHours(JSONObject jo, Integer hours) {
        JSONObject date = new JSONObject();
        try {
            date.put("$date", (Object)DateUtil.toUTCFormat(DateUtil.addHours(hours)));
            jo.put(ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName(), (Object)date);
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
        }
        return jo;
    }

    public static JSONObject addDate(JSONObject jo, String attrName, Date d) {
        JSONObject date = new JSONObject();
        try {
            date.put("$date", (Object)DateUtil.toUTCFormat(d));
            jo.put(attrName, (Object)date);
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
        }
        return jo;
    }

    public static Date addDays(Date date, Integer days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        return c.getTime();
    }

    public static Date addDays(Integer days) {
        return DateUtil.addDays(new Date(), days);
    }

    public static Date addHours(Date date, Integer hours) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(10, hours);
        return c.getTime();
    }

    public static Date addHours(Integer hours) {
        return DateUtil.addHours(new Date(), hours);
    }

    public static Date getDate(JSONObject json) throws JSONToGlue2MappingException {
        Date date = null;
        try {
            String strDate = json.get("$date").toString();
            date = DateUtil.toUTCFormat(strDate);
        }
        catch (Exception e) {
            throw new JSONToGlue2MappingException("Error converting $date to java.util.Date", e);
        }
        return date;
    }

    public static synchronized String toUTCFormat(Date d) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String timestamp = formatter.format(d);
        return timestamp;
    }

    public static Date toUTCFormat(String d) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date timestamp = formatter.parse(d);
        return timestamp;
    }

    public static XMLGregorianCalendar toXmlGregorian(Date d) throws DatatypeConfigurationException {
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTime(d);
        XMLGregorianCalendar xgcal = DatatypeFactory.newInstance().newXMLGregorianCalendar(gcal);
        return xgcal;
    }

    public static Date fromXmlGregorian(XMLGregorianCalendar xmlCal) throws DatatypeConfigurationException {
        return xmlCal.toGregorianCalendar().getTime();
    }

    public static Boolean hasDateSubObject(Object object) {
        if (object instanceof JSONObject) {
            JSONObject j = (JSONObject)object;
            if (j.has("$date")) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static Duration duration(Calendar fromDate, Calendar toDate) {
        Integer monthResult = 0;
        Integer dayResult = 0;
        Integer yearResult = 0;
        Integer hourResult = 0;
        Integer hourIncrement = 0;
        Integer minutesResult = 0;
        Integer minutesIncrement = 0;
        Integer increment = 0;
        if (toDate.get(12) < fromDate.get(12)) {
            minutesIncrement = 1;
            minutesResult = toDate.get(12) + 60 - fromDate.get(12);
        } else {
            minutesIncrement = 0;
            minutesResult = toDate.get(12) - fromDate.get(12);
        }
        if (toDate.get(11) < fromDate.get(11) + minutesIncrement) {
            hourResult = toDate.get(11) + 24 - fromDate.get(11);
            hourIncrement = 1;
        } else {
            hourResult = toDate.get(11) - fromDate.get(11);
            hourIncrement = 0;
        }
        if (toDate.get(5) < fromDate.get(5)) {
            increment = MONTH[fromDate.get(2) - 1];
        }
        if (increment == -1) {
            Boolean leapYear = fromDate.getActualMaximum(6) > 365;
            increment = leapYear != false ? Integer.valueOf(29) : Integer.valueOf(28);
        }
        if (increment != 0) {
            dayResult = toDate.get(5) + increment - fromDate.get(5);
            increment = 1;
        } else {
            dayResult = toDate.get(5) - fromDate.get(5);
            increment = 0;
        }
        if (toDate.get(2) < fromDate.get(2) + increment) {
            monthResult = toDate.get(2) + 12 - fromDate.get(2);
            increment = 1;
        } else {
            monthResult = toDate.get(2) - fromDate.get(2);
            increment = 0;
        }
        yearResult = toDate.get(1) - (fromDate.get(1) + 1);
        Duration d = new Duration();
        d.setYears(yearResult);
        d.setDays(dayResult);
        d.setMonths(monthResult);
        d.setHours(hourResult);
        d.setMinutes(minutesResult);
        return d;
    }

    public static enum DurationType {
        DAYS,
        MINUTES,
        SECONDS,
        HOURS,
        YEARS;

    }
}

