/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.crl;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.impl.CRLParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.security.auth.x500.X500Principal;

public abstract class AbstractCRLStoreSPI
extends CertStoreSpi {
    protected ObserversHandler observers;
    protected CRLParameters params;
    protected final CertificateFactory factory;
    protected long updateInterval;

    public AbstractCRLStoreSPI(CRLParameters params, ObserversHandler observers) throws InvalidAlgorithmParameterException {
        super(params);
        this.observers = observers;
        this.params = params.clone();
        try {
            this.factory = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Can't find certificate fctory for alg. X.509, JDK/BouncyCastle is misconfigured?", e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Can't load Bouncycastle CertificateFacotory for alg. X.509, BouncyCastle is misconfigured?", e);
        }
        this.updateInterval = this.params.getCrlUpdateInterval();
    }

    protected void notifyObservers(String url, StoreUpdateListener.Severity level, Exception e) {
        this.observers.notifyObservers(url, "CRL", level, e);
    }

    @Override
    public Collection<? extends Certificate> engineGetCertificates(CertSelector selector) throws CertStoreException {
        return Collections.emptySet();
    }

    @Override
    public Collection<? extends CRL> engineGetCRLs(CRLSelector selectorRaw) throws CertStoreException {
        if (selectorRaw instanceof X509CRLSelector) {
            return this.getCRLs((X509CRLSelector)selectorRaw);
        }
        return this.getCRLWithMatcher(selectorRaw);
    }

    private Collection<? extends CRL> getCRLs(X509CRLSelector selector) throws CertStoreException {
        Collection<X500Principal> issuers = selector.getIssuers();
        ArrayList<X509CRL> ret = new ArrayList<X509CRL>();
        if (issuers == null) {
            return ret;
        }
        for (X500Principal issuer : issuers) {
            Collection<X509CRL> crls = this.getCRLForIssuer(issuer);
            for (X509CRL crl : crls) {
                if (!selector.match(crl)) continue;
                ret.add(crl);
            }
        }
        return ret;
    }

    protected abstract Collection<X509CRL> getCRLForIssuer(X500Principal var1);

    protected abstract Collection<X509CRL> getCRLWithMatcher(CRLSelector var1);

    public abstract void setUpdateInterval(long var1);

    public abstract void dispose();
}

