/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.crl;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.CachedElement;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.crl.AbstractCRLStoreSPI;
import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import eu.emi.security.authn.x509.impl.CRLParameters;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.x500.X500Principal;

public class LazyOpensslCRLStoreSpi
extends AbstractCRLStoreSPI {
    private static final String SUFFIX = "\\.r[0-9]+";
    private final File directory;
    private final boolean openssl1Mode;
    private Map<String, CachedElement<List<X509CRL>>> cachedCRLsByHash;

    public LazyOpensslCRLStoreSpi(String path, long crlUpdateInterval, ObserversHandler observers, boolean openssl1Mode) throws InvalidAlgorithmParameterException {
        super(new CRLParameters(Collections.singletonList(path), crlUpdateInterval, 0, null), observers);
        this.directory = new File(path);
        this.openssl1Mode = openssl1Mode;
        this.cachedCRLsByHash = new WeakHashMap<String, CachedElement<List<X509CRL>>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected X509CRL loadCRL(File file) throws IOException, CRLException, URISyntaxException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            X509CRL ret = (X509CRL)this.factory.generateCRL(is);
            if (ret == null) {
                throw new CRLException("Unknown problem when parsing/loading the CRL");
            }
            X509CRL x509CRL = ret;
            return x509CRL;
        }
    }

    @Override
    public synchronized void setUpdateInterval(long newInterval) {
        this.updateInterval = newInterval;
    }

    public synchronized long getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void dispose() {
    }

    protected X509CRL reloadCRL(File location) {
        X509CRL crl;
        try {
            crl = this.loadCRL(location);
            this.notifyObservers(location.getAbsolutePath(), StoreUpdateListener.Severity.NOTIFICATION, null);
        }
        catch (Exception e) {
            this.notifyObservers(location.getAbsolutePath(), StoreUpdateListener.Severity.ERROR, e);
            return null;
        }
        return crl;
    }

    private Collection<X509CRL> filterByIssuer(X500Principal issuer, Collection<X509CRL> all) {
        ArrayList<X509CRL> ret = new ArrayList<X509CRL>(all.size());
        for (X509CRL crl : all) {
            if (!X500NameUtils.rfc3280Equal(issuer, crl.getIssuerX500Principal())) continue;
            ret.add(crl);
        }
        return ret;
    }

    @Override
    protected synchronized Collection<X509CRL> getCRLForIssuer(X500Principal issuer) {
        String issuerHash = OpensslTruststoreHelper.getOpenSSLCAHash(issuer, this.openssl1Mode);
        CachedElement<List<X509CRL>> cached = this.cachedCRLsByHash.get(issuerHash);
        if (cached != null && !cached.isExpired(this.updateInterval)) {
            return this.filterByIssuer(issuer, (Collection<X509CRL>)cached.getElement());
        }
        Collection<File> crls = OpensslTruststoreHelper.getFilesWithRegexp(issuerHash + SUFFIX, this.directory);
        ArrayList<X509CRL> ret = new ArrayList<X509CRL>(crls.size());
        for (File location : crls) {
            X509CRL crl = this.reloadCRL(location);
            if (crl == null) continue;
            ret.add(crl);
        }
        this.cachedCRLsByHash.put(issuerHash, new CachedElement(ret));
        return this.filterByIssuer(issuer, ret);
    }

    @Override
    protected synchronized Collection<X509CRL> getCRLWithMatcher(CRLSelector selectorRaw) {
        Collection<File> crls = OpensslTruststoreHelper.getFilesWithRegexp(".*\\.r[0-9]+", this.directory);
        ArrayList<X509CRL> ret = new ArrayList<X509CRL>();
        for (File location : crls) {
            X509CRL crl = this.reloadCRL(location);
            if (crl == null || !selectorRaw.match(crl)) continue;
            ret.add(crl);
        }
        return ret;
    }
}

