/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ocsp;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPClientImpl;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPRespondersCache;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResponseStructure;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResponsesCache;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;

public class OCSPCachingClient {
    private final long maxTtl;
    private OCSPRespondersCache respondersCache;
    private OCSPResponsesCache responsesCache;

    public OCSPCachingClient(long maxTtl, File diskPath, String prefix) {
        this.maxTtl = maxTtl;
        this.responsesCache = new OCSPResponsesCache(maxTtl, diskPath, prefix);
        this.respondersCache = new OCSPRespondersCache(maxTtl, diskPath, prefix);
    }

    public OCSPResult queryForCertificate(URL responder, X509Certificate toCheckCert, X509Certificate issuerCert, X509Credential requester, boolean addNonce, int timeout) throws IOException, OCSPException {
        return this.queryForCertificate(responder, toCheckCert, issuerCert, requester, addNonce, timeout, new OCSPClientImpl());
    }

    public OCSPResult queryForCertificate(URL responder, X509Certificate toCheckCert, X509Certificate issuerCert, X509Credential requester, boolean addNonce, int timeout, OCSPClientImpl client) throws IOException, OCSPException {
        OCSPResponseStructure responseWithMeta;
        if (this.maxTtl < 0L) {
            return client.queryForCertificate(responder, toCheckCert, issuerCert, requester, addNonce, timeout);
        }
        String responderKey = this.respondersCache.createResponderKey(issuerCert);
        this.respondersCache.checkCachedError(responderKey);
        String responseKey = this.responsesCache.createResponseKey(toCheckCert, issuerCert);
        SingleResp cachedResp = this.responsesCache.getCachedResp(responseKey, client, toCheckCert, issuerCert);
        if (cachedResp != null) {
            return new OCSPResult(cachedResp);
        }
        OCSPReq request = client.createRequest(toCheckCert, issuerCert, requester, addNonce);
        try {
            responseWithMeta = client.send(responder, request, timeout);
        }
        catch (IOException e) {
            this.respondersCache.addToCache(responderKey, e);
            throw e;
        }
        OCSPResp fullResponse = responseWithMeta.getResponse();
        byte[] nonce = OCSPClientImpl.extractNonce(request);
        SingleResp singleResp = client.verifyResponse(fullResponse, toCheckCert, issuerCert, nonce);
        this.responsesCache.addToCache(responseKey, responseWithMeta, singleResp);
        return new OCSPResult(singleResp);
    }

    public void clearMemoryCache() {
        this.responsesCache.clearMemoryCache();
        this.respondersCache.clearMemoryCache();
    }
}

