/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ocsp;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.BinaryCertChainValidator;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResponseStructure;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResult;
import eu.emi.security.authn.x509.helpers.ssl.DisabledNameMismatchCallback;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.encoders.Base64;

public class OCSPClientImpl {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final int MAX_RESPONSE_SIZE = 20480;

    public OCSPResult queryForCertificate(URL responder, X509Certificate toCheckCert, X509Certificate issuerCert, X509Credential requester, boolean addNonce, int timeout) throws IOException, OCSPException {
        OCSPReq request = this.createRequest(toCheckCert, issuerCert, requester, addNonce);
        OCSPResp response = this.send(responder, request, timeout).getResponse();
        byte[] nonce = null;
        if (addNonce) {
            nonce = OCSPClientImpl.extractNonce(request);
        }
        SingleResp resp = this.verifyResponse(response, toCheckCert, issuerCert, nonce);
        return new OCSPResult(resp);
    }

    public OCSPReq createRequest(X509Certificate toCheckCert, X509Certificate issuerCert, X509Credential requester, boolean addNonce) throws OCSPException {
        CertificateID certId;
        OCSPReqBuilder generator = new OCSPReqBuilder();
        try {
            DigestCalculator digestCalc = new BcDigestCalculatorProvider().get(CertificateID.HASH_SHA1);
            JcaX509CertificateHolder issuerCertHolder = new JcaX509CertificateHolder(issuerCert);
            certId = new CertificateID(digestCalc, (X509CertificateHolder)issuerCertHolder, toCheckCert.getSerialNumber());
        }
        catch (OperatorCreationException e1) {
            throw new OCSPException("Problem creating digester", (Throwable)e1);
        }
        catch (CertificateEncodingException e) {
            throw new OCSPException("Issuer certificate is unsupported ", (Throwable)e);
        }
        generator.addRequest(certId);
        if (addNonce) {
            byte[] nonce = new byte[16];
            Random rand = new Random();
            rand.nextBytes(nonce);
            Extensions extensions = new Extensions(new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(nonce)));
            generator.setRequestExtensions(extensions);
        }
        if (requester != null) {
            X500Name subjectName = new X500Name(requester.getCertificate().getSubjectX500Principal().getName());
            generator.setRequestorName(subjectName);
            try {
                JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(requester.getCertificate().getSigAlgOID());
                return generator.build(csBuilder.build(requester.getKey()), null);
            }
            catch (OperatorCreationException e) {
                throw new OCSPException("Unsupported signing algorithm when creating a OCSP request?", (Throwable)e);
            }
        }
        return generator.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCSPResponseStructure send(URL responder, OCSPReq requestO, int timeout) throws IOException {
        InputStream in = null;
        byte[] request = requestO.getEncoded();
        byte[] response = null;
        Date maxCache = null;
        HttpURLConnection con = null;
        try {
            int total;
            String getUrl = this.getHttpGetUrl(responder, request);
            if (getUrl == null) {
                con = this.doPost(responder, request, timeout);
            } else {
                URL u = new URL(getUrl);
                con = (HttpURLConnection)u.openConnection();
                this.configureHttpConnection(con, timeout);
            }
            in = con.getInputStream();
            int contentLength = con.getContentLength();
            if (contentLength == -1 || contentLength > 20480) {
                contentLength = 20480;
            }
            maxCache = OCSPClientImpl.getNextUpdateFromCacheHeader(con.getHeaderField("cache-control"));
            response = new byte[contentLength];
            int count = 0;
            for (total = 0; total < contentLength && (count = in.read(response, total, response.length - total)) >= 0; total += count) {
            }
            if (count >= 0 && in.read() >= 0) {
                throw new IOException("OCSP response size exceeded the upper limit of 20480");
            }
            if (total != contentLength) {
                response = Arrays.copyOf(response, total);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        OCSPResp resp = new OCSPResp(response);
        return new OCSPResponseStructure(resp, maxCache);
    }

    private void configureHttpConnection(HttpURLConnection con, int timeout) {
        if (con instanceof HttpsURLConnection) {
            HttpsURLConnection httpsCon = (HttpsURLConnection)con;
            BinaryCertChainValidator trustAll = new BinaryCertChainValidator(true);
            SSLSocketFactory sf = new SocketFactoryCreator2(trustAll, new DisabledNameMismatchCallback()).getSocketFactory();
            httpsCon.setSSLSocketFactory(sf);
        }
        con.setConnectTimeout(timeout);
        con.setReadTimeout(timeout);
    }

    private String getHttpGetUrl(URL responder, byte[] request) {
        if (responder.toExternalForm().length() + request.length > 255) {
            return null;
        }
        byte[] base64 = Base64.encode((byte[])request);
        String ret = new String(base64, ASCII);
        try {
            ret = URLEncoder.encode(ret, ASCII.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("US-ASCII encoding is not known?", e);
        }
        String url = responder.toExternalForm();
        ret = url.endsWith("/") ? url + ret : url + "/" + ret;
        if (ret.length() > 255) {
            return null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection doPost(URL responder, byte[] request, int timeout) throws IOException {
        HttpURLConnection con = (HttpURLConnection)responder.openConnection();
        this.configureHttpConnection(con, timeout);
        try (OutputStream out = null;){
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/ocsp-request");
            con.setRequestProperty("Content-length", String.valueOf(request.length));
            out = con.getOutputStream();
            out.write(request);
            out.flush();
            HttpURLConnection httpURLConnection = con;
            return httpURLConnection;
        }
    }

    public static Date getNextUpdateFromCacheHeader(String cc) {
        int delta;
        if (cc == null) {
            return null;
        }
        int i = cc.indexOf("max-age=");
        if (i == -1) {
            return null;
        }
        int j = cc.indexOf(",", i += 8);
        if (j == -1) {
            j = cc.length();
        }
        String deltaS = cc.substring(i, j).trim();
        try {
            delta = Integer.parseInt(deltaS);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new Date(System.currentTimeMillis() + (long)delta * 1000L);
    }

    private static String getResponderErrorDesc(int errorNo) {
        switch (errorNo) {
            case 2: {
                return "internal server error";
            }
            case 1: {
                return "malformed request";
            }
            case 5: {
                return "request is required to be signed";
            }
            case 3: {
                return "try again later";
            }
            case 6: {
                return "request was not authorized";
            }
        }
        return "unknown error";
    }

    public SingleResp verifyResponse(OCSPResp response, X509Certificate toCheckCert, X509Certificate issuerCert, byte[] checkNonce) throws OCSPException {
        if (response.getStatus() != 0) {
            throw new OCSPException("Responder returned an error: " + OCSPClientImpl.getResponderErrorDesc(response.getStatus()));
        }
        Object respO = response.getResponseObject();
        if (!(respO instanceof BasicOCSPResp)) {
            throw new OCSPException("Only Basic OCSP response type is supported");
        }
        BasicOCSPResp bresp = (BasicOCSPResp)respO;
        if (checkNonce != null) {
            ASN1OctetString octs;
            byte[] nonceAsn;
            try {
                nonceAsn = bresp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce).getExtnValue().getEncoded();
            }
            catch (IOException e1) {
                throw new OCSPException("Can't parse OCSP nonce extension", (Throwable)e1);
            }
            if (nonceAsn == null) {
                throw new OCSPException("Nonce was sent and is required but did not get it in reply");
            }
            try {
                octs = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])nonceAsn);
            }
            catch (Exception e) {
                throw new OCSPException("Nonce received with the reply is invalid, unable to parse it", (Throwable)e);
            }
            byte[] nonce = octs.getOctets();
            if (!Arrays.equals(nonce, checkNonce)) {
                throw new OCSPException("Received nonce doesn't match the one sent to the server. Sent: " + Arrays.toString(checkNonce) + " received: " + Arrays.toString(nonce));
            }
        }
        PublicKey key = this.establishResponsePubKey(bresp, issuerCert);
        try {
            ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().build(key);
            if (!bresp.isSignatureValid(verifierProvider)) {
                throw new OCSPException("Failed to verify the OCSP response signature. It is corrupted or faked");
            }
        }
        catch (OperatorCreationException e) {
            throw new OCSPException("The OCSP is signed with unsupported key: can not verify its signature", (Throwable)e);
        }
        if (bresp.getCriticalExtensionOIDs().size() > 0) {
            throw new OCSPException("OCSP contains unsupported critical extensions: " + bresp.getCriticalExtensionOIDs());
        }
        SingleResp[] resps = bresp.getResponses();
        for (int i = 0; i < resps.length; ++i) {
            SingleResp sResp = resps[i];
            if (sResp.getCriticalExtensionOIDs().size() > 0) {
                throw new OCSPException("OCSP SingleResponse contains unsupported critical extensions: " + sResp.getCriticalExtensionOIDs());
            }
            if (!this.checkCertIDMatching(toCheckCert, issuerCert, sResp.getCertID())) continue;
            this.verifyTimeRange(sResp.getThisUpdate(), sResp.getNextUpdate());
            return sResp;
        }
        throw new OCSPException("Received a correct answer from OCSP responder, but it didn't contain any information on the certificate being checked");
    }

    private void verifyTimeRange(Date thisUpdate, Date nextUpdate) throws OCSPException {
        Date now = new Date();
        if (thisUpdate == null) {
            throw new OCSPException("Malformed OCSP response, no thisUpdate time");
        }
        if (nextUpdate == null) {
            throw new OCSPException("Unsupported OCSP response, no nextUpdate time (required by RFC 5019)");
        }
        int tolerance = 120000;
        Date futureNow = new Date(now.getTime() + (long)tolerance);
        Date pastNow = new Date(now.getTime() - (long)tolerance);
        if (futureNow.before(thisUpdate)) {
            throw new OCSPException("Response is not yet valid, will be from: " + thisUpdate);
        }
        if (pastNow.after(nextUpdate)) {
            throw new OCSPException("Response has expired on: " + nextUpdate);
        }
    }

    private boolean checkCertIDMatching(X509Certificate toFind, X509Certificate issuerCert, CertificateID checkedCertId) throws OCSPException {
        try {
            JcaX509CertificateHolder issuerCertHolder = new JcaX509CertificateHolder(issuerCert);
            DigestCalculator digCalc = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(checkedCertId.getHashAlgOID()));
            CertificateID certId = new CertificateID(digCalc, (X509CertificateHolder)issuerCertHolder, toFind.getSerialNumber());
            return certId.getHashAlgOID().equals((ASN1Primitive)checkedCertId.getHashAlgOID()) && Arrays.equals(certId.getIssuerKeyHash(), checkedCertId.getIssuerKeyHash()) && Arrays.equals(certId.getIssuerNameHash(), checkedCertId.getIssuerNameHash());
        }
        catch (OperatorCreationException e) {
            throw new OCSPException("Cant get digester for the checked certificate, the algorithm is: " + checkedCertId.getHashAlgOID(), (Throwable)e);
        }
        catch (CertificateEncodingException e) {
            throw new OCSPException("Issuer certificate is unsupported", (Throwable)e);
        }
    }

    private PublicKey establishResponsePubKey(BasicOCSPResp bresp, X509Certificate issuerCert) throws OCSPException {
        X509Certificate signerCert;
        X509CertificateHolder[] signerCerts = bresp.getCerts();
        if (signerCerts == null || signerCerts.length == 0) {
            return issuerCert.getPublicKey();
        }
        try {
            signerCert = new JcaX509CertificateConverter().getCertificate(signerCerts[0]);
        }
        catch (CertificateException e1) {
            throw new OCSPException("Can't unwrap signer's certificate from the BasicOCSPResp", (Throwable)e1);
        }
        if (signerCert.equals(issuerCert)) {
            return issuerCert.getPublicKey();
        }
        if (!issuerCert.getSubjectX500Principal().equals(signerCert.getIssuerX500Principal())) {
            throw new OCSPException("Response is signed by an untrusted/invalid entity: " + CertificateUtils.format(signerCert, FormatMode.COMPACT_ONE_LINE));
        }
        try {
            List<String> keyUsage = signerCert.getExtendedKeyUsage();
            if (keyUsage == null || !keyUsage.contains(KeyPurposeId.id_kp_OCSPSigning.getId())) {
                throw new OCSPException("Response is signed by an entity which does not have the OCSP delegation from the CA (no flag in ExtendedKeyUsage)");
            }
        }
        catch (CertificateParsingException e) {
            throw new OCSPException("Response contains an unparsable certificate (ExtendedKeyUsage)", (Throwable)e);
        }
        try {
            signerCert.verify(issuerCert.getPublicKey(), "BC");
        }
        catch (Exception e) {
            throw new OCSPException("Response contains a certificate which is improperly signed, it is faked or corrupted: " + e.getMessage(), (Throwable)e);
        }
        return signerCert.getPublicKey();
    }

    public static byte[] extractNonce(OCSPReq request) throws IOException {
        ASN1OctetString octs;
        Extension nonceExt = request.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (nonceExt == null) {
            return null;
        }
        byte[] nonceAsn = nonceExt.getExtnValue().getEncoded();
        if (nonceAsn == null) {
            return null;
        }
        try {
            octs = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])nonceAsn);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't decode nonce encoded in request", e);
        }
        return octs.getOctets();
    }
}

