/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath.bc;

import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.helpers.pkipath.SimpleValidationErrorException;
import eu.emi.security.authn.x509.helpers.pkipath.bc.CertPathValidatorUtilities;
import eu.emi.security.authn.x509.helpers.pkipath.bc.PrincipalUtils;
import java.math.BigInteger;
import java.security.cert.CRLSelector;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jcajce.PKIXCRLStore;
import org.bouncycastle.jcajce.PKIXCRLStoreSelector;
import org.bouncycastle.jcajce.PKIXCertStore;
import org.bouncycastle.jcajce.PKIXExtendedBuilderParameters;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.x509.X509AttributeCertificate;

public class CertPathValidatorUtilitiesCanl
extends CertPathValidatorUtilities {
    public static TrustAnchor findTrustAnchorPublic(X509Certificate cert, Set<?> trustAnchors, String sigProvider) throws AnnotatedException {
        return CertPathValidatorUtilities.findTrustAnchor(cert, trustAnchors, sigProvider);
    }

    public static Collection<?> findIssuerCerts(X509Certificate cert, PKIXExtendedBuilderParameters pkixParams) throws AnnotatedException {
        ArrayList<PKIXCertStore> stores = new ArrayList<PKIXCertStore>();
        stores.addAll(pkixParams.getBaseParameters().getCertificateStores());
        try {
            stores.addAll(CertPathValidatorUtilities.getAdditionalStoresFromAltNames(cert.getExtensionValue(Extension.issuerAlternativeName.getId()), pkixParams.getBaseParameters().getNamedCertificateStoreMap()));
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        return CertPathValidatorUtilities.findIssuerCerts(cert, pkixParams.getBaseParameters().getCertStores(), stores);
    }

    protected static Set<?> getCompleteCRLs2(DistributionPoint dp, X509Certificate cert, Date currentDate, PKIXExtendedParameters paramsPKIX) throws SimpleValidationErrorException {
        try {
            return CertPathValidatorUtilitiesCanl.getCompleteCRLs(dp, cert, currentDate, paramsPKIX);
        }
        catch (AnnotatedException e) {
            if (e.getMessage().startsWith("No CRLs found for issuer")) {
                if (cert.getNotAfter().after(currentDate)) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.noValidCrlFound, new Object[]{e});
                }
                throw new SimpleValidationErrorException(ValidationErrorCode.noCrlForExpiredCert, new Object[]{e});
            }
            throw new SimpleValidationErrorException(ValidationErrorCode.crlExtractionError, e.getCause().getMessage(), e.getCause(), e.getCause().getClass().getName());
        }
    }

    protected static Set getCompleteCRLs(DistributionPoint dp, Object cert, Date currentDate, PKIXExtendedParameters paramsPKIX) throws AnnotatedException {
        X509CRLSelector baseCrlSelect = new X509CRLSelector();
        try {
            HashSet<X500Name> issuers = new HashSet<X500Name>();
            issuers.add(PrincipalUtils.getEncodedIssuerPrincipal(cert));
            CertPathValidatorUtilities.getCRLIssuersFromDistributionPoint(dp, issuers, baseCrlSelect);
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Could not get issuer information from distribution point.", (Throwable)e);
        }
        if (cert instanceof X509Certificate) {
            baseCrlSelect.setCertificateChecking((X509Certificate)cert);
        }
        PKIXCRLStoreSelector crlSelect = new PKIXCRLStoreSelector.Builder((CRLSelector)baseCrlSelect).setCompleteCRLEnabled(true).build();
        Date validityDate = new Date(0L);
        Set crls = CRL_UTIL.findCRLs(crlSelect, validityDate, paramsPKIX.getCertStores(), paramsPKIX.getCRLStores());
        CertPathValidatorUtilitiesCanl.checkCRLsNotEmpty(crls, cert);
        return crls;
    }

    protected static Set<X509CRL> getDeltaCRLs2(Date currentDate, PKIXExtendedParameters paramsPKIX, X509CRL completeCRL) throws SimpleValidationErrorException {
        try {
            return CertPathValidatorUtilitiesCanl.getDeltaCRLs(currentDate, completeCRL, paramsPKIX.getCertStores(), paramsPKIX.getCRLStores());
        }
        catch (AnnotatedException e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlDeltaProblem, e.getMessage(), e.getCause(), e.getCause().getClass().getName());
        }
    }

    protected static ASN1Primitive getExtensionValue(X509Extension ext, String oid) throws AnnotatedException {
        return CertPathValidatorUtilities.getExtensionValue(ext, oid);
    }

    protected static List<PKIXCRLStore> getAdditionalStoresFromCRLDistributionPoint(CRLDistPoint crldp, PKIXExtendedBuilderParameters pkixParams) throws AnnotatedException {
        return CertPathValidatorUtilities.getAdditionalStoresFromCRLDistributionPoint(crldp, pkixParams.getBaseParameters().getNamedCRLStoreMap());
    }

    public static BigInteger getSerialNumber(Object cert) {
        if (cert instanceof X509Certificate) {
            return ((X509Certificate)cert).getSerialNumber();
        }
        return ((X509AttributeCertificate)cert).getSerialNumber();
    }
}

