/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath.bc;

import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.helpers.pkipath.ExtPKIXParameters2;
import eu.emi.security.authn.x509.helpers.pkipath.SimpleValidationErrorException;
import eu.emi.security.authn.x509.helpers.pkipath.bc.CertPathValidatorUtilities;
import eu.emi.security.authn.x509.helpers.pkipath.bc.CertPathValidatorUtilitiesCanl;
import eu.emi.security.authn.x509.helpers.pkipath.bc.CertStatus;
import eu.emi.security.authn.x509.helpers.pkipath.bc.PrincipalUtils;
import eu.emi.security.authn.x509.helpers.pkipath.bc.RFC3280CertPathUtilities;
import eu.emi.security.authn.x509.helpers.pkipath.bc.ReasonsMask;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.i18n.filter.TrustedInput;
import org.bouncycastle.jcajce.PKIXCRLStore;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.X509CRLObject;

public class RFC3280CertPathUtilitiesCanl
extends RFC3280CertPathUtilities {
    public static void checkCRLs2(ExtPKIXParameters2 paramsPKIX, X509Certificate cert, Date validDate, X509Certificate sign, PublicKey workingPublicKey, List<?> certPathCerts, JcaJceHelper jcaHelper) throws SimpleValidationErrorException {
        SimpleValidationErrorException lastException = null;
        CRLDistPoint crldp = null;
        try {
            crldp = CRLDistPoint.getInstance((Object)CertPathValidatorUtilitiesCanl.getExtensionValue(cert, RFC3280CertPathUtilities.CRL_DISTRIBUTION_POINTS));
        }
        catch (Exception e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlDistPtExtError, e);
        }
        PKIXExtendedParameters.Builder paramsBldr = new PKIXExtendedParameters.Builder(paramsPKIX.getBaseParameters());
        try {
            List<PKIXCRLStore> extras = CertPathValidatorUtilities.getAdditionalStoresFromCRLDistributionPoint(crldp, paramsPKIX.getBaseParameters().getNamedCRLStoreMap());
            for (PKIXCRLStore store : extras) {
                paramsBldr.addCRLStore(store);
            }
        }
        catch (AnnotatedException e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlDistPtExtError, new Object[]{e});
        }
        CertStatus certStatus = new CertStatus();
        ReasonsMask reasonsMask = new ReasonsMask();
        PKIXExtendedParameters finalParams = paramsBldr.build();
        boolean validCrlFound = false;
        if (crldp != null) {
            DistributionPoint[] dps = null;
            try {
                dps = crldp.getDistributionPoints();
            }
            catch (Exception e) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlDistPtExtError, e);
            }
            if (dps != null) {
                for (int i = 0; i < dps.length && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons(); ++i) {
                    try {
                        RFC3280CertPathUtilitiesCanl.checkCRL(dps[i], finalParams, cert, validDate, sign, workingPublicKey, certStatus, reasonsMask, certPathCerts, jcaHelper);
                        validCrlFound = true;
                        continue;
                    }
                    catch (SimpleValidationErrorException e) {
                        lastException = e;
                    }
                }
            }
        }
        if (certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
            try {
                ASN1Primitive issuer = null;
                try {
                    issuer = new ASN1InputStream(PrincipalUtils.getEncodedIssuerPrincipal(cert).getEncoded()).readObject();
                }
                catch (Exception e) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.crlIssuerException, e);
                }
                DistributionPoint dp = new DistributionPoint(new DistributionPointName(0, (ASN1Encodable)new GeneralNames(new GeneralName(4, (ASN1Encodable)issuer))), null, null);
                RFC3280CertPathUtilitiesCanl.checkCRL(dp, paramsPKIX.getBaseParameters(), cert, validDate, sign, workingPublicKey, certStatus, reasonsMask, certPathCerts, jcaHelper);
                validCrlFound = true;
            }
            catch (SimpleValidationErrorException e) {
                lastException = e;
            }
        }
        if (!validCrlFound) {
            throw lastException;
        }
        if (certStatus.getCertStatus() != 11) {
            throw new SimpleValidationErrorException(ValidationErrorCode.certRevoked, new TrustedInput((Object)certStatus.getRevocationDate()), crlReasons[certStatus.getCertStatus()]);
        }
        if (!reasonsMask.isAllReasons() && certStatus.getCertStatus() == 11) {
            certStatus.setCertStatus(12);
        }
        if (certStatus.getCertStatus() == 12) {
            throw new SimpleValidationErrorException(ValidationErrorCode.noValidCrlFound, new Object[0]);
        }
    }

    private static void checkCRL(DistributionPoint dp, PKIXExtendedParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate defaultCRLSignCert, PublicKey defaultCRLSignKey, CertStatus certStatus, ReasonsMask reasonMask, List<?> certPathCerts, JcaJceHelper jcaHelper) throws SimpleValidationErrorException {
        Date currentDate = new Date(System.currentTimeMillis());
        if (validDate.getTime() > currentDate.getTime()) {
            throw new IllegalArgumentException("CRL validation time is in future: " + validDate);
        }
        Set<?> crls = CertPathValidatorUtilitiesCanl.getCompleteCRLs2(dp, cert, currentDate, paramsPKIX);
        boolean validCrlFound = false;
        SimpleValidationErrorException lastException = null;
        Iterator<?> crl_iter = crls.iterator();
        while (crl_iter.hasNext() && certStatus.getCertStatus() == 11 && !reasonMask.isAllReasons()) {
            try {
                X509CRL crl = (X509CRL)crl_iter.next();
                if (crl.getNextUpdate().before(currentDate)) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.crlVerifyFailed, new Object[0]);
                }
                ReasonsMask interimReasonsMask = RFC3280CertPathUtilitiesCanl.processCRLD2(crl, dp);
                if (!interimReasonsMask.hasNewReasons(reasonMask)) continue;
                Set<?> keys = RFC3280CertPathUtilitiesCanl.processCRLF2(crl, cert, defaultCRLSignCert, defaultCRLSignKey, paramsPKIX, certPathCerts, jcaHelper);
                PublicKey key = RFC3280CertPathUtilitiesCanl.processCRLG2(crl, keys);
                X509CRL deltaCRL = null;
                Date validityDate = currentDate;
                if (paramsPKIX.getDate() != null) {
                    validityDate = paramsPKIX.getDate();
                }
                if (paramsPKIX.isUseDeltasEnabled()) {
                    Set<X509CRL> deltaCRLs = CertPathValidatorUtilitiesCanl.getDeltaCRLs2(validityDate, paramsPKIX, crl);
                    deltaCRL = RFC3280CertPathUtilitiesCanl.processCRLH2(deltaCRLs, key);
                }
                if (paramsPKIX.getValidityModel() != 1 && cert.getNotAfter().getTime() < crl.getThisUpdate().getTime()) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.noValidCrlFound, new Object[0]);
                }
                RFC3280CertPathUtilitiesCanl.processCRLB1_2(dp, cert, crl);
                RFC3280CertPathUtilitiesCanl.processCRLB2_2(dp, cert, crl);
                RFC3280CertPathUtilitiesCanl.processCRLC2(deltaCRL, crl, paramsPKIX);
                RFC3280CertPathUtilitiesCanl.processCRLI2(validDate, deltaCRL, cert, certStatus, paramsPKIX);
                RFC3280CertPathUtilitiesCanl.processCRLJ2(validDate, crl, cert, certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonMask.addReasons(interimReasonsMask);
                Set<String> criticalExtensions = crl.getCriticalExtensionOIDs();
                if (criticalExtensions != null) {
                    criticalExtensions = new HashSet<String>(criticalExtensions);
                    criticalExtensions.remove(Extension.issuingDistributionPoint.getId());
                    criticalExtensions.remove(Extension.deltaCRLIndicator.getId());
                    if (!criticalExtensions.isEmpty()) {
                        throw new SimpleValidationErrorException(ValidationErrorCode.crlUnknownCritExt, criticalExtensions.iterator().next());
                    }
                }
                if (deltaCRL != null && (criticalExtensions = deltaCRL.getCriticalExtensionOIDs()) != null) {
                    criticalExtensions = new HashSet<String>(criticalExtensions);
                    criticalExtensions.remove(Extension.issuingDistributionPoint.getId());
                    criticalExtensions.remove(Extension.deltaCRLIndicator.getId());
                    if (!criticalExtensions.isEmpty()) {
                        throw new SimpleValidationErrorException(ValidationErrorCode.crlUnknownCritExt, criticalExtensions.iterator().next());
                    }
                }
                validCrlFound = true;
            }
            catch (SimpleValidationErrorException e) {
                lastException = e;
            }
        }
        if (!validCrlFound) {
            throw lastException;
        }
    }

    private static void processCRLB1_2(DistributionPoint dp, Object cert, X509CRL crl) throws SimpleValidationErrorException {
        try {
            RFC3280CertPathUtilities.processCRLB1(dp, cert, crl);
        }
        catch (AnnotatedException e) {
            if (e.getMessage().startsWith("CRL issuer information from distribution point cannot be decoded")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlIssuerException, e.getCause());
            }
            if (e.getMessage().startsWith("Distribution point contains cRLIssuer field but CRL is not indirect")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e.getMessage());
            }
            if (e.getMessage().startsWith("CRL issuer of CRL does not match CRL issuer of distribution point")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e.getMessage());
            }
            if (e.getMessage().startsWith("Cannot find matching CRL issuer for certificate")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlNoIssuerForDP, new Object[0]);
            }
            if (e.getMessage().startsWith("exception processing extension")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e.getCause());
            }
            throw new SimpleValidationErrorException(ValidationErrorCode.unknownMsg, new Object[]{e});
        }
    }

    private static void processCRLB2_2(DistributionPoint dp, Object cert, X509CRL crl) throws SimpleValidationErrorException {
        try {
            RFC3280CertPathUtilities.processCRLB2(dp, cert, crl);
        }
        catch (AnnotatedException e) {
            if (e.getMessage().startsWith("Issuing distribution point extension could not be decoded")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e.getCause());
            }
            if (e.getMessage().startsWith("Could not read CRL issuer")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlIssuerException, new Object[]{e});
            }
            if (e.getMessage().startsWith("No match for certificate CRL issuing distribution point name to cRLIssuer CRL distribution point")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlIDPAndDPMismatch, new Object[0]);
            }
            if (e.getMessage().startsWith("Either the cRLIssuer or the distributionPoint field must")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlNoIssuerAndDP, new Object[0]);
            }
            if (e.getMessage().startsWith("Basic constraints extension could not be decoded")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlBCExtError, e.getCause());
            }
            if (e.getMessage().startsWith("CA Cert CRL only contains user certificates")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlOnlyUserCert, new Object[0]);
            }
            if (e.getMessage().startsWith("End CRL only contains CA certificates")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlOnlyCaCert, new Object[0]);
            }
            if (e.getMessage().startsWith("onlyContainsAttributeCerts boolean is asserted")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlOnlyAttrCert, new Object[0]);
            }
            throw new SimpleValidationErrorException(ValidationErrorCode.unknownMsg, new Object[]{e});
        }
    }

    private static void processCRLC2(X509CRL deltaCRL, X509CRL completeCRL, PKIXExtendedParameters pkixParams) throws SimpleValidationErrorException {
        try {
            RFC3280CertPathUtilities.processCRLC(deltaCRL, completeCRL, pkixParams);
        }
        catch (AnnotatedException e) {
            if (e.getMessage().startsWith("Issuing distribution point extension")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e.getCause());
            }
            if (e.getMessage().startsWith("Complete CRL issuer does not match delta CRL issuer")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlDeltaProblem, e.getMessage());
            }
            if (e.getMessage().startsWith("Issuing distribution point extension from delta CRL and complete CRL does not match")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlDeltaProblem, e.getMessage());
            }
            if (e.getMessage().startsWith("Authority key identifier extension could not be extracted from")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlAKIExtError, e.getCause());
            }
            if (e.getMessage().startsWith("CRL authority key identifier is null")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlAKIExtError, e.getMessage());
            }
            if (e.getMessage().startsWith("Delta CRL authority key identifier is null")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlAKIExtError, e.getMessage());
            }
            if (e.getMessage().startsWith("Delta CRL authority key identifier does not match complete CRL authority key identifier")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlDeltaProblem, e.getMessage());
            }
            throw new SimpleValidationErrorException(ValidationErrorCode.unknownMsg, new Object[]{e});
        }
    }

    private static Set<?> processCRLF2(X509CRL crl, Object cert, X509Certificate defaultCRLSignCert, PublicKey defaultCRLSignKey, PKIXExtendedParameters paramsPKIX, List<?> certPathCerts, JcaJceHelper helper) throws SimpleValidationErrorException {
        try {
            return RFC3280CertPathUtilities.processCRLF(crl, cert, defaultCRLSignCert, defaultCRLSignKey, paramsPKIX, certPathCerts, helper);
        }
        catch (AnnotatedException e) {
            if (e.getMessage().startsWith("Subject criteria for certificate selector to find issuer certificate for CRL could not be set")) {
                new RuntimeException(e.getMessage(), e);
            } else if (e.getMessage().startsWith("Issuer certificate for CRL cannot be searched")) {
                new RuntimeException(e.getMessage(), e);
            } else {
                if (e.getMessage().startsWith("Internal error")) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.crlNoIssuerPublicKey, e.getCause());
                }
                if (e.getMessage().startsWith("Public key of issuer certificate of CRL could not be retrieved")) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.crlNoIssuerPublicKey, e.getCause());
                }
                if (e.getMessage().startsWith("Issuer certificate key usage extension does not permit CRL signing")) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.noCrlSigningPermited, new Object[0]);
                }
                if (e.getMessage().startsWith("Cannot find a valid issuer certificate")) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.crlNoIssuerPublicKey, e.getMessage());
                }
            }
            throw new SimpleValidationErrorException(ValidationErrorCode.unknownMsg, new Object[]{e});
        }
    }

    private static X509CRL processCRLH2(Set<?> deltacrls, PublicKey key) throws SimpleValidationErrorException {
        try {
            return RFC3280CertPathUtilities.processCRLH(deltacrls, key);
        }
        catch (AnnotatedException e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlVerifyFailed, new Object[]{e});
        }
    }

    private static PublicKey processCRLG2(X509CRL crl, Set<?> keys) throws SimpleValidationErrorException {
        try {
            return RFC3280CertPathUtilities.processCRLG(crl, keys);
        }
        catch (AnnotatedException e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlVerifyFailed, new Object[]{e});
        }
    }

    private static void processCRLI2(Date validDate, X509CRL deltacrl, Object cert, CertStatus certStatus, PKIXExtendedParameters pkixParams) throws SimpleValidationErrorException {
        if (pkixParams.isUseDeltasEnabled() && deltacrl != null) {
            RFC3280CertPathUtilitiesCanl.getCertStatus(validDate, deltacrl, cert, certStatus);
        }
    }

    private static void processCRLJ2(Date validDate, X509CRL completecrl, Object cert, CertStatus certStatus) throws SimpleValidationErrorException {
        if (certStatus.getCertStatus() == 11) {
            RFC3280CertPathUtilitiesCanl.getCertStatus(validDate, completecrl, cert, certStatus);
        }
    }

    private static ReasonsMask processCRLD2(X509CRL crl, DistributionPoint dp) throws SimpleValidationErrorException {
        IssuingDistributionPoint idp = null;
        try {
            idp = IssuingDistributionPoint.getInstance((Object)CertPathValidatorUtilitiesCanl.getExtensionValue(crl, RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e);
        }
        if (idp != null && idp.getOnlySomeReasons() != null && dp.getReasons() != null) {
            return new ReasonsMask(dp.getReasons()).intersect(new ReasonsMask(idp.getOnlySomeReasons()));
        }
        if ((idp == null || idp.getOnlySomeReasons() == null) && dp.getReasons() == null) {
            return ReasonsMask.allReasons;
        }
        return (dp.getReasons() == null ? ReasonsMask.allReasons : new ReasonsMask(dp.getReasons())).intersect(idp == null ? ReasonsMask.allReasons : new ReasonsMask(idp.getOnlySomeReasons()));
    }

    protected static void getCertStatus(Date validDate, X509CRL crl, Object cert, CertStatus certStatus) throws SimpleValidationErrorException {
        boolean isIndirect;
        X509CRLEntry crl_entry = null;
        try {
            isIndirect = X509CRLObject.isIndirectCRL((X509CRL)crl);
        }
        catch (CRLException exception) {
            throw new SimpleValidationErrorException(ValidationErrorCode.unknownMsg, exception);
        }
        if (isIndirect) {
            crl_entry = crl.getRevokedCertificate(CertPathValidatorUtilitiesCanl.getSerialNumber(cert));
            if (crl_entry == null) {
                return;
            }
            X500Principal certificateIssuer = crl_entry.getCertificateIssuer();
            X500Name certIssuer = certificateIssuer == null ? PrincipalUtils.getIssuerPrincipal(crl) : X500Name.getInstance((Object)certificateIssuer.getEncoded());
            if (!PrincipalUtils.getEncodedIssuerPrincipal(cert).equals((Object)certIssuer)) {
                return;
            }
        } else {
            if (!PrincipalUtils.getEncodedIssuerPrincipal(cert).equals((Object)PrincipalUtils.getIssuerPrincipal(crl))) {
                return;
            }
            crl_entry = crl.getRevokedCertificate(CertPathValidatorUtilitiesCanl.getSerialNumber(cert));
            if (crl_entry == null) {
                return;
            }
        }
        ASN1Enumerated reasonCode = null;
        if (crl_entry.hasExtensions()) {
            try {
                reasonCode = ASN1Enumerated.getInstance((Object)CertPathValidatorUtilities.getExtensionValue(crl_entry, Extension.reasonCode.getId()));
            }
            catch (Exception e) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlReasonExtError, e);
            }
        }
        if (validDate.getTime() >= crl_entry.getRevocationDate().getTime() || reasonCode == null || reasonCode.getValue().intValue() == 0 || reasonCode.getValue().intValue() == 1 || reasonCode.getValue().intValue() == 2 || reasonCode.getValue().intValue() == 8) {
            if (reasonCode != null) {
                certStatus.setCertStatus(reasonCode.getValue().intValue());
            } else {
                certStatus.setCertStatus(0);
            }
            certStatus.setRevocationDate(crl_entry.getRevocationDate());
        }
    }
}

