/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import eu.emi.security.authn.x509.helpers.proxy.ProxyCertInfoExtension;
import eu.emi.security.authn.x509.proxy.ProxyPolicy;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DLSequence;

public class DraftRFCProxyCertInfoExtension
extends ProxyCertInfoExtension {
    public static final String DRAFT_EXTENSION_OID = "1.3.6.1.4.1.3536.1.222";

    public DraftRFCProxyCertInfoExtension(int pathLen, ProxyPolicy policy) {
        this.pathLen = pathLen;
        this.policy = policy;
    }

    public DraftRFCProxyCertInfoExtension() {
        this.policy = new ProxyPolicy("1.3.6.1.5.5.7.21.1");
    }

    public DraftRFCProxyCertInfoExtension(byte[] bytes) throws IOException {
        this((ASN1Sequence)ASN1Primitive.fromByteArray((byte[])bytes));
    }

    public DraftRFCProxyCertInfoExtension(ASN1Sequence seq) throws IOException {
        ASN1Object pathLenObj;
        int index = 0;
        if (seq == null || seq.size() == 0) {
            throw new IOException("ProxyCertInfoExtension is empty");
        }
        if (!(seq.getObjectAt(index) instanceof DLSequence)) {
            throw new IOException("ProxyCertInfoExtension parser error, expected policy sequence, but got: " + seq.getObjectAt(index).getClass());
        }
        this.policy = new ProxyPolicy((ASN1Sequence)((DLSequence)seq.getObjectAt(index)));
        if (seq.size() <= ++index) {
            return;
        }
        if (seq.getObjectAt(index) instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagged = (ASN1TaggedObject)seq.getObjectAt(index);
            if (tagged.getTagNo() != 1) {
                throw new IOException("ProxyCertInfoExtension parser error, expected path constraint tagged with 1 but was tagged with " + tagged.getTagNo());
            }
            pathLenObj = tagged.getExplicitBaseObject();
            if (!(pathLenObj instanceof ASN1Integer)) {
                throw new IOException("ProxyCertInfoExtension parser error, expected path constraint of integer type but got " + pathLenObj);
            }
        } else {
            throw new IOException("ProxyCertInfoExtension parser error, expected path constraint encoded as tagged integer but but got " + seq.getObjectAt(index));
        }
        this.pathLen = ((ASN1Integer)pathLenObj).getValue().intValue();
        if (seq.size() > ++index) {
            throw new IOException("ProxyCertInfoExtension parser error, sequence contains too many items");
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.policy == null) {
            throw new IllegalArgumentException("Can't generate ProxyCertInfoExtension without mandatory policy");
        }
        v.add((ASN1Encodable)this.policy.toASN1Primitive());
        if (this.pathLen != Integer.MAX_VALUE) {
            v.add((ASN1Encodable)new BERTaggedObject(true, 1, (ASN1Encodable)new ASN1Integer((long)this.pathLen)));
        }
        return new DLSequence(v);
    }
}

