/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;

public class ProxyAddressRestrictionData
extends ASN1Object {
    public static final String SOURCE_RESTRICTION_OID = "1.2.840.113612.5.5.1.1.2.1";
    public static final String TARGET_RESTRICTION_OID = "1.2.840.113612.5.5.1.1.2.2";
    private List<GeneralSubtree> permittedGeneralSubtrees = new ArrayList<GeneralSubtree>();
    private List<GeneralSubtree> excludedGeneralSubtrees = new ArrayList<GeneralSubtree>();

    public ProxyAddressRestrictionData(byte[] bytes) throws IOException {
        ASN1Sequence nameSpaceRestrictionsSeq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])bytes);
        switch (nameSpaceRestrictionsSeq.size()) {
            case 0: {
                return;
            }
            case 1: {
                ASN1TaggedObject taggedSequence = (ASN1TaggedObject)nameSpaceRestrictionsSeq.getObjectAt(0);
                if (taggedSequence.getTagNo() == 0) {
                    ProxyAddressRestrictionData.copyCondSequenceToVector((ASN1Sequence)taggedSequence.getBaseObject(), this.permittedGeneralSubtrees);
                    break;
                }
                if (taggedSequence.getTagNo() == 1) {
                    ProxyAddressRestrictionData.copyCondSequenceToVector((ASN1Sequence)taggedSequence.getBaseObject(), this.excludedGeneralSubtrees);
                    break;
                }
                throw new IllegalArgumentException("Illegal tag number in the proxy restriction NameConstraints data structure: " + taggedSequence.getTagNo() + ", should have been 0 or 1");
            }
            case 2: {
                ASN1TaggedObject taggedSequence = (ASN1TaggedObject)nameSpaceRestrictionsSeq.getObjectAt(0);
                if (taggedSequence.getTagNo() != 0) {
                    throw new IllegalArgumentException("Illegal tag number in the proxy restriction NameConstraints data structure at the first position: " + taggedSequence.getTagNo() + ", should have been 0");
                }
                ProxyAddressRestrictionData.copyCondSequenceToVector((ASN1Sequence)taggedSequence.getBaseObject(), this.permittedGeneralSubtrees);
                taggedSequence = (ASN1TaggedObject)nameSpaceRestrictionsSeq.getObjectAt(1);
                if (taggedSequence.getTagNo() == 1) {
                    ProxyAddressRestrictionData.copyCondSequenceToVector((ASN1Sequence)taggedSequence.getBaseObject(), this.excludedGeneralSubtrees);
                    break;
                }
                throw new IllegalArgumentException("Illegal tag number in the proxy restriction NameConstraints data structure at the second position: " + taggedSequence.getTagNo() + ", should have been 1");
            }
            default: {
                throw new IllegalArgumentException("Illegal number of items in the proxy restriction NameConstraints data structure: " + nameSpaceRestrictionsSeq.size() + ", should have been 0 to 2");
            }
        }
    }

    public static ProxyAddressRestrictionData getInstance(X509Certificate certificate, boolean source) throws IOException {
        byte[] ext = CertificateHelpers.getExtensionBytes(certificate, source ? SOURCE_RESTRICTION_OID : TARGET_RESTRICTION_OID);
        if (ext == null) {
            return null;
        }
        return new ProxyAddressRestrictionData(ext);
    }

    public ProxyAddressRestrictionData() {
    }

    private static void copyCondSequenceToVector(ASN1Sequence subSeq, List<GeneralSubtree> vector) {
        Enumeration subTreeEnum = subSeq.getObjects();
        while (subTreeEnum.hasMoreElements()) {
            ASN1Primitive object = (ASN1Primitive)subTreeEnum.nextElement();
            vector.add(GeneralSubtree.getInstance((Object)object));
        }
    }

    public void addPermittedIPAddressWithNetmask(String address) {
        this.permittedGeneralSubtrees.add(new GeneralSubtree(new GeneralName(7, address), null, null));
    }

    public void addExcludedIPAddressWithNetmask(String address) {
        this.excludedGeneralSubtrees.add(new GeneralSubtree(new GeneralName(7, address), null, null));
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector nameConstraintsSequenceVector = new ASN1EncodableVector();
        ProxyAddressRestrictionData.addTaggedSequenceOfSubtrees(0, this.permittedGeneralSubtrees, nameConstraintsSequenceVector);
        ProxyAddressRestrictionData.addTaggedSequenceOfSubtrees(1, this.excludedGeneralSubtrees, nameConstraintsSequenceVector);
        return new DERSequence(nameConstraintsSequenceVector);
    }

    private static void addTaggedSequenceOfSubtrees(int tagNo, List<GeneralSubtree> subtrees, ASN1EncodableVector asn1Vector) {
        if (!subtrees.isEmpty()) {
            ASN1EncodableVector subtreesSequenceVector = new ASN1EncodableVector();
            Iterator<GeneralSubtree> generalSubtreesEnum = subtrees.iterator();
            while (generalSubtreesEnum.hasNext()) {
                subtreesSequenceVector.add((ASN1Encodable)generalSubtreesEnum.next());
            }
            asn1Vector.add((ASN1Encodable)new DERTaggedObject(tagNo, (ASN1Encodable)new DERSequence(subtreesSequenceVector)));
        }
    }

    public byte[][][] getIPSpaces() {
        byte[][] allowedIPSpaces = ProxyAddressRestrictionData.subtreesIntoArray(this.permittedGeneralSubtrees);
        byte[][] excludedIPSpaces = ProxyAddressRestrictionData.subtreesIntoArray(this.excludedGeneralSubtrees);
        return new byte[][][]{allowedIPSpaces, excludedIPSpaces};
    }

    public String[] getPermittedAddresses() {
        byte[][][] spaces = this.getIPSpaces();
        return ProxyAddressRestrictionData.convert2strings(spaces[0]);
    }

    public String[] getExcludedAddresses() {
        byte[][][] spaces = this.getIPSpaces();
        return ProxyAddressRestrictionData.convert2strings(spaces[1]);
    }

    private static byte[][] subtreesIntoArray(List<GeneralSubtree> subtrees) {
        if (subtrees == null) {
            return null;
        }
        ArrayList<byte[]> ips = new ArrayList<byte[]>();
        Iterator<GeneralSubtree> enumGeneralNames = subtrees.iterator();
        while (enumGeneralNames.hasNext()) {
            GeneralName item = enumGeneralNames.next().getBase();
            if (item.getTagNo() != 7) continue;
            ASN1OctetString octets = (ASN1OctetString)item.getName();
            byte[] bytes = octets.getOctets();
            ips.add(bytes);
        }
        return (byte[][])ips.toArray((T[])new byte[ips.size()][]);
    }

    public static String convert2sr(byte[] src) {
        int half = src.length / 2;
        StringBuilder ret = new StringBuilder(40);
        boolean ipv6 = src.length == 32;
        for (int i = 0; i < half; ++i) {
            ret.append(ipv6 ? Integer.toHexString(src[i] & 0xFF) : Integer.valueOf(src[i] & 0xFF));
            if (i >= half - 1) continue;
            ret.append(ipv6 ? ":" : ".");
        }
        ret.append("/");
        int mask = 0;
        for (int i = half; i < src.length; ++i) {
            mask += Integer.bitCount(src[i] & 0xFF);
        }
        ret.append(mask);
        return ret.toString();
    }

    public static String[] convert2strings(byte[][] src) {
        String[] ret = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            ret[i] = ProxyAddressRestrictionData.convert2sr(src[i]);
        }
        return ret;
    }
}

