/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.helpers.proxy.DraftRFCProxyCertInfoExtension;
import eu.emi.security.authn.x509.helpers.proxy.RFCProxyCertInfoExtension;
import eu.emi.security.authn.x509.proxy.ProxyPolicy;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Object;

public abstract class ProxyCertInfoExtension
extends ASN1Object {
    protected int pathLen = Integer.MAX_VALUE;
    protected ProxyPolicy policy;

    public static ProxyCertInfoExtension getInstance(X509Certificate cert) throws IOException {
        byte[] bytes = CertificateHelpers.getExtensionBytes(cert, "1.3.6.1.5.5.7.1.14");
        if (bytes != null) {
            return new RFCProxyCertInfoExtension(bytes);
        }
        bytes = CertificateHelpers.getExtensionBytes(cert, "1.3.6.1.4.1.3536.1.222");
        if (bytes == null) {
            return null;
        }
        return new DraftRFCProxyCertInfoExtension(bytes);
    }

    public int getProxyPathLimit() {
        return this.pathLen;
    }

    public ProxyPolicy getPolicy() {
        return this.policy;
    }
}

