/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.revocation;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.helpers.pkipath.ExtPKIXParameters2;
import eu.emi.security.authn.x509.helpers.pkipath.SimpleValidationErrorException;
import eu.emi.security.authn.x509.helpers.pkipath.bc.RFC3280CertPathUtilitiesCanl;
import eu.emi.security.authn.x509.helpers.revocation.RevocationChecker;
import eu.emi.security.authn.x509.helpers.revocation.RevocationStatus;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.bouncycastle.jcajce.util.BCJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;

public class CRLRevocationChecker
implements RevocationChecker {
    private ExtPKIXParameters2 paramsPKIX;
    private Date validDate;
    private PublicKey workingPublicKey;
    private List<?> certificates;
    private CrlCheckingMode checkingMode;
    private JcaJceHelper jcaHelper;

    public CRLRevocationChecker(ExtPKIXParameters2 paramsPKIX, Date validDate, PublicKey workingPublicKey, List<?> certificates, CrlCheckingMode checkingMode) {
        this.paramsPKIX = paramsPKIX;
        this.validDate = validDate;
        this.workingPublicKey = workingPublicKey;
        this.certificates = certificates;
        this.checkingMode = checkingMode;
        this.jcaHelper = new BCJcaJceHelper();
    }

    @Override
    public RevocationStatus checkRevocation(X509Certificate certitifcate, X509Certificate issuer) throws SimpleValidationErrorException {
        if (this.checkingMode == CrlCheckingMode.IGNORE) {
            return RevocationStatus.unknown;
        }
        try {
            RFC3280CertPathUtilitiesCanl.checkCRLs2(this.paramsPKIX, certitifcate, this.validDate, issuer, this.workingPublicKey, this.certificates, this.jcaHelper);
        }
        catch (SimpleValidationErrorException e) {
            if (e.getCode() == ValidationErrorCode.noValidCrlFound && this.checkingMode == CrlCheckingMode.IF_VALID) {
                return RevocationStatus.unknown;
            }
            throw e;
        }
        return RevocationStatus.verified;
    }
}

