/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ssl;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.util.IPAddress;

public class HostnameToCertificateChecker {
    public boolean checkMatching(String hostname, X509Certificate certificate) throws CertificateParsingException, UnknownHostException {
        ResultWrapper result = new ResultWrapper();
        if (this.checkAltNameMatching(result, hostname, certificate)) {
            return result.result;
        }
        return this.checkCNMatching(hostname, certificate);
    }

    protected boolean checkAltNameMatching(ResultWrapper result, String hostname, X509Certificate certificate) throws CertificateParsingException, UnknownHostException {
        Collection<List<?>> collection = certificate.getSubjectAlternativeNames();
        if (collection == null) {
            return false;
        }
        boolean ipAsHostname = IPAddress.isValid((String)hostname);
        boolean applicable = false;
        for (List<?> item : collection) {
            String ipString;
            int type = (Integer)item.get(0);
            if (type == 2) {
                String dnsName;
                applicable = true;
                if (ipAsHostname || !HostnameToCertificateChecker.matchesDNS(hostname, dnsName = (String)item.get(1))) continue;
                result.result = true;
                return applicable;
            }
            if (type != 7 || !ipAsHostname || !this.matchesIP(hostname, ipString = (String)item.get(1))) continue;
            result.result = true;
            return applicable;
        }
        return applicable;
    }

    protected boolean checkCNMatching(String hostname, X509Certificate certificate) {
        X500Principal principal = certificate.getSubjectX500Principal();
        if ("".equals(principal.getName())) {
            return false;
        }
        String cnValue = this.getMostSpecificCN(principal);
        if (cnValue == null) {
            return false;
        }
        int index = cnValue.indexOf(47);
        if (index >= 0) {
            cnValue = cnValue.substring(index + 1, cnValue.length());
        }
        return HostnameToCertificateChecker.matchesDNS(hostname, cnValue);
    }

    public static boolean matchesDNS(String hostname, String pattern) {
        String regexp = HostnameToCertificateChecker.makeRegexpHostWildcard(pattern);
        Pattern p = Pattern.compile(regexp, 2);
        return p.matcher(hostname).matches();
    }

    public static String makeRegexpHostWildcard(String pattern) {
        String[] rPNames = pattern.split("\\*");
        StringBuilder patternB = new StringBuilder();
        if (pattern.startsWith("*")) {
            patternB.append("[^\\.]*");
        }
        for (int i = 0; i < rPNames.length; ++i) {
            patternB.append(Pattern.quote(rPNames[i]));
            if (i + 1 >= rPNames.length) continue;
            patternB.append("[^\\.]*");
        }
        if (pattern.endsWith("*")) {
            patternB.append("[^\\.]*");
        }
        return patternB.toString();
    }

    protected boolean matchesIP(String what, String pattern) throws UnknownHostException {
        byte[] addr1 = InetAddress.getByName(what).getAddress();
        byte[] addr2 = InetAddress.getByName(pattern).getAddress();
        return Arrays.equals(addr1, addr2);
    }

    public String getMostSpecificCN(X500Principal srcP) {
        X500Name src = CertificateHelpers.toX500Name(srcP);
        RDN[] srcRDNs = src.getRDNs();
        String ret = null;
        for (RDN rdn : srcRDNs) {
            AttributeTypeAndValue ava;
            if (rdn.isMultiValued() || !(ava = rdn.getFirst()).getType().equals((ASN1Primitive)BCStyle.CN)) continue;
            ret = IETFUtils.valueToString((ASN1Encodable)ava.getValue());
        }
        return ret;
    }

    static {
        CertificateUtils.configureSecProvider();
    }

    protected static class ResultWrapper {
        private boolean result = false;

        protected ResultWrapper() {
        }
    }
}

