/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ssl;

import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.helpers.ssl.DisabledNameMismatchCallback;
import eu.emi.security.authn.x509.helpers.ssl.HostnameToCertificateChecker;
import eu.emi.security.authn.x509.impl.HostnameMismatchCallback2;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;

public class SSLTrustManagerWithHostnameChecking
extends X509ExtendedTrustManager {
    protected final X509CertChainValidator validator;
    private final HostnameToCertificateChecker hostnameChecker = new HostnameToCertificateChecker();
    private final HostnameMismatchCallback2 hostnameMismatchCallback;

    public SSLTrustManagerWithHostnameChecking(X509CertChainValidator validator, HostnameMismatchCallback2 hostnameMismatchCallback) {
        this.validator = validator;
        this.hostnameMismatchCallback = hostnameMismatchCallback == null ? new DisabledNameMismatchCallback() : hostnameMismatchCallback;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkIfTrusted(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkIfTrusted(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.validator.getTrustedIssuers();
    }

    protected void checkIfTrusted(X509Certificate[] certChain) throws CertificateException {
        ValidationResult result = this.validator.validate(certChain);
        if (!result.isValid()) {
            result.toString();
            String subject = "";
            if (certChain != null && certChain.length > 0) {
                subject = certChain[0].getSubjectX500Principal().getName();
            }
            throw new CertificateException("The peer's certificate with subject's DN " + subject + " was rejected. The peer's certificate status is: " + result.toString());
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkIfTrusted(chain);
        if (socket != null && socket instanceof SSLSocket) {
            this.verifyHostname(chain, (SSLSocket)socket);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkIfTrusted(chain);
        if (socket != null && socket instanceof SSLSocket) {
            this.verifyHostname(chain, (SSLSocket)socket);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkIfTrusted(chain);
        if (engine != null) {
            this.verifyHostname(chain, engine);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkIfTrusted(chain);
        if (engine != null) {
            this.verifyHostname(chain, engine);
        }
    }

    private void verifyHostname(X509Certificate[] chain, SSLEngine engine) throws CertificateException {
        X509Certificate cert = chain[0];
        String hostname = engine.getPeerHost();
        this.verifyHostname(cert, hostname);
    }

    private void verifyHostname(X509Certificate[] chain, SSLSocket socket) throws CertificateException {
        X509Certificate cert = chain[0];
        String hostname = socket.getInetAddress().getHostName();
        this.verifyHostname(cert, hostname);
    }

    private void verifyHostname(X509Certificate cert, String hostname) throws CertificateException {
        boolean result;
        try {
            result = this.hostnameChecker.checkMatching(hostname, cert);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't check peer's address against its certificate", e);
        }
        if (!result) {
            this.hostnameMismatchCallback.nameMismatch(cert, hostname);
        }
    }
}

