/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.helpers.crl.AbstractCRLStoreSPI;
import eu.emi.security.authn.x509.helpers.crl.LazyOpensslCRLStoreSpi;
import eu.emi.security.authn.x509.helpers.crl.OpensslCRLStoreSpi;
import eu.emi.security.authn.x509.helpers.ns.NamespaceChecker;
import eu.emi.security.authn.x509.helpers.pkipath.AbstractValidator;
import eu.emi.security.authn.x509.helpers.trust.LazyOpensslTrustAnchorStoreImpl;
import eu.emi.security.authn.x509.helpers.trust.OpensslTrustAnchorStore;
import eu.emi.security.authn.x509.helpers.trust.OpensslTrustAnchorStoreImpl;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import eu.emi.security.authn.x509.impl.ValidatorParamsExt;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.Timer;

public class OpensslCertChainValidator
extends AbstractValidator {
    private OpensslTrustAnchorStore trustStore;
    private AbstractCRLStoreSPI crlStore;
    private final NamespaceCheckingMode namespaceMode;
    private String path;
    private final boolean lazyMode;
    protected static final Timer timer = new Timer("caNl validator (openssl) timer", true);

    public OpensslCertChainValidator(String directory, NamespaceCheckingMode namespaceMode, long updateInterval, ValidatorParams params) {
        this(directory, false, namespaceMode, updateInterval, params, true);
    }

    public OpensslCertChainValidator(String directory, boolean openssl1Mode, NamespaceCheckingMode namespaceMode, long updateInterval, ValidatorParams params) {
        this(directory, openssl1Mode, namespaceMode, updateInterval, params, true);
    }

    public OpensslCertChainValidator(String directory, boolean openssl1Mode, NamespaceCheckingMode namespaceMode, long updateInterval, ValidatorParams params, boolean lazyMode) {
        super(params.getInitialListeners());
        this.path = directory;
        this.lazyMode = lazyMode;
        this.namespaceMode = namespaceMode;
        this.trustStore = lazyMode ? new LazyOpensslTrustAnchorStoreImpl(directory, updateInterval, this.observers, openssl1Mode) : new OpensslTrustAnchorStoreImpl(directory, timer, updateInterval, namespaceMode.globusEnabled(), namespaceMode.euGridPmaEnabled(), this.observers, openssl1Mode);
        try {
            this.crlStore = lazyMode ? new LazyOpensslCRLStoreSpi(directory, updateInterval, this.observers, openssl1Mode) : new OpensslCRLStoreSpi(directory, updateInterval, timer, this.observers, openssl1Mode);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("BUG: OpensslCRLStoreSpi can not be initialized", e);
        }
        this.init(this.trustStore, this.crlStore, params.isAllowProxy(), params.getRevocationSettings());
    }

    public OpensslCertChainValidator(String directory, NamespaceCheckingMode namespaceMode, long updateInterval) {
        this(directory, namespaceMode, updateInterval, new ValidatorParams());
    }

    public OpensslCertChainValidator(String directory) {
        this(directory, NamespaceCheckingMode.EUGRIDPMA_GLOBUS, 600000L, new ValidatorParamsExt());
    }

    public String getTruststorePath() {
        return this.path;
    }

    public NamespaceCheckingMode getNamespaceCheckingMode() {
        return this.namespaceMode;
    }

    public long getUpdateInterval() {
        return this.trustStore.getUpdateInterval();
    }

    public void setUpdateInterval(long updateInterval) {
        this.trustStore.setUpdateInterval(updateInterval);
        this.crlStore.setUpdateInterval(updateInterval);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.trustStore.dispose();
        this.crlStore.dispose();
    }

    @Override
    public ValidationResult validate(X509Certificate[] certChain) {
        Set<TrustAnchor> anchors;
        if (this.lazyMode) {
            LazyOpensslTrustAnchorStoreImpl lazyTAStore = (LazyOpensslTrustAnchorStoreImpl)this.trustStore;
            anchors = lazyTAStore.getTrustAnchorsFor(certChain);
        } else {
            anchors = this.trustStore.getTrustAnchors();
        }
        ValidationResult result = super.validate(certChain, anchors);
        NamespaceChecker checker = new NamespaceChecker(this.namespaceMode, this.trustStore.getPmaNsStore(), this.trustStore.getGlobusNsStore());
        List<ValidationError> errors = checker.check(certChain);
        this.processErrorList(errors);
        result.addErrors(errors);
        return result;
    }
}

