/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.ssl.SSLTrustManagerWithHostnameChecking;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.HostnameMismatchCallback2;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SocketFactoryCreator2 {
    private final X509Credential credential;
    private final X509CertChainValidator validator;
    private final SecureRandom rnd;
    private final HostnameMismatchCallback2 hostnameMismatchCallback;
    private final String protocol;

    public SocketFactoryCreator2(X509Credential credential, X509CertChainValidator validator, HostnameMismatchCallback2 hostnameMismatchCallback, SecureRandom rnd, String protocol) {
        this.credential = credential;
        this.validator = validator;
        this.rnd = rnd;
        this.hostnameMismatchCallback = hostnameMismatchCallback;
        this.protocol = protocol;
    }

    public SocketFactoryCreator2(X509Credential credential, X509CertChainValidator validator, HostnameMismatchCallback2 hostnameMismatchCallback) {
        this(credential, validator, hostnameMismatchCallback, new SecureRandom(), "TLS");
    }

    public SocketFactoryCreator2(X509CertChainValidator validator, HostnameMismatchCallback2 hostnameMismatchCallback, SecureRandom rnd, String protocol) {
        this(null, validator, hostnameMismatchCallback, rnd, protocol);
    }

    public SocketFactoryCreator2(X509CertChainValidator validator, HostnameMismatchCallback2 hostnameMismatchCallback) {
        this(null, validator, hostnameMismatchCallback, new SecureRandom(), "TLS");
    }

    public X509TrustManager getSSLTrustManager() {
        return new SSLTrustManagerWithHostnameChecking(this.validator, this.hostnameMismatchCallback);
    }

    public SSLContext getSSLContext() {
        SSLContext sslCtx;
        KeyManager[] keyManagerArray;
        if (this.credential == null) {
            keyManagerArray = null;
        } else {
            KeyManager[] keyManagerArray2 = new KeyManager[1];
            keyManagerArray = keyManagerArray2;
            keyManagerArray2[0] = this.credential.getKeyManager();
        }
        KeyManager[] kms = keyManagerArray;
        SSLTrustManagerWithHostnameChecking tm = new SSLTrustManagerWithHostnameChecking(this.validator, this.hostnameMismatchCallback);
        try {
            sslCtx = SSLContext.getInstance(this.protocol);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("The TLS protocol is unsupported by the JDK, a serious installation problem?", e);
        }
        try {
            sslCtx.init(kms, new TrustManager[]{tm}, this.rnd);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Shouldn't happen - SSLContext can't be initiated?", e);
        }
        return sslCtx;
    }

    public SSLServerSocketFactory getServerSocketFactory() {
        return this.getSSLContext().getServerSocketFactory();
    }

    public SSLSocketFactory getSocketFactory() {
        return this.getSSLContext().getSocketFactory();
    }

    static {
        CertificateUtils.configureSecProvider();
    }
}

