/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.proxy;

import eu.emi.security.authn.x509.helpers.proxy.DraftRFCProxyCertInfoExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyAddressRestrictionData;
import eu.emi.security.authn.x509.helpers.proxy.ProxyCSRImpl;
import eu.emi.security.authn.x509.helpers.proxy.ProxyCertInfoExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyGeneratorHelper;
import eu.emi.security.authn.x509.helpers.proxy.ProxySAMLExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyTracingExtension;
import eu.emi.security.authn.x509.helpers.proxy.RFCProxyCertInfoExtension;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.proxy.CertificateExtension;
import eu.emi.security.authn.x509.proxy.ProxyCSR;
import eu.emi.security.authn.x509.proxy.ProxyCertificateOptions;
import eu.emi.security.authn.x509.proxy.ProxyPolicy;
import eu.emi.security.authn.x509.proxy.ProxyType;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;

public class ProxyCSRGenerator {
    public static ProxyCSR generate(ProxyCertificateOptions param) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateEncodingException {
        return ProxyCSRGenerator.generate(param, null);
    }

    public static ProxyCSR generate(ProxyCertificateOptions param, PrivateKey signingKey) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateEncodingException {
        PKCS10CertificationRequest req;
        PublicKey pubKey = param.getPublicKey();
        KeyPair keyPair = pubKey == null ? ProxyGeneratorHelper.generateKeyPair(param.getKeyLength()) : new KeyPair(pubKey, null);
        if (signingKey == null) {
            signingKey = keyPair.getPrivate();
        }
        if (signingKey == null) {
            throw new IllegalArgumentException("Signing (private) key can not be null when using a manually set public key");
        }
        X509Certificate[] chain = param.getParentCertChain();
        ProxyType type = param.getType();
        BigInteger serial = ProxyGeneratorHelper.establishSerial(param);
        X500Name proxySubjectName = ProxyGeneratorHelper.generateDN(chain[0].getSubjectX500Principal(), type, param.isLimited(), serial);
        List<Attribute> attributes = ProxyCSRGenerator.generateAttributes(param);
        try {
            ASN1InputStream is = new ASN1InputStream(keyPair.getPublic().getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)is.readObject());
            is.close();
            PKCS10CertificationRequestBuilder builder = new PKCS10CertificationRequestBuilder(proxySubjectName, subjectPublicKeyInfo);
            for (Attribute attribute : attributes) {
                builder.addAttribute(attribute.getAttrType(), attribute.getAttributeValues());
            }
            AlgorithmIdentifier signatureAi = new AlgorithmIdentifier(OIWObjectIdentifiers.sha1WithRSA);
            AlgorithmIdentifier hashAi = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
            BcRSAContentSignerBuilder csBuilder = new BcRSAContentSignerBuilder(signatureAi, hashAi);
            AsymmetricKeyParameter pkParam = PrivateKeyFactory.createKey((byte[])signingKey.getEncoded());
            ContentSigner signer = csBuilder.build(pkParam);
            req = builder.build(signer);
        }
        catch (IOException e) {
            throw new InvalidKeyException("Probelm with the proxy CSR private key", e);
        }
        catch (OperatorCreationException e) {
            throw new SignatureException("Problem signing the proxy CSR", e);
        }
        return new ProxyCSRImpl(req, keyPair.getPrivate());
    }

    private static List<Attribute> generateAttributes(ProxyCertificateOptions param) {
        CertificateExtension ext;
        ASN1Object extValue;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        List<CertificateExtension> additionalExts = param.getExtensions();
        for (CertificateExtension ext2 : additionalExts) {
            ProxyCSRGenerator.addAttribute(attributes, ext2);
        }
        ProxyPolicy policy = param.getPolicy();
        int pathLimit = param.getProxyPathLimit();
        if (param.getType() != ProxyType.LEGACY && (policy != null || pathLimit != -1)) {
            if (policy == null) {
                policy = new ProxyPolicy("1.3.6.1.5.5.7.21.1");
            }
            String oid = param.getType() == ProxyType.DRAFT_RFC ? "1.3.6.1.4.1.3536.1.222" : "1.3.6.1.5.5.7.1.14";
            ProxyCertInfoExtension extValue2 = param.getType() == ProxyType.DRAFT_RFC ? new DraftRFCProxyCertInfoExtension(pathLimit, policy) : new RFCProxyCertInfoExtension(pathLimit, policy);
            CertificateExtension ext3 = new CertificateExtension(oid, extValue2, true);
            ProxyCSRGenerator.addAttribute(attributes, ext3);
        }
        if (param.getProxyTracingIssuer() != null) {
            extValue = new ProxyTracingExtension(param.getProxyTracingIssuer());
            ext = new CertificateExtension("1.2.840.113612.5.5.1.1.1.1", extValue, false);
            ProxyCSRGenerator.addAttribute(attributes, ext);
        }
        if (param.getProxyTracingSubject() != null) {
            extValue = new ProxyTracingExtension(param.getProxyTracingSubject());
            ext = new CertificateExtension("1.2.840.113612.5.5.1.1.1.2", extValue, false);
            ProxyCSRGenerator.addAttribute(attributes, ext);
        }
        if (param.getSAMLAssertion() != null) {
            extValue = new ProxySAMLExtension(param.getSAMLAssertion());
            ext = new CertificateExtension("1.3.6.1.4.1.3536.1.1.1.12", extValue, false);
            ProxyCSRGenerator.addAttribute(attributes, ext);
        }
        String[] srcExcl = param.getSourceRestrictionExcludedAddresses();
        String[] srcPerm = param.getSourceRestrictionPermittedAddresses();
        if (srcExcl != null || srcPerm != null) {
            ProxyAddressRestrictionData extValue3 = new ProxyAddressRestrictionData();
            if (srcExcl != null) {
                for (String addr : srcExcl) {
                    extValue3.addExcludedIPAddressWithNetmask(addr);
                }
            }
            if (srcPerm != null) {
                for (String addr : srcPerm) {
                    extValue3.addPermittedIPAddressWithNetmask(addr);
                }
            }
            CertificateExtension ext4 = new CertificateExtension("1.2.840.113612.5.5.1.1.2.1", extValue3, false);
            ProxyCSRGenerator.addAttribute(attributes, ext4);
        }
        String[] tgtExcl = param.getTargetRestrictionExcludedAddresses();
        String[] tgtPerm = param.getTargetRestrictionPermittedAddresses();
        if (tgtExcl != null || tgtPerm != null) {
            ProxyAddressRestrictionData extValue4 = new ProxyAddressRestrictionData();
            if (tgtExcl != null) {
                String[] stringArray = tgtExcl;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String addr = stringArray[i];
                    extValue4.addExcludedIPAddressWithNetmask(addr);
                }
            }
            if (tgtPerm != null) {
                for (String addr : tgtPerm) {
                    extValue4.addPermittedIPAddressWithNetmask(addr);
                }
            }
            CertificateExtension ext5 = new CertificateExtension("1.2.840.113612.5.5.1.1.2.2", extValue4, false);
            ProxyCSRGenerator.addAttribute(attributes, ext5);
        }
        return attributes;
    }

    private static void addAttribute(List<Attribute> attributes, ASN1Encodable ext) {
        Attribute a = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Set)new DERSet(ext));
        attributes.add(a);
    }

    static {
        CertificateUtils.configureSecProvider();
    }
}

