/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.proxy;

import eu.emi.security.authn.x509.helpers.JavaAndBCStyle;
import eu.emi.security.authn.x509.helpers.proxy.DraftRFCProxyCertInfoExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyAddressRestrictionData;
import eu.emi.security.authn.x509.helpers.proxy.ProxyCertInfoExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyHelper;
import eu.emi.security.authn.x509.helpers.proxy.ProxySAMLExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyTracingExtension;
import eu.emi.security.authn.x509.helpers.proxy.RFCProxyCertInfoExtension;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.proxy.CertificateExtension;
import eu.emi.security.authn.x509.proxy.ProxyPolicy;
import eu.emi.security.authn.x509.proxy.ProxyType;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class ProxyCSRInfo {
    private PKCS10CertificationRequest csr;
    private List<CertificateExtension> extensions = new ArrayList<CertificateExtension>();
    private String samlAssertion;
    private ProxyCertInfoExtension proxyExt;
    private String proxyExtOid;
    private String tracingSubject;
    private String tracingIssuer;
    private String[][] sourceRestrictions;
    private String[][] targetRestrictions;

    public ProxyCSRInfo(PKCS10CertificationRequest csr) throws CertificateException {
        this.csr = csr;
        try {
            this.parseRequestedExtensions();
        }
        catch (IOException e) {
            throw new CertificateException("The CSR can not be parsed as a Proxy CSR", e);
        }
    }

    public ProxyType getProxyType() {
        String value;
        if (this.proxyExtOid != null && this.proxyExtOid.equals("1.3.6.1.5.5.7.1.14")) {
            return ProxyType.RFC3820;
        }
        if (this.proxyExtOid != null && this.proxyExtOid.equals("1.3.6.1.4.1.3536.1.222")) {
            return ProxyType.DRAFT_RFC;
        }
        try {
            value = this.getLastCN();
        }
        catch (IllegalArgumentException e) {
            value = "";
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The CSR can not be parsed", e);
        }
        if ("proxy".equals(value.toLowerCase()) || "limited proxy".equals(value.toLowerCase())) {
            return ProxyType.LEGACY;
        }
        return null;
    }

    private String getLastCN() throws IllegalArgumentException, IOException {
        byte[] subject = this.csr.getSubject().getEncoded("DER");
        X500Name withDefaultStyle = X500Name.getInstance((Object)subject);
        JavaAndBCStyle style = new JavaAndBCStyle();
        return ProxyHelper.getLastCN(X500Name.getInstance((X500NameStyle)style, (Object)withDefaultStyle));
    }

    public Boolean isLimited() {
        String value;
        ProxyPolicy policy = this.getPolicy();
        if (policy != null) {
            return "1.3.6.1.4.1.3536.1.1.1.9".equals(policy.getPolicyOID());
        }
        try {
            value = this.getLastCN();
        }
        catch (IllegalArgumentException e) {
            value = "";
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The CSR can not be parsed", e);
        }
        if (value.toLowerCase().equals("proxy")) {
            return false;
        }
        if ("limited proxy".equals(value.toLowerCase())) {
            return true;
        }
        return null;
    }

    public ProxyPolicy getPolicy() {
        if (this.proxyExt == null) {
            return null;
        }
        return this.proxyExt.getPolicy();
    }

    public String getProxyTracingIssuer() {
        return this.tracingIssuer;
    }

    public String getProxyTracingSubject() {
        return this.tracingSubject;
    }

    public String getSAMLExtension() {
        return this.samlAssertion;
    }

    public Integer getProxyPathLimit() {
        if (this.proxyExt == null) {
            return Integer.MAX_VALUE;
        }
        return this.proxyExt.getProxyPathLimit();
    }

    public String[][] getProxySourceRestrictions() {
        return this.sourceRestrictions;
    }

    public String[][] getProxyTargetRestrictions() {
        return this.targetRestrictions;
    }

    private void parseRequestedExtensions() throws IOException {
        Attribute[] attrs = this.csr.getAttributes();
        if (attrs == null) {
            return;
        }
        for (Attribute attr : attrs) {
            if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.getId().equals(attr.getAttrType().getId()) || attr.getAttrValues().size() == 0) continue;
            ASN1Encodable req = attr.getAttrValues().getObjectAt(0);
            CertificateExtension ext = new CertificateExtension(req.toASN1Primitive().getEncoded("DER"));
            this.handleRequestedExtension(ext);
        }
    }

    private void handleRequestedExtension(CertificateExtension ext) throws IOException {
        String oid = ext.getOid();
        byte[] val = ((ASN1Object)ext.getValue()).toASN1Primitive().getEncoded("DER");
        if (oid.equals("1.3.6.1.4.1.3536.1.222")) {
            this.proxyExtOid = oid;
            this.proxyExt = new DraftRFCProxyCertInfoExtension(val);
        } else if (oid.equals("1.3.6.1.5.5.7.1.14")) {
            this.proxyExtOid = oid;
            this.proxyExt = new RFCProxyCertInfoExtension(val);
        } else if (oid.equals("1.3.6.1.4.1.3536.1.1.1.10") || oid.equals("1.3.6.1.4.1.3536.1.1.1.12")) {
            this.samlAssertion = new ProxySAMLExtension(val).getSAML();
        } else if (oid.equals("1.2.840.113612.5.5.1.1.1.1")) {
            this.tracingIssuer = new ProxyTracingExtension(val).getURL();
        } else if (oid.equals("1.2.840.113612.5.5.1.1.1.2")) {
            this.tracingSubject = new ProxyTracingExtension(val).getURL();
        } else if (oid.equals("1.2.840.113612.5.5.1.1.2.1")) {
            this.sourceRestrictions = new String[2][];
            this.sourceRestrictions[0] = new ProxyAddressRestrictionData(val).getPermittedAddresses();
            this.sourceRestrictions[1] = new ProxyAddressRestrictionData(val).getExcludedAddresses();
        } else if (oid.equals("1.2.840.113612.5.5.1.1.2.2")) {
            this.targetRestrictions = new String[2][];
            this.targetRestrictions[0] = new ProxyAddressRestrictionData(val).getPermittedAddresses();
            this.targetRestrictions[1] = new ProxyAddressRestrictionData(val).getExcludedAddresses();
        } else {
            this.extensions.add(ext);
        }
    }

    static {
        CertificateUtils.configureSecProvider();
    }
}

