/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.common.tsw;

import ec.tss.tsproviders.common.tsw.TswSeries;
import ec.tss.tsproviders.common.tsw.TswSource;
import ec.tss.tsproviders.utils.IParser;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tss.tsproviders.utils.Parsers;
import ec.tstoolkit.design.VisibleForTesting;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.utilities.CheckedIterator;
import ec.tstoolkit.utilities.DoubleList;
import ec.tstoolkit.utilities.IntList;
import ec.tstoolkit.utilities.Tokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class TswFactory {
    private static final Charset TSW_CHARSET = StandardCharsets.US_ASCII;
    private static final int TSW_NAN = -99999;

    TswFactory() {
    }

    public abstract @NonNull TswSource load(@NonNull Path var1) throws IOException;

    public abstract @NonNull List<TswSeries> loadFile(@NonNull Path var1) throws IOException;

    public static @NonNull TswFactory getDefault() {
        return NewTswFactory.INSTANCE;
    }

    private static @Nullable TswSeries loadSeries(@NonNull String fileName, @NonNull CheckedIterator<String, IOException> iterator) throws IOException {
        TsDomain domain;
        String name;
        if (!iterator.hasNext() || (name = NameParser.INSTANCE.parse((CharSequence)iterator.next())) == null) {
            return null;
        }
        if (!iterator.hasNext() || (domain = DomainParser.INSTANCE.parse((CharSequence)iterator.next())) == null) {
            return null;
        }
        DoubleList values = new DoubleList();
        ValueParser valueParser = new ValueParser();
        while (iterator.hasNext() && values.size() < domain.getLength()) {
            Tokenizer tokenizer = new Tokenizer((String)iterator.next());
            while (tokenizer.hasNextToken()) {
                String token = tokenizer.nextToken();
                if (values.size() >= domain.getLength()) continue;
                Number value = (Number)valueParser.parse(token);
                if (value == null) {
                    return new TswSeries(fileName, name, OptionalTsData.absent((String)("Cannot parse value at line " + (values.size() + 2))));
                }
                double tmp = value.doubleValue();
                values.add(tmp == -99999.0 ? Double.NaN : tmp);
            }
        }
        TsData result = new TsData(domain.getStart(), values.toArray(), false);
        return new TswSeries(fileName, name, OptionalTsData.present((TsData)result));
    }

    @VisibleForTesting
    static final class NewTswFactory
    extends ATswFactory {
        @VisibleForTesting
        static final NewTswFactory INSTANCE = new NewTswFactory();

        NewTswFactory() {
        }

        @Override
        protected DirectoryStream.Filter<Path> getFilter() {
            return TswFilters.ANY_FILE;
        }

        @Override
        protected List<TswSeries> loadFile(String fileName, CheckedIterator<String, IOException> iterator) throws IOException {
            ArrayList<TswSeries> result = new ArrayList<TswSeries>();
            while (iterator.hasNext()) {
                TswSeries series = TswFactory.loadSeries(fileName, (CheckedIterator<String, IOException>)iterator);
                if (series == null) continue;
                result.add(series);
            }
            return result;
        }
    }

    private static final class NameParser
    implements IParser<String> {
        private static final NameParser INSTANCE = new NameParser();

        private NameParser() {
        }

        public String parse(CharSequence input) throws NullPointerException {
            String result = input.toString().trim();
            return result.isEmpty() ? null : result;
        }
    }

    private static final class DomainParser
    implements IParser<TsDomain> {
        private static final DomainParser INSTANCE = new DomainParser();

        private DomainParser() {
        }

        public TsDomain parse(CharSequence input) throws NullPointerException {
            IntList params = DomainParser.parseIntegers(input.toString());
            if (params == null || params.size() != 4) {
                return null;
            }
            int count = params.get(0);
            int year = params.get(1);
            int period = params.get(2);
            int freq = params.get(3);
            if (count < 0) {
                return null;
            }
            if (freq < 1 || freq > 12 || 12 % freq != 0) {
                return null;
            }
            if (period <= 0 || period > freq) {
                return null;
            }
            return new TsDomain(TsFrequency.valueOf((int)freq), year, period - 1, count);
        }

        private static @Nullable IntList parseIntegers(String input) {
            IntList result = new IntList();
            Tokenizer tokenizer = new Tokenizer(input);
            Parsers.Parser paramParser = Parsers.intParser();
            while (tokenizer.hasNextToken()) {
                String token = tokenizer.nextToken();
                Integer tmp = (Integer)paramParser.parse((CharSequence)token);
                if (tmp == null) {
                    return null;
                }
                result.add(tmp.intValue());
            }
            return result;
        }
    }

    private static final class ValueParser
    extends Parsers.FailSafeParser<Number> {
        private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ROOT);

        private ValueParser() {
        }

        protected Number doParse(CharSequence input) throws Exception {
            String tmp = input.toString().trim();
            if (tmp.startsWith("+")) {
                tmp = tmp.substring(1);
            }
            return this.numberFormat.parse(tmp);
        }
    }

    @VisibleForTesting
    static final class OldTswFactory
    extends ATswFactory {
        @VisibleForTesting
        static final OldTswFactory INSTANCE = new OldTswFactory();

        OldTswFactory() {
        }

        @Override
        protected DirectoryStream.Filter<Path> getFilter() {
            return TswFilters.FILE_WITHOUT_EXTENSION;
        }

        @Override
        protected List<TswSeries> loadFile(String fileName, CheckedIterator<String, IOException> iterator) throws IOException {
            TswSeries series;
            if (iterator.hasNext() && (series = TswFactory.loadSeries(fileName, (CheckedIterator<String, IOException>)iterator)) != null) {
                return Collections.singletonList(series);
            }
            return Collections.emptyList();
        }
    }

    private static enum TswFilters implements DirectoryStream.Filter<Path>
    {
        ANY_FILE{

            @Override
            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory(entry, new LinkOption[0]);
            }
        }
        ,
        FILE_WITHOUT_EXTENSION{

            @Override
            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory(entry, new LinkOption[0]) && !entry.getFileName().toString().contains(".");
            }
        };

    }

    private static abstract class ATswFactory
    extends TswFactory {
        private ATswFactory() {
        }

        @Override
        public TswSource load(@NonNull Path repository) throws IOException {
            ArrayList<TswSeries> result = new ArrayList<TswSeries>();
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(repository, this.getFilter());){
                for (Path file : ds) {
                    try {
                        result.addAll(this.loadFile(file));
                    }
                    catch (MalformedInputException malformedInputException) {}
                }
            }
            return new TswSource(repository.toFile(), result);
        }

        protected abstract @NonNull DirectoryStream.Filter<Path> getFilter();

        @Override
        public List<TswSeries> loadFile(Path file) throws IOException {
            String fileName = file.getFileName().toString();
            try (BufferedReader reader = Files.newBufferedReader(file, TSW_CHARSET);){
                List<TswSeries> list = this.loadFile(fileName, (CheckedIterator<String, IOException>)CheckedIterator.fromBufferedReader((BufferedReader)reader));
                return list;
            }
        }

        protected abstract @NonNull List<TswSeries> loadFile(String var1, CheckedIterator<String, IOException> var2) throws IOException;
    }
}

