/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.common.tsw;

import ec.tss.TsAsyncMode;
import ec.tss.TsCollectionInformation;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.common.tsw.TswBean;
import ec.tss.tsproviders.common.tsw.TswFactory;
import ec.tss.tsproviders.common.tsw.TswSeries;
import ec.tss.tsproviders.common.tsw.TswSource;
import ec.tss.tsproviders.utils.AbstractFileLoader;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.Params;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TswProvider
extends AbstractFileLoader<TswSource, TswBean> {
    public static final String SOURCE = "TSW";
    public static final String VERSION = "20111201";
    static final IParam<DataSet, String> Z_FILENAME = Params.onString((String)"", (String)"fileName");
    static final IParam<DataSet, String> Z_NAME = Params.onString((String)"", (String)"name");
    private static final Logger LOGGER = LoggerFactory.getLogger(TswProvider.class);

    public TswProvider() {
        super(LOGGER, SOURCE, TsAsyncMode.Once);
    }

    public String getDisplayName() {
        return "TSW files";
    }

    public TswBean newBean() {
        return new TswBean();
    }

    public DataSource encodeBean(Object bean) throws IllegalArgumentException {
        try {
            return ((TswBean)bean).toDataSource(SOURCE, VERSION);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public TswBean decodeBean(DataSource dataSource) {
        return new TswBean(this.support.check(dataSource, new IConstraint[0]));
    }

    public boolean accept(File pathname) {
        return pathname.isDirectory();
    }

    public String getFileDescription() {
        return "TSW file";
    }

    public List<DataSet> children(DataSet parent) throws IllegalArgumentException, IOException {
        Objects.requireNonNull(parent);
        throw new IllegalArgumentException("Not supported yet.");
    }

    protected TswSource loadFromBean(TswBean bean) throws Exception {
        return TswFactory.getDefault().load(this.getRealFile(bean.getFile()).toPath());
    }

    protected void fillCollection(TsCollectionInformation info, DataSource dataSource) throws IOException {
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES);
        for (TswSeries o : this.getSource((DataSource)dataSource).items) {
            DataSet child = ((DataSet.Builder)((DataSet.Builder)builder.put(Z_FILENAME, (Object)o.fileName)).put(Z_NAME, (Object)o.name)).build();
            info.items.add(this.support.fillSeries(this.newTsInformation(child, TsInformationType.All), o.data, true));
        }
        info.type = TsInformationType.All;
    }

    protected void fillCollection(TsCollectionInformation info, DataSet dataSet) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void fillSeries(TsInformation info, DataSet dataSet) throws IOException {
        TswSeries series = this.getSeries(dataSet);
        this.support.fillSeries(info, series.data, true);
        info.name = this.getDisplayName(dataSet);
        info.type = TsInformationType.All;
    }

    public List<DataSet> children(DataSource dataSource) throws IllegalArgumentException, IOException {
        this.support.check(dataSource, new IConstraint[0]);
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES);
        return this.getSource((DataSource)dataSource).items.stream().map(o -> ((DataSet.Builder)((DataSet.Builder)builder.put(Z_FILENAME, (Object)o.fileName)).put(Z_NAME, (Object)o.name)).build()).collect(Collectors.toList());
    }

    public String getDisplayName(DataSet dataSet) {
        this.support.check(dataSet, new IConstraint[0]);
        try {
            return this.getSeries((DataSet)dataSet).name;
        }
        catch (IOException ex) {
            return (String)Z_FILENAME.get((IConfig)dataSet);
        }
    }

    public String getDisplayNodeName(DataSet dataSet) throws IllegalArgumentException {
        return this.getDisplayName(dataSet);
    }

    public TswSource getSource(DataSource dataSource) throws IOException {
        return (TswSource)this.support.getValue(this.cache, dataSource);
    }

    public TswSeries getSeries(DataSet dataSet) throws IOException {
        this.support.check(dataSet, new IConstraint[0]);
        String fileName = (String)Z_FILENAME.get((IConfig)dataSet);
        String name = (String)Z_NAME.get((IConfig)dataSet);
        List<TswSeries> items = this.getSource((DataSource)dataSet.getDataSource()).items;
        if (!name.isEmpty()) {
            for (TswSeries s : items) {
                if (!s.fileName.equals(fileName) || !s.name.equals(name)) continue;
                return s;
            }
        } else {
            for (TswSeries s : items) {
                if (!s.fileName.equals(fileName)) continue;
                return s;
            }
        }
        throw new FileNotFoundException(fileName);
    }
}

