/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.common.txt;

import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IDataSourceBean;
import ec.tss.tsproviders.IFileBean;
import ec.tss.tsproviders.utils.DataFormat;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.Params;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Locale;

public class TxtBean
implements IFileBean,
IDataSourceBean {
    static final IParam<DataSource, File> FILE = Params.onFile((File)Paths.get("", new String[0]).toFile(), (String)"file");
    static final IParam<DataSource, DataFormat> DATAFORMAT = Params.onDataFormat((DataFormat)DataFormat.of((Locale)Locale.ENGLISH, (String)"yyyy-MM-DD", null), (String)"locale", (String)"datePattern", (String)"numberPattern");
    static final IParam<DataSource, Charset> CHARSET = Params.onCharset((Charset)StandardCharsets.UTF_8, (String)"charset");
    static final IParam<DataSource, Delimiter> DELIMITER = Params.onEnum((Enum)Delimiter.TAB, (String)"delimiter");
    static final IParam<DataSource, Boolean> HEADERS = Params.onBoolean((Boolean)true, (String)"headers");
    static final IParam<DataSource, Integer> SKIPLINES = Params.onInteger((Integer)0, (String)"skipLines");
    static final IParam<DataSource, TextQualifier> TEXT_QUALIFIER = Params.onEnum((Enum)TextQualifier.NONE, (String)"textQualifier");
    static final IParam<DataSource, TsFrequency> X_FREQUENCY = Params.onEnum((Enum)TsFrequency.Undefined, (String)"frequency");
    static final IParam<DataSource, TsAggregationType> X_AGGREGATION_TYPE = Params.onEnum((Enum)TsAggregationType.None, (String)"aggregationType");
    static final IParam<DataSource, Boolean> X_CLEAN_MISSING = Params.onBoolean((Boolean)false, (String)"cleanMissing");
    File file;
    DataFormat dataFormat;
    Charset charset;
    Delimiter delimiter;
    TextQualifier textQualifier;
    boolean headers;
    int skipLines;
    TsFrequency frequency;
    TsAggregationType aggregationType;
    boolean cleanMissing;

    public TxtBean() {
        this.file = (File)FILE.defaultValue();
        this.dataFormat = (DataFormat)DATAFORMAT.defaultValue();
        this.charset = (Charset)CHARSET.defaultValue();
        this.delimiter = (Delimiter)((Object)DELIMITER.defaultValue());
        this.textQualifier = (TextQualifier)((Object)TEXT_QUALIFIER.defaultValue());
        this.headers = (Boolean)HEADERS.defaultValue();
        this.skipLines = (Integer)SKIPLINES.defaultValue();
        this.frequency = (TsFrequency)X_FREQUENCY.defaultValue();
        this.aggregationType = (TsAggregationType)X_AGGREGATION_TYPE.defaultValue();
        this.cleanMissing = (Boolean)X_CLEAN_MISSING.defaultValue();
    }

    public TxtBean(DataSource dataSource) {
        this.file = (File)FILE.get((IConfig)dataSource);
        this.dataFormat = (DataFormat)DATAFORMAT.get((IConfig)dataSource);
        this.charset = (Charset)CHARSET.get((IConfig)dataSource);
        this.delimiter = (Delimiter)((Object)DELIMITER.get((IConfig)dataSource));
        this.textQualifier = (TextQualifier)((Object)TEXT_QUALIFIER.get((IConfig)dataSource));
        this.headers = (Boolean)HEADERS.get((IConfig)dataSource);
        this.skipLines = (Integer)SKIPLINES.get((IConfig)dataSource);
        this.frequency = (TsFrequency)X_FREQUENCY.get((IConfig)dataSource);
        this.aggregationType = (TsAggregationType)X_AGGREGATION_TYPE.get((IConfig)dataSource);
        this.cleanMissing = (Boolean)X_CLEAN_MISSING.get((IConfig)dataSource);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Delimiter getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(Delimiter delimiter) {
        this.delimiter = delimiter;
    }

    public TextQualifier getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(TextQualifier textQualifier) {
        this.textQualifier = textQualifier;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(int skipLines) {
        this.skipLines = skipLines;
    }

    public boolean isHeaders() {
        return this.headers;
    }

    public void setHeaders(boolean headers) {
        this.headers = headers;
    }

    public TsFrequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(TsFrequency frequency) {
        this.frequency = frequency;
        if (frequency == TsFrequency.Undefined) {
            this.aggregationType = TsAggregationType.None;
        }
    }

    public TsAggregationType getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(TsAggregationType aggregationType) {
        if (this.frequency != TsFrequency.Undefined) {
            this.aggregationType = aggregationType;
        }
    }

    public boolean isCleanMissing() {
        return this.cleanMissing;
    }

    public void setCleanMissing(boolean clean) {
        this.cleanMissing = clean;
    }

    public DataSource toDataSource(String providerName, String version) {
        DataSource.Builder builder = DataSource.builder((String)providerName, (String)version);
        FILE.set((IConfig.Builder)builder, (Object)this.file);
        DATAFORMAT.set((IConfig.Builder)builder, (Object)this.dataFormat);
        CHARSET.set((IConfig.Builder)builder, (Object)this.charset);
        DELIMITER.set((IConfig.Builder)builder, (Object)this.delimiter);
        TEXT_QUALIFIER.set((IConfig.Builder)builder, (Object)this.textQualifier);
        HEADERS.set((IConfig.Builder)builder, (Object)this.headers);
        SKIPLINES.set((IConfig.Builder)builder, (Object)this.skipLines);
        X_FREQUENCY.set((IConfig.Builder)builder, (Object)this.frequency);
        X_AGGREGATION_TYPE.set((IConfig.Builder)builder, (Object)this.aggregationType);
        X_CLEAN_MISSING.set((IConfig.Builder)builder, (Object)this.cleanMissing);
        return builder.build();
    }

    @Deprecated
    public DataSource toDataSource() {
        return this.toDataSource("Txt", "20111201");
    }

    @Deprecated
    public static TxtBean from(DataSource dataSource) {
        return new TxtBean(dataSource);
    }

    public static enum Delimiter {
        TAB,
        SEMICOLON,
        COMMA,
        SPACE;

    }

    public static enum TextQualifier {
        NONE,
        QUOTE,
        DOUBLE_QUOTE;

    }
}

