/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.common.txt;

import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IFileBean;
import ec.tss.tsproviders.common.txt.TxtBean;
import ec.tss.tsproviders.common.txt.TxtProvider;
import ec.tss.tsproviders.legacy.FileDataSourceId;
import ec.tss.tsproviders.legacy.InvalidMonikerException;
import ec.tss.tsproviders.utils.Parsers;

final class TxtLegacy {
    private TxtLegacy() {
    }

    static DataSource newDataSource(FileDataSourceId id) {
        return ((TxtBean)id.fill((IFileBean)new TxtBean())).toDataSource("Txt", "20111201");
    }

    static Parsers.Parser<DataSource> dataSourceParser() {
        return new Parsers.Parser<DataSource>(){

            public DataSource parse(CharSequence input) throws NullPointerException {
                FileDataSourceId id = FileDataSourceId.parse((CharSequence)input);
                return id != null ? TxtLegacy.newDataSource(id) : null;
            }
        };
    }

    static Parsers.Parser<DataSet> dataSetParser() {
        final Parsers.Parser<DataSource> tmp = TxtLegacy.dataSourceParser();
        return new Parsers.Parser<DataSet>(){

            public DataSet parse(CharSequence input) throws NullPointerException {
                TxtId id = TxtId.parse(input.toString());
                if (id == null) {
                    return null;
                }
                DataSource dataSource = (DataSource)tmp.parse((CharSequence)id.getFileName());
                if (dataSource == null) {
                    return null;
                }
                if (!id.isSeries()) {
                    return DataSet.of((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.COLLECTION);
                }
                return ((DataSet.Builder)DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES).put(TxtProvider.Z_SERIESINDEX, (Object)id.getIndexSeries())).build();
            }
        };
    }

    @Deprecated
    private static class TxtId {
        public static final String SEP = "@";
        private String shortFile_;
        private int indexSeries_ = -1;

        private TxtId() {
        }

        public String getFileName() {
            return this.shortFile_;
        }

        public int getIndexSeries() {
            return this.indexSeries_;
        }

        public static TxtId collection(String sfile) {
            TxtId id = new TxtId();
            id.shortFile_ = sfile;
            return id;
        }

        public static TxtId series(String sfile, int pos) {
            TxtId id = new TxtId();
            id.shortFile_ = sfile;
            id.indexSeries_ = pos;
            return id;
        }

        public static TxtId parse(String monikerId) throws InvalidMonikerException {
            String[] parts = monikerId.split(SEP);
            if (parts.length > 2) {
                return null;
            }
            try {
                TxtId id = new TxtId();
                switch (parts.length) {
                    case 2: {
                        id.indexSeries_ = Integer.parseInt(parts[1]);
                    }
                    case 1: {
                        id.shortFile_ = parts[0];
                    }
                }
                return id;
            }
            catch (NumberFormatException err) {
                return null;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.shortFile_);
            if (this.isSeries()) {
                builder.append(SEP).append(this.indexSeries_);
            }
            return builder.toString();
        }

        public boolean isSeries() {
            return this.indexSeries_ >= 0;
        }
    }
}

