/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.common.txt;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.ImmutableList;
import ec.tss.tsproviders.common.txt.TxtBean;
import ec.tss.tsproviders.common.txt.TxtSeries;
import ec.tss.tsproviders.common.txt.TxtSource;
import ec.tss.tsproviders.utils.DataFormat;
import ec.tss.tsproviders.utils.IParser;
import ec.tss.tsproviders.utils.ObsCharacteristics;
import ec.tss.tsproviders.utils.ObsGathering;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tss.tsproviders.utils.Parsers;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.utilities.CheckedIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import java.util.stream.Stream;

final class TxtLoader {
    private static final ThreadLocal<IParser<Date>> FALLBACK_PARSER = new ThreadLocal<IParser<Date>>(){

        @Override
        protected IParser<Date> initialValue() {
            ImmutableList list = (ImmutableList)Stream.of(FALLBACK_FORMATS).map(o -> DataFormat.of((Locale)Locale.ROOT, (String)o, null).dateParser()).collect(ImmutableList.toImmutableList());
            return Parsers.firstNotNull((ImmutableList)list);
        }
    };
    private static final String[] FALLBACK_FORMATS = new String[]{"yyyy-MM-dd", "yyyy MM dd", "yyyy.MM.dd", "yyyy-MMM-dd", "yyyy MMM dd", "yyyy.MMM.dd", "dd-MM-yyyy", "dd MM yyyy", "dd.MM.yyyy", "dd/MM/yyyy", "dd-MM-yy", "dd MM yy", "dd.MM.yy", "dd/MM/yy", "dd-MMM-yy", "dd MMM yy", "dd.MMM.yy", "dd/MMM/yy", "dd-MMM-yyyy", "dd MMM yyyy", "dd.MMM.yyyy", "dd/MMM/yyyy", "yyyy-MM-dd hh:mm:ss", "yyyy MM dd hh:mm:ss", "yyyy.MM.dd hh:mm:ss", "yyyy/MM/dd hh:mm:ss", "yyyy-MMM-dd hh:mm:ss", "yyyy MMM dd hh:mm:ss", "yyyy.MMM.dd hh:mm:ss", "yyyy/MMM/dd hh:mm:ss", "dd-MM-yyyy hh:mm:ss", "dd MM yyyy hh:mm:ss", "dd.MM.yyyy hh:mm:ss", "dd/MM/yyyy hh:mm:ss", "dd-MMM-yyyy hh:mm:ss", "dd MMM yyyy hh:mm:ss", "dd.MMM.yyyy hh:mm:ss", "dd/MMM/yyyy hh:mm:ss"};

    private TxtLoader() {
    }

    public static TxtSource load(File realFile, TxtBean bean) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(realFile.toPath(), bean.charset);){
            TxtSource txtSource = TxtLoader.load(reader, bean);
            return txtSource;
        }
    }

    public static TxtSource load(InputStream inputStream, TxtBean bean) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, bean.charset);){
            TxtSource txtSource = TxtLoader.load(reader, bean);
            return txtSource;
        }
    }

    private static TxtSource load(Reader reader, TxtBean bean) throws IOException {
        try (CSVReader csvReader = new CSVReader(reader, TxtLoader.toChar(bean.delimiter), TxtLoader.toChar(bean.textQualifier), bean.skipLines);){
            ObsGathering gathering = bean.cleanMissing ? ObsGathering.excludingMissingValues((TsFrequency)bean.frequency, (TsAggregationType)bean.aggregationType) : ObsGathering.includingMissingValues((TsFrequency)bean.frequency, (TsAggregationType)bean.aggregationType);
            TxtSource txtSource = TxtLoader.load(csvReader, bean.getDataFormat(), gathering, bean.isHeaders());
            return txtSource;
        }
    }

    static TxtSource load(CSVReader reader, DataFormat obsFormat, ObsGathering obsGathering, boolean header) throws IOException {
        return TxtLoader.load(TxtLoader.asCheckedIterator(reader), obsFormat, obsGathering, header);
    }

    private static TxtSource load(CheckedIterator<String[], IOException> iterator, DataFormat obsFormat, ObsGathering obsGathering, boolean header) throws IOException {
        int i;
        int nbrRows = 0;
        int nbrUselessRows = 0;
        String[] titles = new String[]{};
        IParser dateParser = obsFormat.dateParser().orElse(FALLBACK_PARSER.get());
        Parsers.Parser numberParser = obsFormat.numberParser();
        GregorianCalendar cal = new GregorianCalendar();
        ArrayList<OptionalTsData.Builder2> dataCollectors = new ArrayList<OptionalTsData.Builder2>();
        while (iterator.hasNext()) {
            String[] line = (String[])iterator.next();
            if (line == null) {
                throw new RuntimeException("Not possible");
            }
            if (nbrRows == 0) {
                titles = header ? line : TxtLoader.generateTitles(line.length);
                for (i = 1; i < titles.length; ++i) {
                    dataCollectors.add(OptionalTsData.builderByDate((Calendar)cal, (ObsGathering)obsGathering, (ObsCharacteristics[])new ObsCharacteristics[0]));
                }
            }
            if (nbrRows != 0 || !header) {
                Date period;
                Date date = period = line.length > 0 ? (Date)dateParser.parse((CharSequence)line[0]) : null;
                if (period != null) {
                    int max = Math.min(titles.length, line.length);
                    for (int i2 = 1; i2 < max; ++i2) {
                        ((OptionalTsData.Builder2)dataCollectors.get(i2 - 1)).add((Object)period, (Number)numberParser.parse((CharSequence)line[i2]));
                    }
                } else {
                    ++nbrUselessRows;
                }
            }
            ++nbrRows;
        }
        TxtSeries[] data = new TxtSeries[titles.length - 1];
        for (i = 0; i < data.length; ++i) {
            data[i] = new TxtSeries(i, titles[i + 1], ((OptionalTsData.Builder2)dataCollectors.get(i)).build());
        }
        return new TxtSource(nbrRows, nbrUselessRows, Arrays.asList(data));
    }

    static String[] generateTitles(int size) {
        return (String[])IntStream.range(0, size).mapToObj(i -> "Column " + i).toArray(String[]::new);
    }

    static char toChar(TxtBean.Delimiter delimiter) {
        switch (delimiter) {
            case COMMA: {
                return ',';
            }
            case SEMICOLON: {
                return ';';
            }
            case SPACE: {
                return ' ';
            }
            case TAB: {
                return '\t';
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static char toChar(TxtBean.TextQualifier textQualifier) {
        switch (textQualifier) {
            case DOUBLE_QUOTE: {
                return '\"';
            }
            case QUOTE: {
                return '\'';
            }
            case NONE: {
                return '\"';
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static CheckedIterator<String[], IOException> asCheckedIterator(final CSVReader reader) {
        return new CheckedIterator<String[], IOException>(){
            private String[] nextItem = null;

            public boolean hasNext() throws IOException {
                if (this.nextItem != null) {
                    return true;
                }
                this.nextItem = reader.readNext();
                return this.nextItem != null;
            }

            public String[] next() throws IOException, NoSuchElementException {
                if (this.nextItem != null || this.hasNext()) {
                    String[] item = this.nextItem;
                    this.nextItem = null;
                    return item;
                }
                throw new NoSuchElementException();
            }
        };
    }
}

