/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.common.txt;

import ec.tss.TsAsyncMode;
import ec.tss.TsCollectionInformation;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.common.txt.TxtBean;
import ec.tss.tsproviders.common.txt.TxtFileFilter;
import ec.tss.tsproviders.common.txt.TxtLegacy;
import ec.tss.tsproviders.common.txt.TxtLoader;
import ec.tss.tsproviders.common.txt.TxtSeries;
import ec.tss.tsproviders.common.txt.TxtSource;
import ec.tss.tsproviders.utils.AbstractFileLoader;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tss.tsproviders.utils.Params;
import ec.tss.tsproviders.utils.Parsers;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtProvider
extends AbstractFileLoader<TxtSource, TxtBean> {
    public static final String SOURCE = "Txt";
    public static final String VERSION = "20111201";
    static final IParam<DataSet, Integer> Z_SERIESINDEX = Params.onInteger((Integer)-1, (String)"seriesIndex");
    private static final Logger LOGGER = LoggerFactory.getLogger(TxtProvider.class);
    private final TxtFileFilter fileFilter = new TxtFileFilter();
    protected final Parsers.Parser<DataSource> legacyDataSourceParser = TxtLegacy.dataSourceParser();
    protected final Parsers.Parser<DataSet> legacyDataSetParser = TxtLegacy.dataSetParser();

    public TxtProvider() {
        super(LOGGER, SOURCE, TsAsyncMode.Once);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet toDataSet(TsMoniker moniker) throws IllegalArgumentException {
        DataSet result = super.toDataSet(moniker);
        if (result != null) {
            return result;
        }
        Parsers.Parser<DataSet> parser = this.legacyDataSetParser;
        synchronized (parser) {
            return (DataSet)this.legacyDataSetParser.parse((CharSequence)moniker.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource toDataSource(TsMoniker moniker) throws IllegalArgumentException {
        DataSource result = super.toDataSource(moniker);
        if (result != null) {
            return result;
        }
        Parsers.Parser<DataSource> parser = this.legacyDataSourceParser;
        synchronized (parser) {
            return (DataSource)this.legacyDataSourceParser.parse((CharSequence)moniker.getId());
        }
    }

    protected TxtSource loadFromBean(TxtBean bean) throws Exception {
        File realFile = this.getRealFile(bean.getFile());
        return TxtLoader.load(realFile, bean);
    }

    public String getDisplayName() {
        return "Txt files";
    }

    public String getDisplayName(DataSource dataSource) {
        TxtBean bean = this.decodeBean(dataSource);
        return TsFrequency.Undefined != bean.getFrequency() ? bean.getFile().getPath() + " " + OptionalTsData.Builder.toString((TsFrequency)bean.getFrequency(), (TsAggregationType)bean.getAggregationType()) : bean.getFile().getPath();
    }

    public String getDisplayName(DataSet dataSet) {
        this.support.check(dataSet, new IConstraint[0]);
        Integer index = (Integer)Z_SERIESINDEX.get((IConfig)dataSet);
        TxtSource tmp = (TxtSource)this.cache.getIfPresent((Object)dataSet.getDataSource());
        if (tmp == null) {
            return "Column " + index;
        }
        return tmp.items.get((int)index.intValue()).name;
    }

    public List<DataSet> children(DataSource dataSource) throws IOException {
        this.support.check(dataSource, new IConstraint[0]);
        TxtSource tmp = this.getSource(dataSource);
        if (tmp.items.isEmpty()) {
            return Collections.emptyList();
        }
        DataSet[] children = new DataSet[tmp.items.size()];
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES);
        for (int i = 0; i < children.length; ++i) {
            children[i] = ((DataSet.Builder)builder.put(Z_SERIESINDEX, (Object)i)).build();
        }
        return Arrays.asList(children);
    }

    protected void fillCollection(TsCollectionInformation info, DataSource dataSource) throws IOException {
        TxtSource source = this.getSource(dataSource);
        info.type = TsInformationType.All;
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES);
        for (TxtSeries o : source.items) {
            DataSet child = ((DataSet.Builder)builder.put(Z_SERIESINDEX, (Object)o.index)).build();
            info.items.add(this.support.fillSeries(this.newTsInformation(child, TsInformationType.All), o.data, ((Boolean)TxtBean.X_CLEAN_MISSING.get((IConfig)dataSource)).booleanValue()));
        }
    }

    protected void fillCollection(TsCollectionInformation info, DataSet dataSet) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void fillSeries(TsInformation info, DataSet dataSet) throws IOException {
        TxtSeries series = this.getSeries(dataSet);
        this.support.fillSeries(info, series.data, ((Boolean)TxtBean.X_CLEAN_MISSING.get((IConfig)dataSet.getDataSource())).booleanValue());
        info.name = this.getDisplayName(dataSet);
        info.type = TsInformationType.All;
    }

    public TxtSource getSource(DataSource dataSource) throws IOException {
        return (TxtSource)this.support.getValue(this.cache, dataSource);
    }

    public TxtSeries getSeries(DataSet dataSet) throws IOException {
        return this.getSource((DataSource)dataSet.getDataSource()).items.get((Integer)Z_SERIESINDEX.get((IConfig)dataSet));
    }

    public TxtBean newBean() {
        return new TxtBean();
    }

    public DataSource encodeBean(Object bean) throws IllegalArgumentException {
        try {
            return ((TxtBean)bean).toDataSource(SOURCE, VERSION);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public TxtBean decodeBean(DataSource dataSource) {
        return new TxtBean(this.support.check(dataSource, new IConstraint[0]));
    }

    public boolean accept(File pathname) {
        return this.fileFilter.accept(pathname);
    }

    public String getFileDescription() {
        return this.fileFilter.getDescription();
    }

    public List<DataSet> children(DataSet parent) throws IllegalArgumentException, IOException {
        Objects.requireNonNull(parent);
        throw new IllegalArgumentException("Not supported yet.");
    }

    public String getDisplayNodeName(DataSet dataSet) throws IllegalArgumentException {
        return this.getDisplayName(dataSet);
    }
}

