/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.common.uscb;

import ec.tss.tsproviders.legacy.FileDataSourceId;
import ec.tss.tsproviders.utils.IParser;
import ec.tss.tsproviders.utils.Parsers;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.Tokenizer;
import java.io.BufferedReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UscbAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UscbAccessor.class);
    private static final Charset USCB_CHARSET = Charset.defaultCharset();
    private final FileDataSourceId m_id;

    public UscbAccessor(FileDataSourceId id) {
        this.m_id = id;
    }

    public FileDataSourceId getId() {
        return this.m_id;
    }

    public TsData read(String uscbFolder) {
        Path file = Paths.get(uscbFolder, this.m_id.getFileName());
        TsData s = this.read_out(file);
        return s != null ? s : this.read_in(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TsData read_out(Path file) {
        try (BufferedReader br = Files.newBufferedReader(file, USCB_CHARSET);){
            String line = br.readLine();
            if (line == null) {
                TsData tsData = null;
                return tsData;
            }
            Tokenizer tokenizer = new Tokenizer(line);
            if (!tokenizer.hasNextToken() || !tokenizer.nextToken().equals("date")) {
                TsData tsData = null;
                return tsData;
            }
            String name = "";
            if (tokenizer.hasNextToken()) {
                name = tokenizer.nextToken();
            }
            ArrayList<USCensusObs> vals = new ArrayList<USCensusObs>();
            int maxfreq = 0;
            while ((line = br.readLine()) != null) {
                USCensusObs obs = new USCensusObs();
                if (obs.parse_Out(line)) {
                    vals.add(obs);
                }
                if (obs.period <= maxfreq) continue;
                maxfreq = obs.period;
            }
            TsData tsData = this.create(vals, maxfreq);
            return tsData;
        }
        catch (Exception ex) {
            LOGGER.error("While reading data", (Throwable)ex);
            return null;
        }
    }

    private TsData read_in(Path file) {
        TsData tsData;
        block10: {
            BufferedReader br = Files.newBufferedReader(file, USCB_CHARSET);
            try {
                String line;
                ArrayList<USCensusObs> vals = new ArrayList<USCensusObs>();
                int maxfreq = 0;
                while ((line = br.readLine()) != null) {
                    USCensusObs obs = new USCensusObs();
                    if (obs.parse_In(line)) {
                        vals.add(obs);
                    }
                    if (obs.period <= maxfreq) continue;
                    maxfreq = obs.period;
                }
                tsData = this.create(vals, maxfreq);
                if (br == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOGGER.error("While reading data", (Throwable)ex);
                    return null;
                }
            }
            br.close();
        }
        return tsData;
    }

    private TsData create(List<USCensusObs> vals, int maxfreq) {
        if (vals.isEmpty()) {
            return null;
        }
        TsPeriod start = new TsPeriod(TsFrequency.valueOf((int)maxfreq), vals.get((int)0).year, vals.get((int)0).period - 1);
        TsPeriod cur = new TsPeriod(TsFrequency.valueOf((int)maxfreq));
        int lastval = vals.size() - 1;
        cur.set(vals.get((int)lastval).year, vals.get((int)lastval).period - 1);
        double[] data = new double[cur.minus(start) + 1];
        for (int i = 0; i < data.length; ++i) {
            data[i] = Double.NaN;
        }
        for (USCensusObs obs : vals) {
            cur.set(obs.year, obs.period - 1);
            int pos = cur.minus(start);
            data[pos] = obs.obs;
        }
        TsData series = new TsData(start, data, false);
        return series;
    }

    static class USCensusObs {
        static final double ND = -99999.0;
        static final IParser<Double> VALUE_PARSER = Parsers.doubleParser();
        int year;
        int period;
        double obs;

        USCensusObs() {
        }

        boolean parse_Out(String line) {
            try {
                String date = null;
                String val = null;
                Tokenizer tokenizer = new Tokenizer(line);
                if (tokenizer.hasNextToken()) {
                    date = tokenizer.nextToken();
                }
                if (tokenizer.hasNextToken()) {
                    val = tokenizer.nextToken();
                }
                if (date != null && val != null) {
                    this.year = Integer.parseInt(date.substring(0, 4));
                    this.period = Integer.parseInt(date.substring(4, 6));
                    this.obs = VALUE_PARSER.parseValue((CharSequence)val).orElse(-99999.0);
                    if (this.obs == -99999.0) {
                        this.obs = Double.NaN;
                    }
                }
                return this.year > 0 && this.period > 0;
            }
            catch (NullPointerException | NumberFormatException ex) {
                LOGGER.error("While parsing data", (Throwable)ex);
                return false;
            }
        }

        boolean parse_In(String line) {
            try {
                Tokenizer tokenizer = new Tokenizer(line);
                if (tokenizer.hasNextToken()) {
                    this.year = Integer.parseInt(tokenizer.nextToken());
                }
                if (tokenizer.hasNextToken()) {
                    this.period = Integer.parseInt(tokenizer.nextToken());
                }
                if (tokenizer.hasNextToken()) {
                    this.obs = VALUE_PARSER.parseValue((CharSequence)tokenizer.nextToken()).orElse(Double.NaN);
                }
                return this.year > 0 && this.period > 0 && !tokenizer.hasNextToken();
            }
            catch (NullPointerException | NumberFormatException ex) {
                LOGGER.error("While parsing data", (Throwable)ex);
                return false;
            }
        }
    }
}

