/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.common.uscb;

import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import ec.tss.TsAsyncMode;
import ec.tss.TsCollectionInformation;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IDataSourceListener;
import ec.tss.tsproviders.IDataSourceProvider;
import ec.tss.tsproviders.common.uscb.FromUscbId;
import ec.tss.tsproviders.common.uscb.UscbAccessor;
import ec.tss.tsproviders.legacy.FileDataSourceId;
import ec.tss.tsproviders.legacy.InvalidMonikerException;
import ec.tss.tsproviders.utils.DataSourceSupport;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tss.tsproviders.utils.IParser;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.Files2;
import ec.tstoolkit.utilities.GuavaCaches;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UscbProvider
implements IDataSourceProvider {
    public static final String SOURCE = "USCB";
    public static final String VERSION = "20111201";
    public static final String X_FILE = "file";
    private static final Logger LOGGER = LoggerFactory.getLogger(UscbProvider.class);
    private static final File DEFAULT_FOLDER = Files2.fromPath((String)StandardSystemProperty.USER_HOME.value(), (String[])new String[]{"Data", "USCB"});
    private final Cache<FileDataSourceId, UscbAccessor> m_accessors = GuavaCaches.softValuesCache();
    private final DataSourceSupport support;
    private final IParser<DataSource> legacyDataSourceParser = FileDataSourceId.legacyParser((String)"USCB", (String)"20111201");

    public UscbProvider() {
        this.support = DataSourceSupport.create((String)SOURCE, (Logger)LOGGER);
        this.openAll();
    }

    final void openAll() {
        File folder = Paths.get(this.getFolder(), new String[0]).toFile();
        String[] files = folder.list();
        if (files != null) {
            for (String file : files) {
                this.legacyDataSourceParser.parseValue((CharSequence)file).ifPresent(arg_0 -> ((DataSourceSupport)this.support).open(arg_0));
            }
        }
    }

    public String getFolder() {
        String folder = "";
        if (Strings.isNullOrEmpty((String)folder)) {
            folder = DEFAULT_FOLDER.getAbsolutePath();
        }
        return folder;
    }

    public String getDisplayName() {
        return SOURCE;
    }

    public void reload(DataSource dataSource) throws IllegalArgumentException {
        this.clearCache();
        this.support.reload(dataSource);
    }

    public List<DataSource> getDataSources() {
        return this.support.getDataSources();
    }

    public String getDisplayName(DataSource dataSource) {
        this.support.check(dataSource, new IConstraint[0]);
        return Paths.get(dataSource.get(X_FILE), new String[0]).toFile().getName();
    }

    public String getDisplayName(DataSet dataSet) {
        return this.getDisplayName(dataSet.getDataSource());
    }

    public List<DataSet> children(DataSource dataSource) {
        this.support.check(dataSource, new IConstraint[0]);
        return Collections.singletonList(DataSet.of((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES));
    }

    public void addDataSourceListener(IDataSourceListener listener) {
        this.support.addDataSourceListener(listener);
    }

    public void removeDataSourceListener(IDataSourceListener listener) {
        this.support.removeDataSourceListener(listener);
    }

    public TsMoniker toMoniker(DataSet dataSet) throws IllegalArgumentException {
        return new TsMoniker(this.getSource(), dataSet.getDataSource().get(X_FILE));
    }

    public TsMoniker toMoniker(DataSource dataSource) throws IllegalArgumentException {
        return this.support.toMoniker(dataSource);
    }

    public DataSet toDataSet(TsMoniker moniker) {
        Objects.requireNonNull(moniker);
        throw new IllegalArgumentException("Not supported");
    }

    public DataSource toDataSource(TsMoniker moniker) {
        DataSource result = this.support.toDataSource(moniker);
        return result != null ? result : (DataSource)this.legacyDataSourceParser.parse((CharSequence)moniker.getId());
    }

    private UscbAccessor getAccessor(FileDataSourceId source) {
        UscbAccessor result = (UscbAccessor)this.m_accessors.getIfPresent((Object)source);
        if (null == result) {
            result = new UscbAccessor(source);
            this.m_accessors.put((Object)source, (Object)result);
        }
        return result;
    }

    public boolean isAvailable() {
        return true;
    }

    public String getSource() {
        return SOURCE;
    }

    public void clearCache() {
        this.m_accessors.invalidateAll();
    }

    public void dispose() {
        this.clearCache();
    }

    public TsAsyncMode getAsyncMode() {
        return TsAsyncMode.Once;
    }

    public boolean queryTsCollection(TsMoniker moniker, TsInformationType type) {
        Objects.requireNonNull(moniker, "Moniker cannot be null");
        Objects.requireNonNull(type, "Type cannot be null");
        return false;
    }

    public boolean get(TsCollectionInformation tsci) {
        if (!tsci.moniker.getSource().equals(this.getSource())) {
            return false;
        }
        String identifier = tsci.moniker.getId();
        String fullpath = this.getFolder() + identifier;
        tsci.name = tsci.moniker.getId();
        String[] files = Paths.get(fullpath, new String[0]).toFile().list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String cur = Paths.get(files[i], new String[0]).toFile().getName();
                String id = "";
                if (identifier == null) {
                    id = cur;
                } else {
                    File file1 = Paths.get(identifier, new String[0]).toFile();
                    File file2 = file1.toPath().resolve(cur).toFile();
                    id = file2.getPath();
                }
                TsMoniker moniker = new TsMoniker(this.getSource(), id);
                TsInformation sinfo = new TsInformation(cur, moniker, tsci.type);
                if (!this.get(sinfo)) continue;
                tsci.items.add(sinfo);
            }
        }
        return true;
    }

    public boolean queryTs(TsMoniker moniker, TsInformationType type) {
        Objects.requireNonNull(moniker, "Moniker cannot be null");
        Objects.requireNonNull(type, "Type cannot be null");
        return false;
    }

    public boolean get(TsInformation tsi) {
        try {
            FromUscbId id = new FromUscbId(tsi.moniker.getId());
            FileDataSourceId sourceId = FileDataSourceId.from((File)Paths.get(id.getFileName(), new String[0]).toFile());
            UscbAccessor acc = this.getAccessor(sourceId);
            if (tsi.type.intValue() >= TsInformationType.Data.intValue()) {
                TsData data = acc.read(this.getFolder());
                if (data != null) {
                    tsi.data = data;
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (InvalidMonikerException ex) {
            LOGGER.error(ex.getMessage());
            return false;
        }
    }

    public List<DataSet> children(DataSet parent) throws IllegalArgumentException, IOException {
        Objects.requireNonNull(parent);
        throw new IllegalArgumentException("Not supported yet.");
    }

    public String getDisplayNodeName(DataSet dataSet) throws IllegalArgumentException {
        return this.getDisplayName(dataSet);
    }
}

