/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.common.xml;

import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IDataSourceBean;
import ec.tss.tsproviders.IFileBean;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.Params;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;

public class XmlBean
implements IFileBean,
IDataSourceBean {
    static final IParam<DataSource, File> X_FILE = Params.onFile((File)Paths.get("", new String[0]).toFile(), (String)"file");
    static final IParam<DataSource, Charset> X_CHARSET = Params.onCharset((Charset)StandardCharsets.UTF_8, (String)"charset");
    static final String EXT = "xml";
    private File file;
    private Charset charset;

    public XmlBean() {
        this.file = (File)X_FILE.defaultValue();
        this.charset = (Charset)X_CHARSET.defaultValue();
    }

    public XmlBean(DataSource dataSource) {
        this.file = (File)X_FILE.get((IConfig)dataSource);
        this.charset = (Charset)X_CHARSET.get((IConfig)dataSource);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = Paths.get(ec.tstoolkit.utilities.Paths.changeExtension((String)file.getPath(), (String)EXT), new String[0]).toFile();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public DataSource toDataSource(String providerName, String version) {
        DataSource.Builder builder = DataSource.builder((String)providerName, (String)version);
        X_FILE.set((IConfig.Builder)builder, (Object)this.file);
        X_CHARSET.set((IConfig.Builder)builder, (Object)this.charset);
        return builder.build();
    }

    @Deprecated
    public DataSource toDataSource() {
        return this.toDataSource("Xml", "20111201");
    }

    @Deprecated
    public static XmlBean from(DataSource dataSource) {
        return new XmlBean(dataSource);
    }
}

