/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.common.xml;

import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IFileBean;
import ec.tss.tsproviders.common.xml.XmlBean;
import ec.tss.tsproviders.common.xml.XmlProvider;
import ec.tss.tsproviders.legacy.FileDataSourceId;
import ec.tss.tsproviders.legacy.InvalidMonikerException;
import ec.tss.tsproviders.utils.Parsers;

final class XmlLegacy {
    private XmlLegacy() {
    }

    static DataSource newDataSource(FileDataSourceId id) {
        return ((XmlBean)id.fill((IFileBean)new XmlBean())).toDataSource("Xml", "20111201");
    }

    static Parsers.Parser<DataSource> dataSourceParser() {
        return new Parsers.Parser<DataSource>(){

            public DataSource parse(CharSequence input) throws NullPointerException {
                FileDataSourceId id = FileDataSourceId.parse((CharSequence)input);
                return id != null ? XmlLegacy.newDataSource(id) : null;
            }
        };
    }

    static Parsers.Parser<DataSet> dataSetParser() {
        final Parsers.Parser<DataSource> tmp = XmlLegacy.dataSourceParser();
        return new Parsers.Parser<DataSet>(){

            public DataSet parse(CharSequence input) throws NullPointerException {
                XmlId id = XmlId.parse(input.toString());
                if (id == null) {
                    return null;
                }
                DataSource dataSource = (DataSource)tmp.parse((CharSequence)id.getFileName());
                if (dataSource == null) {
                    return null;
                }
                if (!id.isSeries()) {
                    return ((DataSet.Builder)DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.COLLECTION).put(XmlProvider.Y_COLLECTIONINDEX, (Object)id.getIndexCollection())).build();
                }
                return ((DataSet.Builder)((DataSet.Builder)DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES).put(XmlProvider.Y_COLLECTIONINDEX, (Object)id.getIndexCollection())).put(XmlProvider.Z_SERIESINDEX, (Object)id.getIndexSeries())).build();
            }
        };
    }

    private static class XmlId {
        public static final String SEP = "@";
        private String shortFile_;
        private int indexCollection_ = -1;
        private int indexSeries_ = -1;

        private XmlId() {
        }

        public String getFileName() {
            return this.shortFile_;
        }

        public int getIndexCollection() {
            return this.indexCollection_;
        }

        public int getIndexSeries() {
            return this.indexSeries_;
        }

        public static XmlId collection(String sfile, int pos) {
            XmlId id = new XmlId();
            id.shortFile_ = sfile;
            id.indexCollection_ = pos;
            return id;
        }

        public static XmlId series(String sfile, int cpos, int spos) {
            XmlId id = new XmlId();
            id.shortFile_ = sfile;
            id.indexCollection_ = cpos;
            id.indexSeries_ = spos;
            return id;
        }

        public static XmlId parse(String monikerId) throws InvalidMonikerException {
            String[] parts = monikerId.split(SEP);
            if (parts.length > 3) {
                return null;
            }
            try {
                XmlId id = new XmlId();
                switch (parts.length) {
                    case 3: {
                        id.indexSeries_ = Integer.parseInt(parts[2]);
                    }
                    case 2: {
                        id.indexCollection_ = Integer.parseInt(parts[1]);
                    }
                    case 1: {
                        id.shortFile_ = parts[0];
                    }
                }
                return id;
            }
            catch (NumberFormatException err) {
                return null;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.shortFile_).append(SEP).append(this.indexCollection_);
            if (this.isSeries()) {
                builder.append(SEP).append(this.indexSeries_);
            }
            return builder.toString();
        }

        public boolean isCollection() {
            return -1 == this.indexSeries_;
        }

        public boolean isSeries() {
            return this.indexSeries_ >= 0;
        }
    }
}

