/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.common.xml;

import com.google.common.io.Files;
import ec.tss.TsAsyncMode;
import ec.tss.TsCollectionInformation;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.common.xml.XmlBean;
import ec.tss.tsproviders.common.xml.XmlLegacy;
import ec.tss.tsproviders.common.xml.wsTs;
import ec.tss.tsproviders.common.xml.wsTsCollection;
import ec.tss.tsproviders.common.xml.wsTsWorkspace;
import ec.tss.tsproviders.utils.AbstractFileLoader;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tss.tsproviders.utils.Params;
import ec.tss.tsproviders.utils.Parsers;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import nbbrd.io.xml.bind.Jaxb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlProvider
extends AbstractFileLoader<wsTsWorkspace, XmlBean> {
    public static final String SOURCE = "Xml";
    public static final String VERSION = "20111201";
    static final IParam<DataSet, Integer> Y_COLLECTIONINDEX = Params.onInteger((Integer)-1, (String)"collectionIndex");
    static final IParam<DataSet, Integer> Z_SERIESINDEX = Params.onInteger((Integer)-1, (String)"seriesIndex");
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlProvider.class);
    protected final Parsers.Parser<DataSource> legacyDataSourceParser = XmlLegacy.dataSourceParser();
    protected final Parsers.Parser<DataSet> legacyDataSetParser = XmlLegacy.dataSetParser();

    public XmlProvider() {
        super(LOGGER, SOURCE, TsAsyncMode.Once);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet toDataSet(TsMoniker moniker) throws IllegalArgumentException {
        DataSet result = super.toDataSet(moniker);
        if (result != null) {
            return result;
        }
        Parsers.Parser<DataSet> parser = this.legacyDataSetParser;
        synchronized (parser) {
            return (DataSet)this.legacyDataSetParser.parse((CharSequence)moniker.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource toDataSource(TsMoniker moniker) throws IllegalArgumentException {
        DataSource result = super.toDataSource(moniker);
        if (result != null) {
            return result;
        }
        Parsers.Parser<DataSource> parser = this.legacyDataSourceParser;
        synchronized (parser) {
            return (DataSource)this.legacyDataSourceParser.parse((CharSequence)moniker.getId());
        }
    }

    protected wsTsWorkspace loadFromBean(XmlBean bean) throws IOException {
        File file = this.getRealFile(bean.getFile());
        String content = Files.toString((File)file, (Charset)bean.getCharset()).replace("eu/tstoolkit:", "ec/tstoolkit.");
        return (wsTsWorkspace)Jaxb.Parser.of(wsTsWorkspace.class).parseChars((CharSequence)content);
    }

    public String getDisplayName() {
        return "Xml files";
    }

    public String getDisplayName(DataSet dataSet) {
        this.support.check(dataSet, new IConstraint[0]);
        wsTsWorkspace ws = (wsTsWorkspace)this.cache.getIfPresent((Object)dataSet.getDataSource());
        if (ws == null) {
            switch (dataSet.getKind()) {
                case COLLECTION: {
                    return ((Integer)Y_COLLECTIONINDEX.get((IConfig)dataSet)).toString();
                }
                case SERIES: {
                    return Y_COLLECTIONINDEX.get((IConfig)dataSet) + " - " + Z_SERIESINDEX.get((IConfig)dataSet);
                }
            }
        } else {
            wsTsCollection col = ws.tsclist[(Integer)Y_COLLECTIONINDEX.get((IConfig)dataSet)];
            switch (dataSet.getKind()) {
                case COLLECTION: {
                    return col.name;
                }
                case SERIES: {
                    return col.name + " - " + col.tslist[((Integer)XmlProvider.Z_SERIESINDEX.get((IConfig)dataSet)).intValue()].name;
                }
            }
        }
        return "";
    }

    public List<DataSet> children(DataSource dataSource) throws IOException {
        this.support.check(dataSource, new IConstraint[0]);
        wsTsWorkspace ws = this.getSource(dataSource);
        if (ws == null || ws.tsclist.length == 0) {
            return Collections.emptyList();
        }
        DataSet[] children = new DataSet[ws.tsclist.length];
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.COLLECTION);
        for (int i = 0; i < children.length; ++i) {
            children[i] = ((DataSet.Builder)builder.put(Y_COLLECTIONINDEX, (Object)i)).build();
        }
        return Arrays.asList(children);
    }

    public String getDisplayNodeName(DataSet dataSet) {
        this.support.check(dataSet, new IConstraint[0]);
        wsTsWorkspace ws = (wsTsWorkspace)this.cache.getIfPresent((Object)dataSet.getDataSource());
        if (ws == null) {
            switch (dataSet.getKind()) {
                case COLLECTION: {
                    return ((Integer)Y_COLLECTIONINDEX.get((IConfig)dataSet)).toString();
                }
                case SERIES: {
                    return ((Integer)Z_SERIESINDEX.get((IConfig)dataSet)).toString();
                }
            }
        } else {
            wsTsCollection col = ws.tsclist[(Integer)Y_COLLECTIONINDEX.get((IConfig)dataSet)];
            switch (dataSet.getKind()) {
                case COLLECTION: {
                    return col.name;
                }
                case SERIES: {
                    return col.tslist[((Integer)XmlProvider.Z_SERIESINDEX.get((IConfig)dataSet)).intValue()].name;
                }
            }
        }
        return "";
    }

    public List<DataSet> children(DataSet parent) throws IOException {
        this.support.check(parent, new IConstraint[]{DataSet.Kind.COLLECTION});
        wsTsWorkspace ws = this.getSource(parent.getDataSource());
        int index = (Integer)Y_COLLECTIONINDEX.get((IConfig)parent);
        if (ws == null || index >= ws.tsclist.length || ws.tsclist[index].tslist.length == 0) {
            return Collections.emptyList();
        }
        DataSet[] children = new DataSet[ws.tsclist[index].tslist.length];
        DataSet.Builder builder = parent.toBuilder(DataSet.Kind.SERIES);
        for (int i = 0; i < children.length; ++i) {
            children[i] = ((DataSet.Builder)builder.put(Z_SERIESINDEX, (Object)i)).build();
        }
        return Arrays.asList(children);
    }

    protected void fillCollection(TsCollectionInformation info, DataSource dataSource) throws IOException {
        wsTsWorkspace source = this.getSource(dataSource);
        if (source == null) {
            throw new IOException("null");
        }
        info.type = TsInformationType.All;
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.COLLECTION);
        for (int i = 0; i < source.tsclist.length; ++i) {
            DataSet child = ((DataSet.Builder)builder.put(Y_COLLECTIONINDEX, (Object)i)).build();
            info.items.addAll(this.getAll(child, source.tsclist[i]));
        }
    }

    protected void fillCollection(TsCollectionInformation info, DataSet dataSet) throws IOException {
        wsTsCollection collection = this.getCollection(dataSet);
        if (collection == null) {
            throw new IOException("null");
        }
        info.name = collection.name;
        info.type = TsInformationType.All;
        info.items.addAll(this.getAll(dataSet, collection));
    }

    protected void fillSeries(TsInformation info, DataSet dataSet) throws IOException {
        wsTs series = this.getSeries(dataSet);
        if (series == null) {
            throw new IOException("null");
        }
        info.data = series.tsdata.create();
        info.name = this.getDisplayName(dataSet);
        info.type = TsInformationType.All;
    }

    List<TsInformation> getAll(DataSet dataSet, wsTsCollection collection) {
        if (collection.tslist == null || collection.tslist.length == 0) {
            return Collections.emptyList();
        }
        TsInformation[] result = new TsInformation[collection.tslist.length];
        DataSet.Builder builder = dataSet.toBuilder(DataSet.Kind.SERIES);
        for (int i = 0; i < result.length; ++i) {
            wsTs s = collection.tslist[i];
            DataSet child = ((DataSet.Builder)builder.put(Z_SERIESINDEX, (Object)i)).build();
            OptionalTsData data = s.tsdata != null ? OptionalTsData.present((TsData)s.tsdata.create()) : OptionalTsData.absent((String)"No data");
            result[i] = this.support.fillSeries(this.newTsInformation(child, TsInformationType.All), data, true);
        }
        return Arrays.asList(result);
    }

    private wsTsWorkspace getSource(DataSource dataSource) throws IOException {
        return (wsTsWorkspace)this.support.getValue(this.cache, dataSource);
    }

    private wsTsCollection getCollection(DataSet dataSet) throws IOException {
        return this.search(this.getSource(dataSet.getDataSource()), (Integer)Y_COLLECTIONINDEX.get((IConfig)dataSet));
    }

    private wsTs getSeries(DataSet dataSet) throws IOException {
        return this.search(this.getSource(dataSet.getDataSource()), (Integer)Y_COLLECTIONINDEX.get((IConfig)dataSet), (Integer)Z_SERIESINDEX.get((IConfig)dataSet));
    }

    private wsTsCollection search(wsTsWorkspace ws, int coll) {
        if (ws == null || ws.tsclist == null || coll >= ws.tsclist.length) {
            return null;
        }
        return ws.tsclist[coll];
    }

    private wsTs search(wsTsWorkspace ws, int coll, int pos) {
        if (ws == null || ws.tsclist == null || coll >= ws.tsclist.length) {
            return null;
        }
        wsTsCollection cur = ws.tsclist[coll];
        if (cur.tslist != null && pos < cur.tslist.length) {
            return cur.tslist[pos];
        }
        return null;
    }

    public XmlBean newBean() {
        return new XmlBean();
    }

    public DataSource encodeBean(Object bean) throws IllegalArgumentException {
        try {
            return ((XmlBean)bean).toDataSource(SOURCE, VERSION);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public XmlBean decodeBean(DataSource dataSource) {
        return new XmlBean(this.support.check(dataSource, new IConstraint[0]));
    }

    public boolean accept(File pathname) {
        return pathname.getPath().toLowerCase(Locale.ENGLISH).endsWith(".xml");
    }

    public String getFileDescription() {
        return "Xml file";
    }
}

