/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.db;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import ec.tss.tsproviders.db.DbBean;
import ec.tss.tsproviders.db.DbSeries;
import ec.tss.tsproviders.db.DbSetId;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tss.tsproviders.utils.IParser;
import ec.tss.tsproviders.utils.Parsers;
import ec.tss.tsproviders.utils.StrangeParsers;
import ec.tstoolkit.utilities.GuavaCaches;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class DbAccessor<BEAN extends DbBean> {
    protected @NonNull DbSetId check(@NonNull DbSetId ref, @NonNull IConstraint<DbSetId> constraint) throws IllegalArgumentException {
        String msg = constraint.check((Object)ref);
        Preconditions.checkArgument((msg == null ? 1 : 0) != 0, (Object)msg);
        return ref;
    }

    public abstract @NonNull BEAN getDbBean();

    public abstract @NonNull DbSetId getRoot();

    public @Nullable Exception testDbBean() {
        BEAN dbBean = this.getDbBean();
        if (Strings.isNullOrEmpty((String)((DbBean)dbBean).getDbName())) {
            return new Exception("Missing db name");
        }
        if (Strings.isNullOrEmpty((String)((DbBean)dbBean).getTableName())) {
            return new Exception("Missing table name");
        }
        if (Strings.isNullOrEmpty((String)((DbBean)dbBean).getPeriodColumn())) {
            return new Exception("Missing period column");
        }
        if (Strings.isNullOrEmpty((String)((DbBean)dbBean).getValueColumn())) {
            return new Exception("Missing value column");
        }
        return null;
    }

    public final @NonNull List<DbSetId> getAllSeries(String ... dimValues) throws Exception {
        return this.getAllSeries(this.check(this.getRoot().child(dimValues), DbSetId.COLLECTION_CONSTRAINT));
    }

    protected abstract @NonNull List<DbSetId> getAllSeries(@NonNull DbSetId var1) throws Exception;

    public final @NonNull List<DbSeries> getAllSeriesWithData(String ... dimValues) throws Exception {
        return this.getAllSeriesWithData(this.check(this.getRoot().child(dimValues), DbSetId.COLLECTION_CONSTRAINT));
    }

    protected abstract @NonNull List<DbSeries> getAllSeriesWithData(@NonNull DbSetId var1) throws Exception;

    public final @NonNull DbSeries getSeriesWithData(String ... dimValues) throws Exception {
        return this.getSeriesWithData(this.check(this.getRoot().child(dimValues), DbSetId.SERIES_CONSTRAINT));
    }

    protected abstract @NonNull DbSeries getSeriesWithData(@NonNull DbSetId var1) throws Exception;

    public final @NonNull List<String> getChildren(String ... dimValues) throws Exception {
        return this.getChildren(this.check(this.getRoot().child(dimValues), DbSetId.COLLECTION_CONSTRAINT));
    }

    protected abstract @NonNull List<String> getChildren(@NonNull DbSetId var1) throws Exception;

    public abstract @NonNull DbAccessor<BEAN> memoize();

    public static abstract class BulkAccessor<BEAN extends DbBean>
    extends Forwarding<BEAN> {
        protected final Cache<DbSetId, List<DbSeries>> cache;
        protected final int cacheLevel;
        protected final int depth;

        public static <X extends DbBean> @NonNull BulkAccessor<X> from(final @NonNull DbAccessor<X> delegate, int depth, @NonNull Cache<DbSetId, List<DbSeries>> cache) {
            return new BulkAccessor(depth, cache){

                @Override
                protected DbAccessor<X> getDelegate() {
                    return delegate;
                }

                @Override
                public DbAccessor memoize() {
                    return this;
                }
            };
        }

        @Deprecated
        public static @NonNull Cache<DbSetId, List<DbSeries>> newTtlCache(long ttlInMillis) {
            return GuavaCaches.ttlCache((Duration)Duration.ofMillis(ttlInMillis));
        }

        public BulkAccessor(int depth, @NonNull Cache<DbSetId, List<DbSeries>> cache) {
            this.cacheLevel = Math.max(0, this.getRoot().getMaxLevel() - depth);
            this.cache = cache;
            this.depth = depth;
        }

        protected boolean isCacheEnabled() {
            return this.depth > 0;
        }

        protected @NonNull Optional<DbSetId> getAncestorForCache(@NonNull DbSetId ref) {
            if (this.cacheLevel < ref.getLevel()) {
                String[] tmp = new String[this.cacheLevel];
                for (int i = 0; i < tmp.length; ++i) {
                    tmp[i] = ref.getValue(i);
                }
                return Optional.of((Object)this.getRoot().child(tmp));
            }
            return Optional.absent();
        }

        @Override
        protected List<DbSeries> getAllSeriesWithData(DbSetId ref) throws Exception {
            if (this.isCacheEnabled() && !ref.isSeries()) {
                if (ref.getLevel() == this.cacheLevel) {
                    List<DbSeries> value = (List<DbSeries>)this.cache.getIfPresent((Object)ref);
                    if (value == null) {
                        value = this.getDelegate().getAllSeriesWithData(ref);
                        this.cache.put((Object)ref, value);
                    }
                    return value;
                }
                Optional<DbSetId> ancestor = this.getAncestorForCache(ref);
                if (ancestor.isPresent()) {
                    return DbSeries.filterByAncestor(this.getAllSeriesWithData((DbSetId)ancestor.get()), ref);
                }
            }
            return this.getDelegate().getAllSeriesWithData(ref);
        }

        @Override
        protected DbSeries getSeriesWithData(DbSetId ref) throws Exception {
            Optional<DbSetId> ancestor;
            if (this.isCacheEnabled() && ref.isSeries() && (ancestor = this.getAncestorForCache(ref)).isPresent()) {
                return DbSeries.findById(this.getAllSeriesWithData((DbSetId)ancestor.get()), ref);
            }
            return this.getDelegate().getSeriesWithData(ref);
        }
    }

    public static abstract class Forwarding<BEAN extends DbBean>
    extends DbAccessor<BEAN> {
        protected abstract DbAccessor<BEAN> getDelegate();

        @Override
        public BEAN getDbBean() {
            return this.getDelegate().getDbBean();
        }

        @Override
        public DbSetId getRoot() {
            return this.getDelegate().getRoot();
        }

        @Override
        public Exception testDbBean() {
            return this.getDelegate().testDbBean();
        }

        @Override
        protected List<DbSetId> getAllSeries(DbSetId ref) throws Exception {
            return this.getDelegate().getAllSeries(ref);
        }

        @Override
        protected List<DbSeries> getAllSeriesWithData(DbSetId ref) throws Exception {
            return this.getDelegate().getAllSeriesWithData(ref);
        }

        @Override
        protected DbSeries getSeriesWithData(DbSetId ref) throws Exception {
            return this.getDelegate().getSeriesWithData(ref);
        }

        @Override
        protected List<String> getChildren(DbSetId ref) throws Exception {
            return this.getDelegate().getChildren(ref);
        }
    }

    public static abstract class Commander<BEAN extends DbBean>
    extends Abstract<BEAN> {
        public Commander(@NonNull BEAN dbBean) {
            super(dbBean);
        }

        @Override
        protected List<DbSetId> getAllSeries(DbSetId ref) throws Exception {
            return this.getAllSeriesQuery(ref).call();
        }

        protected abstract @NonNull Callable<List<DbSetId>> getAllSeriesQuery(@NonNull DbSetId var1);

        @Override
        protected List<DbSeries> getAllSeriesWithData(DbSetId ref) throws Exception {
            return this.getAllSeriesWithDataQuery(ref).call();
        }

        protected abstract @NonNull Callable<List<DbSeries>> getAllSeriesWithDataQuery(@NonNull DbSetId var1);

        @Override
        protected DbSeries getSeriesWithData(DbSetId ref) throws Exception {
            return this.getSeriesWithDataQuery(ref).call();
        }

        protected abstract @NonNull Callable<DbSeries> getSeriesWithDataQuery(@NonNull DbSetId var1);

        @Override
        protected List<String> getChildren(DbSetId ref) throws Exception {
            return this.getChildrenQuery(ref).call();
        }

        protected abstract @NonNull Callable<List<String>> getChildrenQuery(@NonNull DbSetId var1);
    }

    public static abstract class Abstract<BEAN extends DbBean>
    extends DbAccessor<BEAN> {
        protected final BEAN dbBean;
        protected final Parsers.Parser<Date> dateParser;
        protected final Parsers.Parser<Number> numberParser;
        protected final DbSetId root;

        public Abstract(@NonNull BEAN dbBean) {
            this.dbBean = dbBean;
            this.dateParser = ((DbBean)dbBean).getDataFormat().dateParser().or(new IParser[]{StrangeParsers.yearFreqPosParser()});
            this.numberParser = ((DbBean)dbBean).getDataFormat().numberParser();
            this.root = DbSetId.root(((DbBean)dbBean).getDimArray());
        }

        @Override
        public BEAN getDbBean() {
            return this.dbBean;
        }

        @Override
        public DbSetId getRoot() {
            return this.root;
        }
    }
}

