/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.db;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IDataSourceBean;
import ec.tss.tsproviders.utils.DataFormat;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.Params;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DbBean
implements IDataSourceBean {
    public static final IParam<DataSource, String> X_DBNAME = Params.onString((String)"", (String)"dbName");
    public static final IParam<DataSource, String> X_TABLENAME = Params.onString((String)"", (String)"tableName");
    public static final IParam<DataSource, String> X_DIMCOLUMNS = Params.onString((String)"", (String)"dimColumns");
    public static final IParam<DataSource, String> X_PERIODCOLUMN = Params.onString((String)"", (String)"periodColumn");
    public static final IParam<DataSource, String> X_VALUECOLUMN = Params.onString((String)"", (String)"valueColumn");
    public static final IParam<DataSource, DataFormat> X_DATAFORMAT = Params.onDataFormat((DataFormat)DataFormat.DEFAULT, (String)"locale", (String)"datePattern", (String)"numberPattern");
    public static final IParam<DataSource, String> X_VERSIONCOLUMN = Params.onString((String)"", (String)"versionColumn");
    public static final IParam<DataSource, TsFrequency> X_FREQUENCY = Params.onEnum((Enum)TsFrequency.Undefined, (String)"frequency");
    public static final IParam<DataSource, TsAggregationType> X_AGGREGATION_TYPE = Params.onEnum((Enum)TsAggregationType.None, (String)"aggregationType");
    protected String dbName;
    protected String tableName;
    protected String dimColumns;
    protected String periodColumn;
    protected String valueColumn;
    protected DataFormat dataFormat;
    protected String versionColumn;
    protected TsFrequency frequency;
    protected TsAggregationType aggregationType;
    static final Splitter DIM_ARRAY_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();

    public DbBean() {
        this.dbName = (String)X_DBNAME.defaultValue();
        this.tableName = (String)X_TABLENAME.defaultValue();
        this.dimColumns = (String)X_DIMCOLUMNS.defaultValue();
        this.periodColumn = (String)X_PERIODCOLUMN.defaultValue();
        this.valueColumn = (String)X_VALUECOLUMN.defaultValue();
        this.dataFormat = (DataFormat)X_DATAFORMAT.defaultValue();
        this.versionColumn = (String)X_VERSIONCOLUMN.defaultValue();
        this.frequency = (TsFrequency)X_FREQUENCY.defaultValue();
        this.aggregationType = (TsAggregationType)X_AGGREGATION_TYPE.defaultValue();
    }

    public DbBean(@NonNull DataSource id) {
        this.dbName = (String)X_DBNAME.get((IConfig)id);
        this.tableName = (String)X_TABLENAME.get((IConfig)id);
        this.dimColumns = (String)X_DIMCOLUMNS.get((IConfig)id);
        this.periodColumn = (String)X_PERIODCOLUMN.get((IConfig)id);
        this.valueColumn = (String)X_VALUECOLUMN.get((IConfig)id);
        this.dataFormat = (DataFormat)X_DATAFORMAT.get((IConfig)id);
        this.versionColumn = (String)X_VERSIONCOLUMN.get((IConfig)id);
        this.frequency = (TsFrequency)X_FREQUENCY.get((IConfig)id);
        this.aggregationType = (TsAggregationType)X_AGGREGATION_TYPE.get((IConfig)id);
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDimColumns() {
        return this.dimColumns;
    }

    public void setDimColumns(String dimColumns) {
        this.dimColumns = dimColumns;
    }

    public String getPeriodColumn() {
        return this.periodColumn;
    }

    public void setPeriodColumn(String periodColumn) {
        this.periodColumn = periodColumn;
    }

    public String getValueColumn() {
        return this.valueColumn;
    }

    public void setValueColumn(String valueColumn) {
        this.valueColumn = valueColumn;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getVersionColumn() {
        return this.versionColumn;
    }

    public void setVersionColumn(String versionColumn) {
        this.versionColumn = versionColumn;
    }

    public TsFrequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(TsFrequency frequency) {
        this.frequency = frequency;
        if (frequency == TsFrequency.Undefined) {
            this.aggregationType = TsAggregationType.None;
        }
    }

    public TsAggregationType getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(TsAggregationType aggregationType) {
        if (this.frequency != TsFrequency.Undefined) {
            this.aggregationType = aggregationType;
        }
    }

    public DataSource toDataSource(String providerName, String version) {
        DataSource.Builder builder = DataSource.builder((String)providerName, (String)version);
        X_DBNAME.set((IConfig.Builder)builder, (Object)this.dbName);
        X_TABLENAME.set((IConfig.Builder)builder, (Object)this.tableName);
        X_DIMCOLUMNS.set((IConfig.Builder)builder, (Object)this.dimColumns);
        X_PERIODCOLUMN.set((IConfig.Builder)builder, (Object)this.periodColumn);
        X_VALUECOLUMN.set((IConfig.Builder)builder, (Object)this.valueColumn);
        X_DATAFORMAT.set((IConfig.Builder)builder, (Object)this.dataFormat);
        X_VERSIONCOLUMN.set((IConfig.Builder)builder, (Object)this.versionColumn);
        X_FREQUENCY.set((IConfig.Builder)builder, (Object)this.frequency);
        X_AGGREGATION_TYPE.set((IConfig.Builder)builder, (Object)this.aggregationType);
        return builder.build();
    }

    public @NonNull String[] getDimArray() {
        return DbBean.getDimArray(this.dimColumns);
    }

    static String[] getDimArray(String dimColumns) {
        return (String[])Iterables.toArray((Iterable)DIM_ARRAY_SPLITTER.split((CharSequence)dimColumns), String.class);
    }

    public static @NonNull String[] getDimArray(@NonNull DataSource dataSource) {
        return DbBean.getDimArray((String)X_DIMCOLUMNS.get((IConfig)dataSource));
    }

    public static class BulkBean
    extends DbBean {
        public static final IParam<DataSource, Long> X_CACHE_TTL = Params.onLong((Long)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES), (String)"cacheTtl");
        public static final IParam<DataSource, Integer> X_CACHE_DEPTH = Params.onInteger((Integer)1, (String)"cacheDepth");
        protected long cacheTtl;
        protected int cacheDepth;

        public BulkBean() {
            this.cacheTtl = (Long)X_CACHE_TTL.defaultValue();
            this.cacheDepth = (Integer)X_CACHE_DEPTH.defaultValue();
        }

        public BulkBean(@NonNull DataSource id) {
            super(id);
            this.cacheTtl = (Long)X_CACHE_TTL.get((IConfig)id);
            this.cacheDepth = (Integer)X_CACHE_DEPTH.get((IConfig)id);
        }

        public long getCacheTtl() {
            return this.cacheTtl;
        }

        public void setCacheTtl(long cacheTtl) {
            this.cacheTtl = cacheTtl >= 0L ? cacheTtl : 0L;
        }

        public int getCacheDepth() {
            return this.cacheDepth;
        }

        public void setCacheDepth(int cacheDepth) {
            this.cacheDepth = cacheDepth >= 0 ? cacheDepth : 0;
        }

        @Override
        public DataSource toDataSource(String providerName, String version) {
            DataSource.Builder builder = DataSource.builder((String)providerName, (String)version);
            X_DBNAME.set((IConfig.Builder)builder, (Object)this.dbName);
            X_TABLENAME.set((IConfig.Builder)builder, (Object)this.tableName);
            X_DIMCOLUMNS.set((IConfig.Builder)builder, (Object)this.dimColumns);
            X_PERIODCOLUMN.set((IConfig.Builder)builder, (Object)this.periodColumn);
            X_VALUECOLUMN.set((IConfig.Builder)builder, (Object)this.valueColumn);
            X_DATAFORMAT.set((IConfig.Builder)builder, (Object)this.dataFormat);
            X_VERSIONCOLUMN.set((IConfig.Builder)builder, (Object)this.versionColumn);
            X_FREQUENCY.set((IConfig.Builder)builder, (Object)this.frequency);
            X_AGGREGATION_TYPE.set((IConfig.Builder)builder, (Object)this.aggregationType);
            X_CACHE_TTL.set((IConfig.Builder)builder, (Object)this.cacheTtl);
            X_CACHE_DEPTH.set((IConfig.Builder)builder, (Object)this.cacheDepth);
            return builder.build();
        }
    }
}

