/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.db;

import com.google.common.base.Joiner;
import ec.tss.TsAsyncMode;
import ec.tss.TsCollectionInformation;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.db.DbAccessor;
import ec.tss.tsproviders.db.DbBean;
import ec.tss.tsproviders.db.DbSeries;
import ec.tss.tsproviders.db.DbSetId;
import ec.tss.tsproviders.utils.AbstractDataSourceLoader;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.utilities.Arrays2;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public abstract class DbProvider<BEAN extends DbBean>
extends AbstractDataSourceLoader<DbAccessor<BEAN>, BEAN> {
    private static final IParam<DataSet, Dims> DIM_MAP = new DimsParam();

    public DbProvider(Logger logger, String providerName, TsAsyncMode asyncMode) {
        super(logger, providerName, asyncMode);
    }

    public String getDisplayName(DataSource dataSource) {
        DbBean bean = (DbBean)this.decodeBean(dataSource);
        String options = TsFrequency.Undefined == bean.getFrequency() ? "" : OptionalTsData.Builder.toString((TsFrequency)bean.getFrequency(), (TsAggregationType)bean.getAggregationType());
        return String.format("%s ~ %s \u00bb %s %s", bean.getDbName(), bean.getTableName(), bean.getValueColumn(), options);
    }

    public String getDisplayName(DataSet dataSet) {
        this.support.check(dataSet, new IConstraint[0]);
        Dims dims = (Dims)DIM_MAP.get((IConfig)dataSet);
        return dims.dimValues.length > 0 ? Joiner.on((String)", ").join((Object[])dims.dimValues) : "All";
    }

    public String getDisplayNodeName(DataSet dataSet) {
        this.support.check(dataSet, new IConstraint[0]);
        Dims dims = (Dims)DIM_MAP.get((IConfig)dataSet);
        return dims.dimValues.length > 0 ? dims.dimValues[dims.dimValues.length - 1] : "All";
    }

    public String getDisplayName(IOException ex) throws IllegalArgumentException {
        return ex instanceof ChildrenException ? ex.getCause().getMessage() : super.getDisplayName(ex);
    }

    public List<DataSet> children(DataSource dataSource) throws IOException {
        this.support.check(dataSource, new IConstraint[0]);
        DbAccessor<BEAN> accessor = this.getAccessor(dataSource);
        Dims dims = new Dims(DbBean.getDimArray(dataSource));
        DataSet fake = DataSet.of((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES);
        if (dims.dimColumns.length == 0) {
            Exception ex = accessor.testDbBean();
            if (ex != null) {
                throw new ChildrenException("Cannot list DataSource children", ex);
            }
            return Collections.singletonList(fake);
        }
        try {
            return this.children(fake, dims, accessor.getChildren(dims.dimValues));
        }
        catch (Exception ex) {
            throw new ChildrenException("Cannot list DataSource children", ex);
        }
    }

    public List<DataSet> children(DataSet parent) throws IOException {
        this.support.check(parent, new IConstraint[]{DataSet.Kind.COLLECTION});
        DbAccessor<BEAN> accessor = this.getAccessor(parent.getDataSource());
        Dims dims = (Dims)DIM_MAP.get((IConfig)parent);
        try {
            return this.children(parent, dims, accessor.getChildren(dims.dimValues));
        }
        catch (Exception ex) {
            throw new ChildrenException("Cannot list DataSet children", ex);
        }
    }

    private @NonNull List<DataSet> children(@NonNull DataSet parent, @NonNull Dims dims, @NonNull List<String> values) {
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        DataSet[] children = new DataSet[values.size()];
        DataSet.Builder builder = parent.toBuilder(dims.hasGrandChildren() ? DataSet.Kind.COLLECTION : DataSet.Kind.SERIES);
        String childDimColumn = dims.childDimColumn();
        for (int i = 0; i < children.length; ++i) {
            builder.put(childDimColumn, values.get(i));
            children[i] = builder.build();
        }
        return Arrays.asList(children);
    }

    protected void fillCollection(TsCollectionInformation info, DataSource dataSource) throws IOException {
        DbAccessor<BEAN> acc = this.getAccessor(dataSource);
        try {
            if (info.type.intValue() >= TsInformationType.Data.intValue()) {
                info.type = TsInformationType.All;
                info.items.addAll(this.getAllWithData(dataSource, acc.getAllSeriesWithData(new String[0])));
            } else {
                info.items.addAll(this.getAll(dataSource, acc.getAllSeries(new String[0]), info.type));
            }
        }
        catch (Exception ex) {
            throw new IOException("Cannot retrieve DataSource data", ex);
        }
    }

    protected void fillCollection(TsCollectionInformation info, DataSet dataSet) throws IOException {
        DbAccessor<BEAN> acc = this.getAccessor(dataSet.getDataSource());
        Dims dims = (Dims)DIM_MAP.get((IConfig)dataSet);
        try {
            if (info.type.intValue() >= TsInformationType.Data.intValue()) {
                info.type = TsInformationType.All;
                info.items.addAll(this.getAllWithData(dataSet.getDataSource(), acc.getAllSeriesWithData(dims.dimValues)));
            } else {
                info.items.addAll(this.getAll(dataSet.getDataSource(), acc.getAllSeries(dims.dimValues), info.type));
            }
        }
        catch (Exception ex) {
            throw new IOException("Cannot retrieve DataSet data", ex);
        }
    }

    protected void fillSeries(TsInformation info, DataSet dataSet) throws IOException {
        if (info.type.intValue() >= TsInformationType.Data.intValue()) {
            DbAccessor<BEAN> acc = this.getAccessor(dataSet.getDataSource());
            Dims dims = (Dims)DIM_MAP.get((IConfig)dataSet);
            info.name = this.getDisplayName(dataSet);
            info.type = TsInformationType.All;
            try {
                this.support.fillSeries(info, acc.getSeriesWithData(dims.dimValues).getData(), true);
            }
            catch (Exception ex) {
                throw new IOException("Cannot retrieve DataSet data", ex);
            }
        }
    }

    private @NonNull List<TsInformation> getAll(@NonNull DataSource dataSource, @NonNull List<DbSetId> list, @NonNull TsInformationType type) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        TsInformation[] result = new TsInformation[list.size()];
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES);
        for (int j = 0; j < result.length; ++j) {
            DbSetId o = list.get(j);
            for (int i = 0; i < o.getLevel(); ++i) {
                builder.put(o.getColumn(i), o.getValue(i));
            }
            result[j] = this.newTsInformation(builder.build(), type);
        }
        return Arrays.asList(result);
    }

    private @NonNull List<TsInformation> getAllWithData(@NonNull DataSource dataSource, @NonNull List<DbSeries> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        TsInformation[] result = new TsInformation[list.size()];
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES);
        for (int j = 0; j < result.length; ++j) {
            DbSeries o = list.get(j);
            for (int i = 0; i < o.getId().getLevel(); ++i) {
                builder.put(o.getId().getColumn(i), o.getId().getValue(i));
            }
            result[j] = this.support.fillSeries(this.newTsInformation(builder.build(), TsInformationType.All), o.getData(), true);
            builder.clear();
        }
        return Arrays.asList(result);
    }

    private @NonNull DbAccessor<BEAN> getAccessor(@NonNull DataSource dataSource) throws IOException {
        return (DbAccessor)this.support.getValue(this.cache, dataSource);
    }

    private static final class Dims {
        final String[] dimColumns;
        final String[] dimValues;

        public Dims(@NonNull String[] dimColumns) {
            this(dimColumns, Arrays2.EMPTY_STRING_ARRAY);
        }

        public Dims(@NonNull String[] dimColumns, @NonNull String[] dimValues) {
            this.dimColumns = dimColumns;
            this.dimValues = dimValues;
        }

        boolean hasGrandChildren() {
            return this.dimValues.length < this.dimColumns.length - 1;
        }

        String childDimColumn() {
            return this.dimColumns[this.dimValues.length];
        }
    }

    private static final class ChildrenException
    extends IOException {
        public ChildrenException(@NonNull String message, @NonNull Throwable cause) {
            super(message, cause);
        }
    }

    private static final class DimsParam
    implements IParam<DataSet, Dims> {
        private DimsParam() {
        }

        public Dims defaultValue() {
            return new Dims(Arrays2.EMPTY_STRING_ARRAY, Arrays2.EMPTY_STRING_ARRAY);
        }

        public Dims get(DataSet dataSet) {
            int length;
            String[] dimColumns = DbBean.getDimArray(dataSet.getDataSource());
            for (length = dimColumns.length; length > 0 && dataSet.get(dimColumns[length - 1]) == null; --length) {
            }
            String[] dimValues = new String[length];
            for (int i = 0; i < length; ++i) {
                dimValues[i] = dataSet.get(dimColumns[i]);
            }
            return new Dims(dimColumns, dimValues);
        }

        public void set(IConfig.Builder<?, DataSet> builder, Dims value) {
            if (value != null) {
                for (int i = 0; i < value.dimValues.length; ++i) {
                    builder.put(value.dimColumns[i], value.dimValues[i]);
                }
            }
        }
    }
}

