/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.db;

import com.google.common.collect.Streams;
import ec.tss.tsproviders.db.DbSetId;
import ec.tss.tsproviders.utils.OptionalTsData;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DbSeries {
    private final DbSetId id;
    private final OptionalTsData data;

    public DbSeries(@NonNull DbSetId id, @NonNull OptionalTsData data) {
        this.id = id;
        this.data = data;
    }

    public @NonNull DbSetId getId() {
        return this.id;
    }

    public @NonNull OptionalTsData getData() {
        return this.data;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DbSeries && this.equals((DbSeries)obj);
    }

    private boolean equals(DbSeries that) {
        return this.id.equals((Object)that.id) && this.data.equals(that.data);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static @NonNull DbSeries findById(@NonNull Iterable<DbSeries> iterable, @NonNull DbSetId id) throws NoSuchElementException {
        return Streams.stream(iterable).filter(o -> o != null ? id.equals((Object)o.getId()) : false).findFirst().orElseThrow(NoSuchElementException::new);
    }

    public static @NonNull List<DbSeries> filterByAncestor(@NonNull Iterable<DbSeries> iterable, @NonNull DbSetId ancestor) {
        return Streams.stream(iterable).filter(o -> o != null ? DbSeries.isDescendant(ancestor, o.getId()) : false).collect(Collectors.toList());
    }

    private static boolean isDescendant(@NonNull DbSetId ancestor, @NonNull DbSetId o) {
        for (int i = ancestor.getLevel() - 1; i >= 0; --i) {
            if (o.getValue(i).equals(ancestor.getValue(i))) continue;
            return false;
        }
        return true;
    }
}

