/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.db;

import com.google.common.base.Optional;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tstoolkit.utilities.Arrays2;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DbSetId {
    private final String[] dimValues;
    private final String[] dimColumns;
    public static final IConstraint<DbSetId> SERIES_CONSTRAINT = new IConstraint<DbSetId>(){

        public String check(DbSetId t) {
            return t.isSeries() ? null : "Not a series";
        }
    };
    public static final IConstraint<DbSetId> COLLECTION_CONSTRAINT = new IConstraint<DbSetId>(){

        public String check(DbSetId t) {
            return !t.isSeries() ? null : "Not a collection";
        }
    };

    public static @NonNull DbSetId root(String ... dimColumns) throws IllegalArgumentException {
        for (String o : dimColumns) {
            if (o != null) continue;
            throw new IllegalArgumentException("Columns cannot be null");
        }
        return new DbSetId(Arrays2.EMPTY_STRING_ARRAY, (String[])dimColumns.clone());
    }

    private DbSetId(@NonNull String[] dimValues, @NonNull String[] dimColumns) {
        this.dimValues = dimValues;
        this.dimColumns = dimColumns;
    }

    public int getLevel() {
        return this.dimValues.length;
    }

    public @NonNull String getValue(int index) throws IndexOutOfBoundsException {
        return this.dimValues[index];
    }

    public int getMaxLevel() {
        return this.dimColumns.length;
    }

    public @NonNull String getColumn(int index) throws IndexOutOfBoundsException {
        return this.dimColumns[index];
    }

    public int getDepth() {
        return this.getMaxLevel() - this.getLevel();
    }

    public boolean isSeries() {
        return this.dimValues.length == this.dimColumns.length;
    }

    public @NonNull DbSetId child(String ... dimValues) throws IllegalArgumentException {
        if (this.dimValues.length + dimValues.length > this.dimColumns.length) {
            throw new IllegalArgumentException("Too much values");
        }
        for (String o : dimValues) {
            if (o != null) continue;
            throw new IllegalArgumentException("Values cannot be null");
        }
        return new DbSetId((String[])Arrays2.concat((Object[])this.dimValues, (Object[])dimValues), this.dimColumns);
    }

    public boolean isRoot() {
        return this.getLevel() == 0;
    }

    public @NonNull Optional<DbSetId> parent() {
        return this.isRoot() ? Optional.absent() : Optional.of((Object)new DbSetId(Arrays.copyOf(this.dimValues, this.getLevel() - 1), this.dimColumns));
    }

    public @NonNull String[] selectColumns() {
        String[] result = new String[this.getDepth()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getColumn(this.getLevel() + i);
        }
        return result;
    }

    public @NonNull String[] filterColumns() {
        String[] result = new String[this.getLevel()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getColumn(i);
        }
        return result;
    }

    public String toString() {
        return Arrays.toString(this.dimValues);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DbSetId && this.equals((DbSetId)obj);
    }

    private boolean equals(@NonNull DbSetId that) {
        return DbSetId.equalsReversed(this.dimValues, that.dimValues) && Arrays.equals(this.dimColumns, that.dimColumns);
    }

    private static boolean equalsReversed(@Nullable Object[] l, @Nullable Object[] r) {
        if (l == r) {
            return true;
        }
        if (l == null || r == null || l.length != r.length) {
            return false;
        }
        for (int i = l.length - 1; i >= 0; --i) {
            if (Objects.equals(l[i], r[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.dimColumns) + Arrays.deepHashCode(this.dimValues);
    }
}

