/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.db;

import com.google.common.collect.ImmutableList;
import ec.tss.tsproviders.db.DbSeries;
import ec.tss.tsproviders.db.DbSetId;
import ec.tss.tsproviders.utils.ObsCharacteristics;
import ec.tss.tsproviders.utils.ObsGathering;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DbUtil {
    private DbUtil() {
    }

    public static <T extends Exception> @NonNull List<DbSetId> getAllSeries(@NonNull AllSeriesCursor<T> cursor, @NonNull DbSetId ref) throws T {
        ImmutableList.Builder result = ImmutableList.builder();
        while (cursor.next()) {
            result.add((Object)ref.child(cursor.dimValues));
        }
        return result.build();
    }

    public static <T extends Exception> @NonNull List<DbSeries> getAllSeriesWithData(@NonNull AllSeriesWithDataCursor<T> cursor, @NonNull DbSetId ref, @NonNull TsFrequency frequency, @NonNull TsAggregationType aggregationType) throws T {
        ImmutableList.Builder result = ImmutableList.builder();
        ObsGathering gathering = ObsGathering.includingMissingValues((TsFrequency)frequency, (TsAggregationType)aggregationType);
        OptionalTsData.Builder2 data = OptionalTsData.builderByDate((Calendar)new GregorianCalendar(), (ObsGathering)gathering, (ObsCharacteristics[])new ObsCharacteristics[]{ObsCharacteristics.ORDERED});
        boolean t0 = cursor.next();
        while (t0) {
            Object[] dimValues = cursor.dimValues;
            boolean t1 = true;
            while (t1) {
                Date period = cursor.period;
                Number value = null;
                boolean t2 = true;
                while (t2) {
                    value = cursor.value;
                    t0 = cursor.next();
                    t1 = t0 && Arrays.equals(dimValues, cursor.dimValues);
                    t2 = t1 && Objects.equals(period, cursor.period);
                }
                data.add((Object)period, value);
            }
            result.add((Object)new DbSeries(ref.child((String[])dimValues), data.build()));
            data.clear();
        }
        return result.build();
    }

    public static <T extends Exception> @NonNull DbSeries getSeriesWithData(@NonNull SeriesWithDataCursor<T> cursor, @NonNull DbSetId ref, @NonNull TsFrequency frequency, @NonNull TsAggregationType aggregationType) throws T {
        ObsGathering gathering = ObsGathering.includingMissingValues((TsFrequency)frequency, (TsAggregationType)aggregationType);
        OptionalTsData.Builder2 data = OptionalTsData.builderByDate((Calendar)new GregorianCalendar(), (ObsGathering)gathering, (ObsCharacteristics[])new ObsCharacteristics[]{ObsCharacteristics.ORDERED});
        boolean t0 = cursor.next();
        if (t0) {
            Date latestPeriod = cursor.period;
            while (t0) {
                Date period = latestPeriod;
                Number value = null;
                boolean t1 = true;
                while (t1) {
                    value = cursor.value;
                    t0 = cursor.next();
                    t1 = t0 && Objects.equals(period, latestPeriod = cursor.period);
                }
                data.add((Object)period, value);
            }
        }
        return new DbSeries(ref, data.build());
    }

    public static <T extends Exception> @NonNull List<String> getChildren(@NonNull ChildrenCursor<T> cursor) throws T {
        ImmutableList.Builder result = ImmutableList.builder();
        while (cursor.next()) {
            result.add((Object)cursor.child);
        }
        return result.build();
    }

    public static abstract class AllSeriesCursor<T extends Exception>
    implements Cursor<T> {
        public String[] dimValues;
    }

    public static abstract class AllSeriesWithDataCursor<T extends Exception>
    implements Cursor<T> {
        public String[] dimValues;
        public Date period;
        public Number value;
    }

    public static abstract class SeriesWithDataCursor<T extends Exception>
    implements Cursor<T> {
        public Date period;
        public Number value;
    }

    public static abstract class ChildrenCursor<T extends Exception>
    implements Cursor<T> {
        public String child;
    }

    public static interface Cursor<EX extends Exception> {
        public boolean next() throws EX;
    }

    public static interface Func<X, Y, EX extends Exception> {
        public @Nullable Y apply(@NonNull X var1) throws EX;
    }
}

