/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.jdbc;

import com.google.common.base.Preconditions;
import ec.tss.tsproviders.jdbc.JdbcBean;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface ConnectionSupplier {
    public @NonNull Connection getConnection(@NonNull JdbcBean var1) throws SQLException;

    public static abstract class DataSourceBasedSupplier
    implements ConnectionSupplier {
        @Override
        public Connection getConnection(JdbcBean bean) throws SQLException {
            return this.getDataSource(bean).getConnection();
        }

        protected abstract @NonNull DataSource getDataSource(@NonNull JdbcBean var1) throws SQLException;
    }

    public static abstract class DriverBasedSupplier
    implements ConnectionSupplier {
        final boolean driverAvailable = this.loadDriver();

        @Override
        public Connection getConnection(JdbcBean bean) throws SQLException {
            Preconditions.checkState((boolean)this.driverAvailable, (Object)"Driver not available");
            return DriverManager.getConnection(this.getUrl(bean));
        }

        public boolean isDriverAvailable() {
            return this.driverAvailable;
        }

        protected abstract @NonNull String getUrl(@NonNull JdbcBean var1);

        protected abstract boolean loadDriver();
    }
}

