/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.jdbc;

import com.google.common.cache.Cache;
import ec.tss.tsproviders.db.DbAccessor;
import ec.tss.tsproviders.db.DbSeries;
import ec.tss.tsproviders.db.DbSetId;
import ec.tss.tsproviders.db.DbUtil;
import ec.tss.tsproviders.jdbc.ConnectionSupplier;
import ec.tss.tsproviders.jdbc.JdbcBean;
import ec.tss.tsproviders.jdbc.ResultSetFunc;
import ec.tss.tsproviders.jdbc.SelectBuilder;
import ec.tss.tsproviders.utils.IParser;
import ec.tstoolkit.utilities.GuavaCaches;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import nbbrd.sql.jdbc.SqlIdentifierQuoter;
import nbbrd.sql.jdbc.SqlTable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

public class JdbcAccessor<BEAN extends JdbcBean>
extends DbAccessor.Commander<BEAN> {
    protected final Logger logger;
    protected final ConnectionSupplier supplier;

    public JdbcAccessor(@NonNull Logger logger, @NonNull BEAN dbBean, @NonNull ConnectionSupplier supplier) {
        super(dbBean);
        this.logger = logger;
        this.supplier = supplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Exception testDbBean() {
        Exception result = super.testDbBean();
        if (result != null) {
            return result;
        }
        try (Connection conn = this.supplier.getConnection((JdbcBean)this.dbBean);){
            DatabaseMetaData metaData = conn.getMetaData();
            String tableName = SqlIdentifierQuoter.of((DatabaseMetaData)metaData).quote(((JdbcBean)this.dbBean).getTableName(), false);
            if (SqlTable.allOf((DatabaseMetaData)metaData, null, null, (String)tableName, null).isEmpty()) {
                Exception exception2 = new Exception("Table named '" + ((JdbcBean)this.dbBean).getTableName() + "' does not exist");
                return exception2;
            }
            Exception exception = null;
            return exception;
        }
        catch (SQLException ex) {
            return ex;
        }
    }

    protected @NonNull ResultSetFunc<String> getChildFunc(@NonNull ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return ResultSetFunc.onGetString(columnIndex);
    }

    protected @NonNull ResultSetFunc<String[]> getDimValuesFunc(@NonNull ResultSetMetaData metaData, int firstColumnIndex, int length) throws SQLException {
        return ResultSetFunc.onGetStringArray(firstColumnIndex, length);
    }

    protected @NonNull ResultSetFunc<Date> getPeriodFunc(@NonNull ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return ResultSetFunc.onDate(metaData, columnIndex, (IParser<Date>)this.dateParser);
    }

    protected @NonNull ResultSetFunc<Number> getValueFunc(@NonNull ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return ResultSetFunc.onNumber(metaData, columnIndex, (IParser<Number>)this.numberParser);
    }

    @Override
    protected Callable<List<DbSetId>> getAllSeriesQuery(DbSetId ref) {
        return new JdbcQuery<List<DbSetId>>(ref){

            @Override
            protected String getQueryString(DatabaseMetaData metaData) throws SQLException {
                return SelectBuilder.from(((JdbcBean)JdbcAccessor.this.getDbBean()).getTableName()).distinct(true).select(this.ref.selectColumns()).filter(this.ref.filterColumns()).orderBy(this.ref.selectColumns()).withQuoter(SqlIdentifierQuoter.of((DatabaseMetaData)metaData)).build();
            }

            @Override
            protected List<DbSetId> process(final ResultSet rs) throws SQLException {
                final ResultSetFunc<String[]> toDimValues = JdbcAccessor.this.getDimValuesFunc(rs.getMetaData(), 1, this.ref.getDepth());
                DbUtil.AllSeriesCursor<SQLException> cursor = new DbUtil.AllSeriesCursor<SQLException>(){

                    @Override
                    public boolean next() throws SQLException {
                        boolean result = rs.next();
                        if (result) {
                            this.dimValues = (String[])toDimValues.apply(rs);
                        }
                        return result;
                    }
                };
                return DbUtil.getAllSeries(cursor, this.ref);
            }
        };
    }

    @Override
    protected Callable<List<DbSeries>> getAllSeriesWithDataQuery(DbSetId ref) {
        return new JdbcQuery<List<DbSeries>>(ref){

            @Override
            protected String getQueryString(DatabaseMetaData metaData) throws SQLException {
                JdbcBean dbBean = (JdbcBean)JdbcAccessor.this.getDbBean();
                return SelectBuilder.from(dbBean.getTableName()).select(this.ref.selectColumns()).select(dbBean.getPeriodColumn(), dbBean.getValueColumn()).filter(this.ref.filterColumns()).orderBy(this.ref.selectColumns()).orderBy(dbBean.getPeriodColumn(), dbBean.getVersionColumn()).withQuoter(SqlIdentifierQuoter.of((DatabaseMetaData)metaData)).build();
            }

            @Override
            protected List<DbSeries> process(final ResultSet rs) throws SQLException {
                ResultSetMetaData metaData = rs.getMetaData();
                final ResultSetFunc<String[]> toDimValues = JdbcAccessor.this.getDimValuesFunc(metaData, 1, this.ref.getDepth());
                final ResultSetFunc<Date> toPeriod = JdbcAccessor.this.getPeriodFunc(metaData, this.ref.getDepth() + 1);
                final ResultSetFunc<Number> toValue = JdbcAccessor.this.getValueFunc(metaData, this.ref.getDepth() + 2);
                DbUtil.AllSeriesWithDataCursor<SQLException> cursor = new DbUtil.AllSeriesWithDataCursor<SQLException>(){

                    @Override
                    public boolean next() throws SQLException {
                        boolean result = rs.next();
                        if (result) {
                            this.dimValues = (String[])toDimValues.apply(rs);
                            this.period = (Date)toPeriod.apply(rs);
                            this.value = this.period != null ? (Number)((Number)toValue.apply(rs)) : (Number)null;
                        }
                        return result;
                    }
                };
                JdbcBean dbBean = (JdbcBean)JdbcAccessor.this.getDbBean();
                return DbUtil.getAllSeriesWithData(cursor, this.ref, dbBean.getFrequency(), dbBean.getAggregationType());
            }
        };
    }

    @Override
    protected Callable<DbSeries> getSeriesWithDataQuery(DbSetId ref) {
        return new JdbcQuery<DbSeries>(ref){

            @Override
            protected String getQueryString(DatabaseMetaData metaData) throws SQLException {
                JdbcBean dbBean = (JdbcBean)JdbcAccessor.this.getDbBean();
                return SelectBuilder.from(dbBean.getTableName()).select(dbBean.getPeriodColumn(), dbBean.getValueColumn()).filter(this.ref.filterColumns()).orderBy(dbBean.getPeriodColumn(), dbBean.getVersionColumn()).withQuoter(SqlIdentifierQuoter.of((DatabaseMetaData)metaData)).build();
            }

            @Override
            protected DbSeries process(final ResultSet rs) throws SQLException {
                ResultSetMetaData metaData = rs.getMetaData();
                final ResultSetFunc<Date> toPeriod = JdbcAccessor.this.getPeriodFunc(metaData, 1);
                final ResultSetFunc<Number> toValue = JdbcAccessor.this.getValueFunc(metaData, 2);
                DbUtil.SeriesWithDataCursor<SQLException> cursor = new DbUtil.SeriesWithDataCursor<SQLException>(){

                    @Override
                    public boolean next() throws SQLException {
                        boolean result = rs.next();
                        if (result) {
                            this.period = (Date)toPeriod.apply(rs);
                            this.value = this.period != null ? (Number)((Number)toValue.apply(rs)) : (Number)null;
                        }
                        return result;
                    }
                };
                JdbcBean dbBean = (JdbcBean)JdbcAccessor.this.getDbBean();
                return DbUtil.getSeriesWithData(cursor, this.ref, dbBean.getFrequency(), dbBean.getAggregationType());
            }
        };
    }

    @Override
    protected Callable<List<String>> getChildrenQuery(DbSetId ref) {
        return new JdbcQuery<List<String>>(ref){

            @Override
            protected String getQueryString(DatabaseMetaData metaData) throws SQLException {
                String column = this.ref.getColumn(this.ref.getLevel());
                return SelectBuilder.from(((JdbcBean)JdbcAccessor.this.getDbBean()).getTableName()).distinct(true).select(column).filter(this.ref.filterColumns()).orderBy(column).withQuoter(SqlIdentifierQuoter.of((DatabaseMetaData)metaData)).build();
            }

            @Override
            protected List<String> process(final ResultSet rs) throws SQLException {
                final ResultSetFunc<String> toChild = JdbcAccessor.this.getChildFunc(rs.getMetaData(), 1);
                DbUtil.ChildrenCursor<SQLException> cursor = new DbUtil.ChildrenCursor<SQLException>(){

                    @Override
                    public boolean next() throws SQLException {
                        boolean result = rs.next();
                        if (result) {
                            this.child = (String)toChild.apply(rs);
                        }
                        return result;
                    }
                };
                return DbUtil.getChildren(cursor);
            }
        };
    }

    @Override
    public DbAccessor<BEAN> memoize() {
        Duration duration = Duration.ofMillis(((JdbcBean)this.dbBean).getCacheTtl());
        return DbAccessor.BulkAccessor.from(this, ((JdbcBean)this.dbBean).getCacheDepth(), (Cache<DbSetId, List<DbSeries>>)GuavaCaches.ttlCache((Duration)duration));
    }

    protected abstract class JdbcQuery<T>
    implements Callable<T> {
        protected final DbSetId ref;

        protected JdbcQuery(DbSetId ref) {
            this.ref = ref;
        }

        protected @NonNull String getQueryString(DatabaseMetaData metaData) throws SQLException {
            return this.getQueryString();
        }

        @Deprecated
        protected @NonNull String getQueryString() {
            throw new RuntimeException("Deprecated");
        }

        protected void setParameters(@NonNull PreparedStatement statement) throws SQLException {
            for (int i = 0; i < this.ref.getLevel(); ++i) {
                statement.setString(i + 1, this.ref.getValue(i));
            }
        }

        protected abstract @Nullable T process(@NonNull ResultSet var1) throws SQLException;

        /*
         * Exception decompiling
         */
        @Override
        public T call() throws SQLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

