/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.jdbc;

import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.jdbc.JdbcBean;
import ec.tss.tsproviders.legacy.IStringHandler;
import ec.tss.tsproviders.legacy.LinearIdBuilder;
import ec.tss.tsproviders.legacy.StringHandlers;
import ec.tss.tsproviders.utils.IParser;
import ec.tss.tsproviders.utils.Parsers;

public final class JdbcLegacy {
    private JdbcLegacy() {
    }

    static Parsers.Parser<DataSource> dbParser(final String providerName, final String version) {
        return new Parsers.Parser<DataSource>(){

            public DataSource parse(CharSequence input) throws NullPointerException {
                DbDataSourceId id = DbDataSourceId.parse(input);
                if (id == null) {
                    return null;
                }
                JdbcBean dbBean = new JdbcBean(){};
                dbBean.setDbName(id.getDbName());
                dbBean.setTableName(id.getTableName());
                dbBean.setDimColumns(id.getDomainColumn() + "," + id.getTsColumn());
                dbBean.setPeriodColumn(id.getPeriodColumn());
                dbBean.setValueColumn(id.getValueColumn());
                return dbBean.toDataSource(providerName, version);
            }
        };
    }

    static Parsers.Parser<DataSet> domainSeriesParser(final IParser<DataSource> legacyDbParser) {
        return new Parsers.Parser<DataSet>(){

            public DataSet parse(CharSequence input) throws NullPointerException {
                DataSource dataSource;
                FromDatabaseId id = FromDatabaseId.parse(input.toString());
                if (id != null && id.getDomain() != null && (dataSource = (DataSource)legacyDbParser.parse((CharSequence)id.getDatabase())) != null) {
                    String[] dimColumns = JdbcBean.getDimArray(dataSource);
                    if (id.getSeries() != null) {
                        return ((DataSet.Builder)((DataSet.Builder)DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES).put(dimColumns[0], id.getDomain())).put(dimColumns[1], id.getSeries())).build();
                    }
                    return DataSet.of((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.COLLECTION, (String)dimColumns[0], (String)id.getDomain());
                }
                return null;
            }
        };
    }

    @Deprecated
    public static final class DbDataSourceId
    implements CharSequence {
        private static final IStringHandler SH = StringHandlers.PLAIN;
        private final LinearIdBuilder id;

        public static DbDataSourceId parse(CharSequence input) {
            return input instanceof DbDataSourceId ? (DbDataSourceId)input : DbDataSourceId.parse(input.toString());
        }

        public static DbDataSourceId parse(String input) {
            LinearIdBuilder id = LinearIdBuilder.parse((IStringHandler)SH, (String)input);
            if (id == null || id.getCount() < 6) {
                return null;
            }
            return new DbDataSourceId(id);
        }

        public static DbDataSourceId from(String dbName, String tableName, String domainCol, String tsCol, String periodCol, String valueCol) {
            return new DbDataSourceId(LinearIdBuilder.from((IStringHandler)SH, (String)dbName, (String[])new String[]{tableName, domainCol, tsCol, periodCol, valueCol}));
        }

        private DbDataSourceId(LinearIdBuilder id) {
            this.id = id;
        }

        @Override
        public String toString() {
            return this.id.toString();
        }

        public String getDbName() {
            return this.id.get(0);
        }

        public String getTableName() {
            return this.id.get(1);
        }

        public String getDomainColumn() {
            return this.id.get(2);
        }

        public String getTsColumn() {
            return this.id.get(3);
        }

        public String getPeriodColumn() {
            return this.id.get(4);
        }

        public String getValueColumn() {
            return this.id.get(5);
        }

        @Override
        public int length() {
            return this.id.toString().length();
        }

        @Override
        public char charAt(int index) {
            return this.id.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.id.toString().subSequence(start, end);
        }

        public int hashCode() {
            return this.getDbName().hashCode() + this.getTableName().hashCode() + this.getDomainColumn().hashCode() + this.getTsColumn().hashCode() + this.getPeriodColumn().hashCode() + this.getValueColumn().hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof DbDataSourceId && this.equals((DbDataSourceId)obj);
        }

        private boolean equals(DbDataSourceId other) {
            return this.getDbName().equals(other.getDbName()) && this.getTableName().equals(other.getTableName()) && this.getDomainColumn().equals(other.getDomainColumn()) && this.getTsColumn().equals(other.getTsColumn()) && this.getPeriodColumn().equals(other.getPeriodColumn()) && this.getValueColumn().equals(other.getValueColumn());
        }
    }

    @Deprecated
    static class FromDatabaseId {
        private DbDataSourceId m_sourceId;
        private String m_domain = null;
        private String m_series = null;

        public static FromDatabaseId parse(String input) {
            LinearIdBuilder idbuild = LinearIdBuilder.parse((IStringHandler)StringHandlers.PLAIN, (String)input);
            if (idbuild.getCount() >= 6) {
                DbDataSourceId sourceId = DbDataSourceId.from(idbuild.get(0), idbuild.get(1), idbuild.get(2), idbuild.get(3), idbuild.get(4), idbuild.get(5));
                String domain = null;
                if (idbuild.getCount() >= 7) {
                    domain = idbuild.get(6);
                }
                String series = null;
                if (idbuild.getCount() >= 8) {
                    series = idbuild.get(7);
                }
                return new FromDatabaseId(sourceId, domain, series);
            }
            return null;
        }

        public DbDataSourceId getDatabase() {
            return this.m_sourceId;
        }

        public String getDomain() {
            return this.m_domain;
        }

        public String getSeries() {
            return this.m_series;
        }

        private FromDatabaseId(DbDataSourceId sourceId, String domain, String series) {
            this.m_sourceId = sourceId;
            this.m_domain = domain;
            this.m_series = series;
        }

        public boolean isCollection() {
            return null == this.m_series && null != this.m_domain;
        }

        public boolean isMultiCollection() {
            return null == this.m_series && null == this.m_domain;
        }
    }
}

