/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.jdbc;

import ec.tss.TsAsyncMode;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.db.DbProvider;
import ec.tss.tsproviders.jdbc.JdbcBean;
import ec.tss.tsproviders.jdbc.JdbcLegacy;
import ec.tss.tsproviders.utils.Parsers;
import ec.tstoolkit.design.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public abstract class JdbcProvider<BEAN extends JdbcBean>
extends DbProvider<BEAN> {
    protected final String version;
    protected final Parsers.Parser<DataSource> legacyDataSourceParser;
    protected final Parsers.Parser<DataSet> legacyDataSetParser;

    protected JdbcProvider(@NonNull String source, @NonNull String version, @NonNull Logger logger, @NonNull TsAsyncMode asyncMode) {
        this(source, version, logger, asyncMode, JdbcLegacy.dbParser(source, version));
    }

    protected JdbcProvider(@NonNull String source, @NonNull String version, @NonNull Logger logger, @NonNull TsAsyncMode asyncMode, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parsers.Parser<DataSource> legacyDbParser) {
        this(source, version, logger, asyncMode, legacyDbParser, JdbcLegacy.domainSeriesParser(legacyDbParser));
    }

    @VisibleForTesting
    JdbcProvider(@NonNull String providerName, @NonNull String version, @NonNull Logger logger, @NonNull TsAsyncMode asyncMode, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parsers.Parser<DataSource> legacyDataSourceParser, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parsers.Parser<DataSet> legacyDataSetParser) {
        super(logger, providerName, asyncMode);
        this.version = version;
        this.legacyDataSourceParser = legacyDataSourceParser;
        this.legacyDataSetParser = legacyDataSetParser;
    }

    public DataSet toDataSet(TsMoniker moniker) {
        DataSet result = super.toDataSet(moniker);
        return result != null ? result : (DataSet)this.legacyDataSetParser.parse((CharSequence)moniker.getId());
    }

    public DataSource toDataSource(TsMoniker moniker) {
        DataSource result = super.toDataSource(moniker);
        return result != null ? result : (DataSource)this.legacyDataSourceParser.parse((CharSequence)moniker.getId());
    }

    public DataSource encodeBean(Object bean) throws IllegalArgumentException {
        return ((JdbcBean)this.support.checkBean(bean, JdbcBean.class)).toDataSource(this.getSource(), this.version);
    }
}

