/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.jdbc;

import ec.tss.tsproviders.db.DbUtil;
import ec.tss.tsproviders.utils.IParser;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ResultSetFunc<T>
implements DbUtil.Func<ResultSet, T, SQLException> {
    public static @NonNull ResultSetFunc<String> onNull() {
        return NullResultSetFunc.INSTANCE;
    }

    public static @NonNull ResultSetFunc<String> onGetString(final int columnIndex) {
        return new ResultSetFunc<String>(){

            @Override
            public String apply(ResultSet rs) throws SQLException {
                return rs.getString(columnIndex);
            }
        };
    }

    public static @NonNull ResultSetFunc<String[]> onGetStringArray(final int firstColumnIndex, final int length) {
        return new ResultSetFunc<String[]>(){

            @Override
            public String[] apply(ResultSet rs) throws SQLException {
                String[] result = new String[length];
                for (int i = 0; i < length; ++i) {
                    result[i] = rs.getString(firstColumnIndex + i);
                }
                return result;
            }
        };
    }

    public static @NonNull ResultSetFunc<String> onGetObjectToString(final int columnIndex) {
        return new ResultSetFunc<String>(){

            @Override
            public String apply(ResultSet rs) throws SQLException {
                return rs.getObject(columnIndex).toString();
            }
        };
    }

    public static <X> @NonNull ResultSetFunc<X> compose(final int columnIndex, final @NonNull IParser<X> parser) {
        return new ResultSetFunc<X>(){

            @Override
            public X apply(ResultSet rs) throws SQLException {
                return parser.parse((CharSequence)rs.getObject(columnIndex).toString());
            }
        };
    }

    @Deprecated
    public static ResultSetFunc<Date> onDate(ResultSet rs, int columnIndex, IParser<Date> dateParser) throws SQLException {
        return ResultSetFunc.onDate(rs.getMetaData(), columnIndex, dateParser);
    }

    public static @NonNull ResultSetFunc<Date> onDate(@NonNull ResultSetMetaData metaData, int columnIndex, @NonNull IParser<Date> dateParser) throws SQLException {
        ResultSetFunc<Date> result = ResultSetFunc.dateBySqlType(metaData.getColumnType(columnIndex), columnIndex);
        return result != null ? result : ResultSetFunc.compose(columnIndex, dateParser);
    }

    @Deprecated
    public static ResultSetFunc<Number> onNumber(ResultSet rs, int columnIndex, IParser<Number> numberParser) throws SQLException {
        return ResultSetFunc.onNumber(rs.getMetaData(), columnIndex, numberParser);
    }

    public static @NonNull ResultSetFunc<Number> onNumber(@NonNull ResultSetMetaData metaData, int columnIndex, @NonNull IParser<Number> numberParser) throws SQLException {
        ResultSetFunc<Number> result = ResultSetFunc.numberBySqlType(metaData.getColumnType(columnIndex), columnIndex);
        return result != null ? result : ResultSetFunc.compose(columnIndex, numberParser);
    }

    private static @Nullable ResultSetFunc<Date> dateBySqlType(int columnType, final int columnIndex) {
        switch (columnType) {
            case 91: {
                return new ResultSetFunc<Date>(){

                    @Override
                    public Date apply(ResultSet o) throws SQLException {
                        return new Date(o.getDate(columnIndex).getTime());
                    }
                };
            }
            case 93: {
                return new ResultSetFunc<Date>(){

                    @Override
                    public Date apply(ResultSet o) throws SQLException {
                        Timestamp timestamp = o.getTimestamp(columnIndex);
                        return new Date(timestamp.getTime() + (long)(timestamp.getNanos() / 1000000));
                    }
                };
            }
        }
        return null;
    }

    private static @Nullable ResultSetFunc<Number> numberBySqlType(int columnType, final int columnIndex) {
        switch (columnType) {
            case -5: {
                return new ResultSetFunc<Number>(){

                    @Override
                    public Number apply(ResultSet o) throws SQLException {
                        return o.getLong(columnIndex);
                    }
                };
            }
            case 6: 
            case 8: {
                return new ResultSetFunc<Number>(){

                    @Override
                    public Number apply(ResultSet o) throws SQLException {
                        return o.getDouble(columnIndex);
                    }
                };
            }
            case 4: {
                return new ResultSetFunc<Number>(){

                    @Override
                    public Number apply(ResultSet o) throws SQLException {
                        return o.getInt(columnIndex);
                    }
                };
            }
            case 2: 
            case 3: {
                return new ResultSetFunc<Number>(){

                    @Override
                    public Number apply(ResultSet o) throws SQLException {
                        return o.getBigDecimal(columnIndex);
                    }
                };
            }
            case 7: {
                return new ResultSetFunc<Number>(){

                    @Override
                    public Number apply(ResultSet o) throws SQLException {
                        return Float.valueOf(o.getFloat(columnIndex));
                    }
                };
            }
            case 5: {
                return new ResultSetFunc<Number>(){

                    @Override
                    public Number apply(ResultSet o) throws SQLException {
                        return o.getShort(columnIndex);
                    }
                };
            }
        }
        return null;
    }

    private static final class NullResultSetFunc
    extends ResultSetFunc<String> {
        static final ResultSetFunc<String> INSTANCE = new NullResultSetFunc();

        private NullResultSetFunc() {
        }

        @Override
        public String apply(ResultSet input) throws SQLException {
            return null;
        }
    }
}

