/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.jdbc;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import ec.tstoolkit.design.IBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import nbbrd.sql.jdbc.SqlIdentifierQuoter;
import org.checkerframework.checker.nullness.qual.NonNull;

final class SelectBuilder
implements IBuilder<String> {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private final String table;
    private final List<String> select;
    private final List<String> filter;
    private final List<String> order;
    private boolean distinct;
    private SqlIdentifierQuoter identifierQuoter;

    public static @NonNull SelectBuilder from(@NonNull String table) {
        return new SelectBuilder(table);
    }

    private SelectBuilder(@NonNull String table) {
        this.table = table;
        this.select = new ArrayList<String>();
        this.filter = new ArrayList<String>();
        this.order = new ArrayList<String>();
        this.distinct = false;
        this.identifierQuoter = null;
    }

    private @NonNull SelectBuilder addIfNotNullOrEmpty(@NonNull List<String> list, String ... values) {
        for (String o : values) {
            if (Strings.isNullOrEmpty((String)o)) continue;
            list.add(o);
        }
        return this;
    }

    @NonNull SelectBuilder distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @NonNull SelectBuilder select(String ... select) {
        return this.addIfNotNullOrEmpty(this.select, select);
    }

    @NonNull SelectBuilder filter(String ... filter) {
        return this.addIfNotNullOrEmpty(this.filter, filter);
    }

    @NonNull SelectBuilder orderBy(String ... order) {
        return this.addIfNotNullOrEmpty(this.order, order);
    }

    @NonNull SelectBuilder withQuoter(@NonNull SqlIdentifierQuoter identifierQuoter) {
        this.identifierQuoter = identifierQuoter;
        return this;
    }

    public String build() {
        Function<String, String> toQuotedIdentifier = this.identifierQuoter != null ? o -> this.identifierQuoter.quote(o, false) : o -> o;
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        if (this.distinct) {
            result.append("DISTINCT ");
        }
        COMMA_JOINER.appendTo(result, this.select.stream().map(toQuotedIdentifier).iterator());
        result.append(" FROM ").append(toQuotedIdentifier.apply(this.table));
        if (!this.filter.isEmpty()) {
            result.append(" WHERE ");
            Iterator iter = this.filter.stream().map(toQuotedIdentifier).iterator();
            result.append((String)iter.next()).append("=?");
            while (iter.hasNext()) {
                result.append(" AND ").append((String)iter.next()).append("=?");
            }
        }
        if (!this.order.isEmpty()) {
            result.append(" ORDER BY ");
            COMMA_JOINER.appendTo(result, this.order.stream().map(toQuotedIdentifier).iterator());
        }
        return result.toString();
    }
}

