/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.jdbc.dsm.datasource;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import ec.tss.tsproviders.jdbc.dsm.datasource.DataSourceType;
import ec.tss.tsproviders.jdbc.dsm.datasource.DefaultManagedDataSource;
import ec.tss.tsproviders.jdbc.dsm.datasource.interfaces.IManagedDataSource;
import ec.tss.tsproviders.jdbc.dsm.identification.AccountManager;
import ec.tss.tsproviders.jdbc.dsm.identification.aes.AESContentManager;
import ec.tss.tsproviders.jdbc.dsm.identification.aes.KeyGen;
import ec.tstoolkit.utilities.Files2;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import nbbrd.io.xml.bind.Jaxb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public enum DataSourceManager {
    INSTANCE;

    private final Map<String, Map<String, IManagedDataSource>> m_dataSources = new HashMap<String, Map<String, IManagedDataSource>>();
    private final ListMultimap<String, String> m_registered = ArrayListMultimap.create();
    private static final Logger LOGGER;
    final File defaultFile;

    private DataSourceManager() {
        File defaultFolder = Files2.fromPath((String)StandardSystemProperty.USER_HOME.value(), (String[])new String[]{".jdemetra"});
        this.defaultFile = defaultFolder.toPath().resolve("datasources.xml").toFile();
        AccountManager.INSTANCE.setManager(new AESContentManager(defaultFolder, KeyGen.retrieveKeySpec()));
        this.registerDataSourceProvider(DataSourceType.MYSQL.getSourceQualifier(), "Server", "Database");
        this.registerDataSourceProvider(DataSourceType.ORACLE.getSourceQualifier(), "Server", "Port", "SID");
        this.load();
    }

    public void load(File path2file) {
        if (!path2file.exists()) {
            return;
        }
        try {
            XmlDataSources root = (XmlDataSources)Jaxb.Parser.of(XmlDataSources.class).parseFile(path2file);
            for (XmlDataSource xmlProvider : root.dataSources) {
                DefaultManagedDataSource mds = new DefaultManagedDataSource(xmlProvider.provider, null);
                mds.setName(xmlProvider.dbName);
                for (XmlProperty o : xmlProvider.properties) {
                    mds.setProperty(o.name, o.value);
                }
                this.add(xmlProvider.provider, xmlProvider.dbName, mds);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("While loading", (Throwable)ex);
        }
    }

    public void load() {
        this.load(this.defaultFile);
    }

    public void save(File path2file) {
        XmlDataSources root = new XmlDataSources();
        for (String provider : this.m_dataSources.keySet()) {
            for (String dbName : this.m_dataSources.get(provider).keySet()) {
                XmlDataSource xmlProvider = new XmlDataSource();
                xmlProvider.provider = provider;
                xmlProvider.dbName = dbName;
                IManagedDataSource mds = this.getManagedDataSource(provider, dbName);
                for (String property : mds.listProperties()) {
                    XmlProperty xmlProperty = new XmlProperty();
                    xmlProperty.name = property;
                    xmlProperty.value = mds.getProperty(property);
                }
                root.dataSources.add(xmlProvider);
            }
        }
        File parent = path2file.getParentFile();
        if (!parent.exists()) {
            Preconditions.checkState((boolean)parent.mkdir(), (Object)"Cannot create parent directory");
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XmlDataSources.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)root, path2file);
        }
        catch (Exception ex) {
            LOGGER.error("While saving", (Throwable)ex);
        }
    }

    public void save() {
        this.save(this.defaultFile);
    }

    public Set<String> getDatabases(DataSourceType provider) {
        return this.getDatabases(provider.getSourceQualifier());
    }

    public Set<String> getDatabases(String providerQualifier) {
        return this.m_dataSources.get(providerQualifier).keySet();
    }

    public IManagedDataSource getManagedDataSource(String providerQualifier, String dbName) {
        return this.m_dataSources.get(providerQualifier).get(dbName);
    }

    protected Map<String, IManagedDataSource> getMap(String providerQualifier) {
        Map<String, IManagedDataSource> result = this.m_dataSources.get(providerQualifier);
        if (result == null) {
            result = new HashMap<String, IManagedDataSource>();
            this.m_dataSources.put(providerQualifier, result);
        }
        return result;
    }

    public void add(String providerQualifier, String dbName, IManagedDataSource dsDetail) {
        this.getMap(providerQualifier).put(dbName, dsDetail);
    }

    public void remove(String providerQualifier, String dbName) {
        this.getMap(providerQualifier).remove(dbName);
    }

    public List<IManagedDataSource> toList() {
        ArrayList<IManagedDataSource> list = new ArrayList<IManagedDataSource>();
        for (String provider : this.m_dataSources.keySet()) {
            for (String dbName : this.m_dataSources.get(provider).keySet()) {
                list.add(this.getManagedDataSource(provider, dbName));
            }
        }
        return list;
    }

    public void registerDataSourceProvider(String providerQualifier, String ... properties) {
        this.m_registered.putAll((Object)providerQualifier, Arrays.asList(properties));
    }

    public void unregisterDataSourceProvider(String providerQualifier) {
        this.m_registered.removeAll((Object)providerQualifier);
    }

    public Set<String> getProviders() {
        return this.m_dataSources.keySet();
    }

    public Set<String> listDataSourceProviders() {
        return this.m_registered.keySet();
    }

    public List<String> listDataSourceProperties(String provider) {
        return Collections.unmodifiableList(this.m_registered.get((Object)provider));
    }

    static {
        LOGGER = LoggerFactory.getLogger(DataSourceManager.class);
    }

    @XmlRootElement(name="DataSources")
    private static class XmlDataSources {
        @XmlElement(name="DataSource")
        List<XmlDataSource> dataSources = new ArrayList<XmlDataSource>();

        private XmlDataSources() {
        }
    }

    private static class XmlDataSource {
        @XmlAttribute(name="Provider")
        String provider = "";
        @XmlElement(name="Name")
        String dbName = "";
        @XmlElement(name="Property")
        List<XmlProperty> properties = new ArrayList<XmlProperty>();

        private XmlDataSource() {
        }
    }

    private static class XmlProperty {
        @XmlAttribute(name="PropertyName")
        String name = "";
        @XmlValue
        String value = "";

        private XmlProperty() {
        }
    }
}

