/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.jdbc.dsm.identification.aes;

import ec.tss.tsproviders.jdbc.dsm.identification.IContentManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AESContentManager
implements IContentManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AESContentManager.class);
    private final Path m_directory;
    private final SecretKeySpec m_key;

    public AESContentManager(File directory, SecretKeySpec key) {
        this.m_directory = directory.toPath();
        this.m_key = key;
    }

    @Override
    public List<String> getContent() {
        ArrayList<String> result = new ArrayList<String>();
        Path input = this.m_directory.resolve("accounts");
        if (Files.exists(input, new LinkOption[0])) {
            try (InputStream fis = Files.newInputStream(input, new OpenOption[0]);){
                Cipher cipher = Cipher.getInstance("AES");
                cipher.init(2, this.m_key);
                try (CipherInputStream cis = new CipherInputStream(fis, cipher);
                     BufferedReader br = new BufferedReader(new InputStreamReader(cis));){
                    String s;
                    while ((s = br.readLine()) != null) {
                        result.add(s);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("While loading content", (Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public void saveContent(Map<String, String> content) {
        try {
            if (!Files.exists(this.m_directory, new LinkOption[0])) {
                Files.createDirectory(this.m_directory, new FileAttribute[0]);
            }
            Path output = this.m_directory.resolve("accounts");
            Files.createFile(output, new FileAttribute[0]);
            try (OutputStream fos = Files.newOutputStream(output, new OpenOption[0]);){
                Cipher cipher = Cipher.getInstance("AES");
                cipher.init(1, this.m_key);
                try (CipherOutputStream cos = new CipherOutputStream(fos, cipher);
                     PrintWriter pw = new PrintWriter(new OutputStreamWriter(cos));){
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, String> o : content.entrySet()) {
                        sb.append(o.getKey());
                        sb.append("/");
                        sb.append(o.getValue());
                        sb.append("\n");
                    }
                    pw.println(sb.toString());
                    pw.flush();
                }
            }
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException ex) {
            LOGGER.error("While saving content", (Throwable)ex);
        }
    }
}

