/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.jdbc.dsm.identification.aes;

import com.google.common.base.StandardSystemProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class KeyGen {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyGen.class);

    private KeyGen() {
    }

    public static SecretKey getKey() {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(new SecureRandom());
            kgen.init(128);
            SecretKey skey = kgen.generateKey();
            return skey;
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error("Unable to create secret key!", (Throwable)ex);
            return null;
        }
    }

    public static void saveKey(SecretKey skey) {
        KeyGen.saveKey(skey, StandardSystemProperty.USER_HOME.value() + "/.encrypt/", "jdemetra.key");
    }

    public static void saveKey(SecretKey skey, String directory, String file) {
        try {
            Path dir = Paths.get(directory, new String[0]);
            Files.createDirectory(dir, new FileAttribute[0]);
            Path output = dir.resolve(file);
            Files.createFile(output, new FileAttribute[0]);
            try (OutputStream fos = Files.newOutputStream(output, new OpenOption[0]);
                 ObjectOutputStream oos = new ObjectOutputStream(fos);){
                oos.writeObject(skey.getEncoded());
                oos.flush();
            }
        }
        catch (IOException ex) {
            LOGGER.error("While saving key", (Throwable)ex);
        }
    }

    public static SecretKeySpec retrieveKeySpec() {
        return KeyGen.retrieveKeySpec(StandardSystemProperty.USER_HOME.value() + "/.encrypt/jdemetra.key");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static SecretKeySpec retrieveKeySpec(String path) {
        try {
            Path input = Paths.get(path, new String[0]);
            try (InputStream fis = Files.newInputStream(input, new OpenOption[0]);){
                SecretKeySpec secretKeySpec;
                try (ObjectInputStream ois = new ObjectInputStream(fis);){
                    byte[] raw = (byte[])ois.readObject();
                    secretKeySpec = new SecretKeySpec(raw, "AES");
                }
                return secretKeySpec;
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            LOGGER.warn("No key was found... creating a new one.", (Throwable)ex);
            SecretKey sk = KeyGen.getKey();
            KeyGen.saveKey(sk);
            return KeyGen.retrieveKeySpec();
        }
    }
}

