/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.jdbc.jndi;

import ec.tss.TsAsyncMode;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.db.DbAccessor;
import ec.tss.tsproviders.jdbc.ConnectionSupplier;
import ec.tss.tsproviders.jdbc.JdbcAccessor;
import ec.tss.tsproviders.jdbc.JdbcBean;
import ec.tss.tsproviders.jdbc.JdbcProvider;
import ec.tss.tsproviders.utils.IConstraint;
import java.sql.Connection;
import java.sql.SQLException;
import nbbrd.sql.jdbc.SqlConnectionSupplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiJdbcProvider
extends JdbcProvider<JdbcBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JndiJdbcProvider.class);
    public static final String SOURCE = "JNDI-JDBC";
    private static final String VERSION = "20131203";
    private ConnectionSupplier connectionSupplier = JndiJdbcSupplier.INSTANCE;

    public JndiJdbcProvider() {
        super(SOURCE, VERSION, LOGGER, TsAsyncMode.Once);
    }

    protected DbAccessor<JdbcBean> loadFromBean(JdbcBean bean) throws Exception {
        return new JdbcAccessor<JdbcBean>(this.logger, bean, this.connectionSupplier).memoize();
    }

    public JdbcBean newBean() {
        return new JdbcBean();
    }

    public JdbcBean decodeBean(DataSource dataSource) throws IllegalArgumentException {
        return new JdbcBean(this.support.check(dataSource, new IConstraint[0]));
    }

    public String getDisplayName() {
        return "JDBC resource";
    }

    public @NonNull ConnectionSupplier getConnectionSupplier() {
        return this.connectionSupplier;
    }

    public void setConnectionSupplier(@Nullable ConnectionSupplier connectionSupplier) {
        this.connectionSupplier = connectionSupplier != null ? connectionSupplier : JndiJdbcSupplier.INSTANCE;
    }

    private static enum JndiJdbcSupplier implements ConnectionSupplier
    {
        INSTANCE;

        private final SqlConnectionSupplier delegate = SqlConnectionSupplier.ofJndi();

        @Override
        public Connection getConnection(JdbcBean bean) throws SQLException {
            return this.delegate.getConnection(bean.getDbName());
        }
    }
}

