/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.jdbc.oracle;

import ec.tss.TsAsyncMode;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.db.DbAccessor;
import ec.tss.tsproviders.jdbc.ConnectionSupplier;
import ec.tss.tsproviders.jdbc.JdbcAccessor;
import ec.tss.tsproviders.jdbc.JdbcBean;
import ec.tss.tsproviders.jdbc.JdbcProvider;
import ec.tss.tsproviders.jdbc.dsm.datasource.DataSourceManager;
import ec.tss.tsproviders.jdbc.dsm.datasource.DataSourceType;
import ec.tss.tsproviders.jdbc.dsm.datasource.interfaces.IManagedDataSource;
import ec.tss.tsproviders.jdbc.dsm.identification.Account;
import ec.tss.tsproviders.jdbc.dsm.identification.AccountManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class OracleProvider
extends JdbcProvider<JdbcBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleProvider.class);
    public static final String SOURCE = DataSourceType.ORACLE.getSourceQualifier();
    static final String VERSION = "20111201";
    private final ConnectionSupplier.DriverBasedSupplier connectionSupplier = new OracleSupplier();

    public OracleProvider() {
        super(SOURCE, VERSION, LOGGER, TsAsyncMode.Once);
    }

    public boolean isAvailable() {
        return this.connectionSupplier.isDriverAvailable();
    }

    public String getDisplayName() {
        return "Oracle databases";
    }

    protected DbAccessor<JdbcBean> loadFromBean(JdbcBean bean) throws Exception {
        return new JdbcAccessor<JdbcBean>(this.logger, bean, this.connectionSupplier).memoize();
    }

    public JdbcBean newBean() {
        return new JdbcBean();
    }

    public JdbcBean decodeBean(DataSource dataSource) {
        return new JdbcBean(dataSource);
    }

    static class OracleSupplier
    extends ConnectionSupplier.DriverBasedSupplier {
        OracleSupplier() {
        }

        @Override
        protected String getUrl(JdbcBean bean) {
            try {
                Account acc = AccountManager.INSTANCE.getAccount(DataSourceType.ORACLE.getSourceQualifier(), bean.getDbName());
                IManagedDataSource mngDataSource = DataSourceManager.INSTANCE.getManagedDataSource(DataSourceType.ORACLE.getSourceQualifier(), bean.getDbName());
                if (acc != null && mngDataSource != null) {
                    return String.format("jdbc:oracle:thin:%s/%s@%s:%s:%s", acc.getLogin(), acc.getPassword(), mngDataSource.getProperty("Server"), mngDataSource.getProperty("Port"), mngDataSource.getProperty("SID"));
                }
                LOGGER.warn("Unable to retrieve either the account or the datasource information");
                return "";
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to get connection string", (Object)ex.getMessage());
                return "";
            }
        }

        @Override
        protected boolean loadDriver() {
            try {
                Class.forName("oracle.jdbc.driver.OracleDriver");
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
    }
}

