/*
 * Decompiled with CFR 0.152.
 */
package ec.util.jdbc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import nbbrd.sql.jdbc.SqlTable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public final class JdbcTable
implements Comparable<JdbcTable> {
    private final String catalog;
    private final String schema;
    private final String name;
    private final String type;
    private final String remarks;
    private final String typesCatalog;
    private final String typesSchema;
    private final String typeName;
    private final String selfReferencingColumnName;
    private final String refGeneration;
    static final Ordering<String> ORDERING = Ordering.natural().nullsLast();

    public static @NonNull List<JdbcTable> allOf(@NonNull DatabaseMetaData md) throws SQLException {
        return JdbcTable.allOf(md, null, null, "%", null);
    }

    public static @NonNull List<JdbcTable> allOf(@NonNull DatabaseMetaData md, @Nullable String catalog, @Nullable String schemaPattern, @NonNull String tableNamePattern, @Nullable String[] types) throws SQLException {
        return SqlTable.allOf((DatabaseMetaData)md, (String)catalog, (String)schemaPattern, (String)tableNamePattern, (String[])types).stream().map(t -> new JdbcTable(t.getCatalog(), t.getSchema(), t.getName(), t.getType(), t.getRemarks(), t.getTypesCatalog(), t.getTypesSchema(), t.getTypeName(), t.getSelfReferencingColumnName(), t.getRefGeneration())).collect(Collectors.toList());
    }

    public JdbcTable(String catalog, String schema, String name, String type, String remarks, String typesCatalog, String typesSchema, String typeName, String selfReferencingColumnName, String refGeneration) {
        this.catalog = catalog;
        this.schema = schema;
        this.name = Strings.nullToEmpty((String)name);
        this.type = Strings.nullToEmpty((String)type);
        this.remarks = remarks;
        this.typesCatalog = typesCatalog;
        this.typesSchema = typesSchema;
        this.typeName = typeName;
        this.selfReferencingColumnName = selfReferencingColumnName;
        this.refGeneration = refGeneration;
    }

    public @Nullable String getCatalog() {
        return this.catalog;
    }

    public @Nullable String getSchema() {
        return this.schema;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String getType() {
        return this.type;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public @Nullable String getTypesCatalog() {
        return this.typesCatalog;
    }

    public @Nullable String getTypesSchema() {
        return this.typesSchema;
    }

    public @Nullable String getTypeName() {
        return this.typeName;
    }

    public @Nullable String getSelfReferencingColumnName() {
        return this.selfReferencingColumnName;
    }

    public @Nullable String getRefGeneration() {
        return this.refGeneration;
    }

    @Override
    public int compareTo(JdbcTable that) {
        return ComparisonChain.start().compare((Object)this.type, (Object)that.type, ORDERING).compare((Object)this.catalog, (Object)that.catalog, ORDERING).compare((Object)this.schema, (Object)that.schema, ORDERING).compare((Object)this.name, (Object)that.name, ORDERING).result();
    }

    public boolean equals(Object obj) {
        return obj instanceof JdbcTable ? this.equals((JdbcTable)obj) : false;
    }

    private boolean equals(JdbcTable that) {
        return Objects.equals(this.catalog, that.catalog) && Objects.equals(this.schema, that.schema) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.remarks, that.remarks) && Objects.equals(this.typesCatalog, that.typesCatalog) && Objects.equals(this.typesSchema, that.typesSchema) && Objects.equals(this.typeName, that.typeName) && Objects.equals(this.selfReferencingColumnName, that.selfReferencingColumnName) && Objects.equals(this.refGeneration, that.refGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.catalog, this.schema, this.name, this.type, this.remarks, this.typesCatalog, this.typesSchema, this.typeName, this.selfReferencingColumnName, this.refGeneration);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("name", (Object)this.name).add("type", (Object)this.type).add("remarks", (Object)this.remarks).add("typesCatalog", (Object)this.typesCatalog).add("typesSchema", (Object)this.typesSchema).add("typeName", (Object)this.typeName).add("selfReferencingColumnName", (Object)this.selfReferencingColumnName).add("refGeneration", (Object)this.refGeneration).toString();
    }
}

