/*
 * Decompiled with CFR 0.152.
 */
package ec.util.jdbc;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import ec.tstoolkit.design.VisibleForTesting;
import ec.util.jdbc.SqlKeywords;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Set;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public abstract class SqlIdentifierQuoter {
    private static final Splitter KEYWORDS_SPLITTER = Splitter.on((char)',').trimResults();

    public abstract @NonNull String quote(@NonNull String var1, boolean var2);

    public static @NonNull SqlIdentifierQuoter create(@NonNull DatabaseMetaData metaData) throws SQLException {
        return new SqlIdentifierQuoterImpl(nbbrd.sql.jdbc.SqlIdentifierQuoter.of((DatabaseMetaData)metaData));
    }

    @VisibleForTesting
    static @NonNull String getIdentifierQuoteString(@NonNull DatabaseMetaData metaData) throws SQLException {
        String identifierQuoteString = metaData.getIdentifierQuoteString();
        return !SqlIdentifierQuoter.isIdentifierQuotingSupported(identifierQuoteString) ? "\"" : identifierQuoteString;
    }

    @VisibleForTesting
    static @NonNull Set<String> getSqlKeywords(@NonNull DatabaseMetaData metaData) throws SQLException {
        return ImmutableSet.builder().addAll(KEYWORDS_SPLITTER.split((CharSequence)metaData.getSQLKeywords())).addAll(SqlKeywords.getSql2003ReservedWords()).build();
    }

    private static boolean isIdentifierQuotingSupported(@Nullable String identifierQuoteString) {
        return identifierQuoteString != null && !identifierQuoteString.trim().isEmpty();
    }

    private static final class SqlIdentifierQuoterImpl
    extends SqlIdentifierQuoter {
        @lombok.NonNull
        private final nbbrd.sql.jdbc.SqlIdentifierQuoter delegate;

        @Override
        public String quote(String identifier, boolean force) {
            return this.delegate.quote(identifier, force);
        }

        @Generated
        public SqlIdentifierQuoterImpl(@lombok.NonNull nbbrd.sql.jdbc.SqlIdentifierQuoter delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }
    }
}

