/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.output;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.ISaSpecification;
import ec.tss.TsIdentifier;
import ec.tss.TsMoniker;
import ec.tss.sa.documents.SaDocument;
import ec.tss.sa.output.OdbcOutputFactory;
import ec.tss.sa.output.OdbcSaOutputConfiguration;
import ec.tss.sa.output.SaSummary;
import ec.tstoolkit.algorithm.IOutput;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdbcOutput
implements IOutput<SaDocument<ISaSpecification>> {
    public static final Logger LOGGER = LoggerFactory.getLogger(OdbcOutputFactory.class);
    private static final String g_SelectSeries = "SELECT * FROM Series WHERE Processing=? AND Source=? AND Identifier=?";
    private static final String g_InsertSeries = "INSERT INTO Series (Processing, Source, Identifier, Description) VALUES (?,?,?,?)";
    private static final String g_DeleteSeries = "DELETE FROM Series WHERE Processing=? AND Source=? AND Identifier=?";
    private static final String g_DeleteProcessing = "DELETE FROM Series WHERE Processing=?";
    private static final String g_DeleteModel = "DELETE FROM Models WHERE SeriesID=?";
    private static final String g_DeleteObservations = "DELETE FROM Observations WHERE SeriesID=?";
    private static final String g_DeleteAllObservations = "DELETE FROM Observations WHERE SeriesID IN (SELECT ID FROM Series WHERE Processing=? )";
    private static final String g_DeleteAllModels = "DELETE FROM Models WHERE SeriesID IN (SELECT ID FROM Series WHERE Processing=? )";
    private static final String g_InsertObs = "INSERT INTO Observations (SeriesID, ObsPeriod, ObsValue, ObsType) VALUES (?,?,?,?)";
    private static final String g_InsertModel = "INSERT INTO Models (SeriesID, DecompositionType, XmlModel) VALUES (?,?,?)";
    private PreparedStatement selectseriesCmd_;
    private PreparedStatement insertseriesCmd_;
    private PreparedStatement deletemodelCmd_;
    private PreparedStatement deleteseriesCmd_;
    private PreparedStatement deleteprocessingCmd_;
    private PreparedStatement deleteobservationsCmd_;
    private PreparedStatement deleteallobservationsCmd_;
    private PreparedStatement deleteallmodelsCmd_;
    private PreparedStatement insertmodelCmd_;
    private PreparedStatement insertobsCmd_;
    private String dsn_ = "SAResults";
    private boolean orig_ = true;
    private boolean sa_ = true;
    private boolean seas_ = true;
    private boolean trend_ = true;
    private boolean irr_ = true;
    private boolean cal_ = true;
    private boolean model_ = true;
    private Connection connection_ = null;
    private String processing_;

    public OdbcOutput(OdbcSaOutputConfiguration config) {
        this.model_ = config.isSaveModel();
        this.orig_ = config.isSaveOriginal();
        this.sa_ = config.isSaveSa();
        this.seas_ = config.isSaveSeas();
        this.irr_ = config.isSaveIrregular();
        this.cal_ = config.isSaveCalendar();
        this.setConnection(config.getDSN());
    }

    public void closeConnection() throws SQLException {
        this.close();
        this.connection_ = null;
    }

    public void setConnection(String dsn) {
        this.dsn_ = dsn;
    }

    private void open() throws Exception {
        if (this.connection_ == null) {
            try {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            }
            catch (Exception ex) {
                LOGGER.error("Can't load Sun's odbc driver");
                throw ex;
            }
            try {
                String url = this.getConnectionString();
                this.connection_ = DriverManager.getConnection(url);
            }
            catch (SQLException ex) {
                LOGGER.error("Can't open connection");
                throw ex;
            }
        }
    }

    private void close() throws SQLException {
        this.connection_.close();
    }

    protected String getConnectionString() {
        return String.format("jdbc:odbc:%s", this.dsn_);
    }

    public void clear(TsMoniker id) {
        try {
            this.deleteSeries(id);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private short convert(DecompositionMode type) {
        switch (type) {
            case Additive: {
                return 0;
            }
        }
        return 1;
    }

    private void saveModel(int id, DecompositionMode type, String spec) throws Exception {
        this.open();
        try {
            this.insertModel(id, this.convert(type), spec);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void process(SaSummary summary) throws Exception {
        int id = this.getId(summary.Identifier);
        if (id < 0) {
            return;
        }
        try {
            this.deleteModel(id);
            this.deleteObservations(id);
            if (this.model_) {
                this.saveModel(id, summary.Mode, summary.Spec);
            }
            if (this.orig_) {
                this.insertTimeSeries(id, summary.Orig, (short)0);
            }
            if (this.trend_) {
                this.insertTimeSeries(id, summary.T, (short)1);
            }
            if (this.sa_) {
                this.insertTimeSeries(id, summary.SA, (short)2);
            }
            if (this.seas_) {
                this.insertTimeSeries(id, summary.S, (short)3);
            }
            if (this.irr_) {
                this.insertTimeSeries(id, summary.I, (short)5);
            }
            if (this.cal_) {
                this.insertTimeSeries(id, summary.CAL, (short)4);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        LOGGER.debug(summary.Identifier.getName());
    }

    public void delete(String name) throws Exception {
        this.open();
        this.deleteprocessingCmd_ = this.initDeleteProcessing();
        this.deleteallobservationsCmd_ = this.initDeleteAllObservations();
        this.deleteallmodelsCmd_ = this.initDeleteAllModels();
        try {
            this.deleteAllObservations(name);
            this.deleteAllModels(name);
            this.deleteProcessing(name);
            this.connection_.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void start(Object context) throws Exception {
        String file = context.toString();
        if (file != null) {
            this.processing_ = file;
        }
        if (this.processing_ == null || this.processing_.length() == 0) {
            this.processing_ = "TEMP";
        }
        this.open();
        this.selectseriesCmd_ = this.initSelectSeries();
        this.insertseriesCmd_ = this.initInsertSeries();
        this.deletemodelCmd_ = this.initDeleteModel();
        this.deleteobservationsCmd_ = this.initDeleteObservations();
        this.insertmodelCmd_ = this.initInsertModel();
        this.insertobsCmd_ = this.initInsertObservation();
        this.deleteseriesCmd_ = this.initDeleteSeries();
    }

    public void process(SaDocument<ISaSpecification> doc) throws Exception {
        this.process(new SaSummary(doc));
    }

    public void end(Object context) throws Exception {
        this.close();
        this.processing_ = null;
    }

    public String getName() {
        return "ODBC";
    }

    public boolean isAvailable() {
        try {
            boolean rslt;
            this.open();
            boolean bl = rslt = !this.connection_.isClosed();
            if (rslt) {
                this.connection_.close();
            }
            return rslt;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private int getId(TsIdentifier series) throws Exception {
        this.open();
        int id = -1;
        try {
            ResultSet table = this.selectSeries(series);
            id = table.next() ? table.getInt(1) : this.addId(series);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return id;
    }

    private int addId(TsIdentifier series) throws Exception {
        try {
            this.open();
            this.insertSeries(series);
        }
        catch (SQLException ex) {
            return -1;
        }
        return this.getId(series);
    }

    private PreparedStatement initSelectSeries() {
        PreparedStatement command = null;
        try {
            command = this.connection_.prepareStatement(g_SelectSeries);
            return command;
        }
        catch (SQLException sQLException) {}
        finally {
            return command;
        }
    }

    private ResultSet selectSeries(TsIdentifier id) throws SQLException {
        this.selectseriesCmd_.setString(1, this.processing_);
        this.selectseriesCmd_.setString(2, id.getMoniker().getSource());
        this.selectseriesCmd_.setString(3, id.getMoniker().getId());
        return this.selectseriesCmd_.executeQuery();
    }

    private PreparedStatement initInsertSeries() {
        PreparedStatement command = null;
        try {
            command = this.connection_.prepareStatement(g_InsertSeries);
            return command;
        }
        catch (SQLException sQLException) {}
        finally {
            return command;
        }
    }

    private void insertSeries(TsIdentifier id) throws SQLException {
        this.insertseriesCmd_.setString(1, this.processing_);
        this.insertseriesCmd_.setString(2, id.getMoniker().getSource());
        this.insertseriesCmd_.setString(3, id.getMoniker().getId());
        this.insertseriesCmd_.setString(4, id.getName());
        this.insertseriesCmd_.executeUpdate();
    }

    private PreparedStatement initDeleteModel() {
        PreparedStatement command = null;
        try {
            command = this.connection_.prepareStatement(g_DeleteModel);
            return command;
        }
        catch (SQLException sQLException) {}
        finally {
            return command;
        }
    }

    private PreparedStatement initDeleteObservations() {
        PreparedStatement command = null;
        try {
            command = this.connection_.prepareStatement(g_DeleteObservations);
            return command;
        }
        catch (SQLException sQLException) {}
        finally {
            return command;
        }
    }

    private PreparedStatement initDeleteSeries() {
        PreparedStatement command = null;
        try {
            command = this.connection_.prepareStatement(g_DeleteSeries);
            return command;
        }
        catch (SQLException sQLException) {}
        finally {
            return command;
        }
    }

    private PreparedStatement initDeleteProcessing() {
        PreparedStatement command = null;
        try {
            command = this.connection_.prepareStatement(g_DeleteProcessing);
            return command;
        }
        catch (SQLException sQLException) {}
        finally {
            return command;
        }
    }

    private PreparedStatement initDeleteAllObservations() {
        PreparedStatement command = null;
        try {
            command = this.connection_.prepareStatement(g_DeleteAllObservations);
            return command;
        }
        catch (SQLException sQLException) {}
        finally {
            return command;
        }
    }

    private PreparedStatement initDeleteAllModels() {
        PreparedStatement command = null;
        try {
            command = this.connection_.prepareStatement(g_DeleteAllModels);
            return command;
        }
        catch (SQLException sQLException) {}
        finally {
            return command;
        }
    }

    private void deleteSeries(TsMoniker id) throws SQLException {
        this.deleteseriesCmd_.setString(1, this.processing_);
        this.deleteseriesCmd_.setString(2, id.getSource());
        this.deleteseriesCmd_.setString(3, id.getId());
        this.deleteseriesCmd_.execute();
    }

    private void deleteProcessing(String name) throws SQLException {
        this.deleteprocessingCmd_.setString(1, name);
        this.deleteprocessingCmd_.execute();
    }

    private void deleteModel(int id) throws SQLException {
        this.deletemodelCmd_.setInt(1, id);
        this.deletemodelCmd_.execute();
    }

    private void deleteObservations(int id) throws SQLException {
        this.deleteobservationsCmd_.setInt(1, id);
        this.deleteobservationsCmd_.execute();
    }

    private void deleteAllModels(String name) throws SQLException {
        this.deleteallmodelsCmd_.setString(1, name);
        this.deleteallmodelsCmd_.execute();
    }

    private void deleteAllObservations(String name) throws SQLException {
        this.deleteallobservationsCmd_.setString(1, name);
        this.deleteallobservationsCmd_.execute();
    }

    private PreparedStatement initInsertModel() {
        PreparedStatement command = null;
        try {
            command = this.connection_.prepareStatement(g_InsertModel);
            return command;
        }
        catch (SQLException sQLException) {}
        finally {
            return command;
        }
    }

    private PreparedStatement initInsertObservation() {
        PreparedStatement command = null;
        try {
            command = this.connection_.prepareStatement(g_InsertObs);
            return command;
        }
        catch (SQLException sQLException) {}
        finally {
            return command;
        }
    }

    private void insertModel(int id, short type, String p) throws SQLException {
        this.insertmodelCmd_.setInt(1, id);
        this.insertmodelCmd_.setShort(2, type);
        this.insertmodelCmd_.setString(3, p);
        this.insertmodelCmd_.execute();
    }

    private void insertObservation(int id, TsPeriod period, double val, short type) throws SQLException {
        this.insertobsCmd_.setInt(1, id);
        this.insertobsCmd_.setDate(2, new Date(period.lastday().getTime().getTime()));
        this.insertobsCmd_.setDouble(3, val);
        this.insertobsCmd_.setShort(4, type);
        this.insertobsCmd_.execute();
    }

    private void insertTimeSeries(int id, TsData s, short type) throws SQLException {
        if (s == null) {
            return;
        }
        TsPeriod period = s.getStart();
        int i = 0;
        while (i < s.getLength()) {
            this.insertObservation(id, period, s.get(i), type);
            ++i;
            period = period.plus(1);
        }
    }
}

