/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.odbc;

import com.google.common.base.Splitter;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IFileBean;
import ec.tss.tsproviders.jdbc.JdbcBean;
import ec.tss.tsproviders.utils.Formatters;
import ec.tss.tsproviders.utils.Parsers;
import ec.tstoolkit.design.VisibleForTesting;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class OdbcBean
extends JdbcBean
implements IFileBean {
    static final List<FileFilter> FILE_FILTERS = Collections.singletonList(AccessFileFilter.INSTANCE);
    static final Parsers.Parser<File> FILE_PARSERS = new AccessConnectionStringParser();
    static final Formatters.Formatter<File> FILE_FORMATTERS = new AccessConnectionStringFormatter();
    @VisibleForTesting
    static final Splitter.MapSplitter CONNECTION_STRING_SPLITTER = Splitter.on((char)';').trimResults().omitEmptyStrings().withKeyValueSeparator("=");

    public OdbcBean() {
    }

    public OdbcBean(DataSource dataSource) {
        super(dataSource);
    }

    public File getFile() {
        return FILE_PARSERS.parseValue((CharSequence)this.getDbName()).orElse(Paths.get("", new String[0]).toFile());
    }

    public void setFile(File file) {
        this.setDbName(FILE_FORMATTERS.formatValueAsString((Object)file).orElse(""));
    }

    public boolean isDsnLess() {
        return this.getDbName().toUpperCase(Locale.ENGLISH).startsWith("DRIVER");
    }

    static enum AccessFileFilter implements FileFilter
    {
        INSTANCE;


        @Override
        public boolean accept(File pathname) {
            String tmp = pathname.getPath().toLowerCase(Locale.ENGLISH);
            return tmp.endsWith(".mdb") || tmp.endsWith(".accdb");
        }
    }

    static class AccessConnectionStringParser
    extends Parsers.FailSafeParser<File> {
        AccessConnectionStringParser() {
        }

        protected File doParse(CharSequence input) throws Exception {
            String file = (String)CONNECTION_STRING_SPLITTER.split(input).get("DBQ");
            if (file != null) {
                File result = Paths.get(file, new String[0]).toFile();
                return AccessFileFilter.INSTANCE.accept(result) ? result : null;
            }
            return null;
        }
    }

    static class AccessConnectionStringFormatter
    extends Formatters.Formatter<File> {
        AccessConnectionStringFormatter() {
        }

        public CharSequence format(File value) {
            return AccessFileFilter.INSTANCE.accept(value) ? "DRIVER={Microsoft Access Driver (*.mdb, *.accdb)};DBQ=" + value.getPath() : null;
        }
    }
}

